/*
 * Decompiled with CFR 0.152.
 */
package com.botdetector.ui.components;

import javax.swing.JTextArea;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class JLimitedTextArea
extends JTextArea {
    private final int limit;

    public JLimitedTextArea(int limit) {
        this.limit = limit;
    }

    @Override
    protected Document createDefaultModel() {
        return new LimitDocument();
    }

    private class LimitDocument
    extends PlainDocument {
        private LimitDocument() {
        }

        @Override
        public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
            if (str == null) {
                return;
            }
            if (this.getLength() + str.length() <= JLimitedTextArea.this.limit) {
                super.insertString(offset, str, attr);
            }
        }
    }
}

