/*
 * Decompiled with CFR 0.152.
 */
package com.botdetector.ui;

import com.botdetector.BotDetectorConfig;
import com.botdetector.BotDetectorPlugin;
import com.botdetector.events.BotDetectorPanelActivated;
import com.botdetector.http.BotDetectorClient;
import com.botdetector.model.CaseInsensitiveString;
import com.botdetector.model.FeedbackPredictionLabel;
import com.botdetector.model.FeedbackValue;
import com.botdetector.model.PlayerSighting;
import com.botdetector.model.PlayerStats;
import com.botdetector.model.PlayerStatsType;
import com.botdetector.model.Prediction;
import com.botdetector.ui.Icons;
import com.botdetector.ui.NameAutocompleter;
import com.botdetector.ui.PanelFontType;
import com.botdetector.ui.components.ComboBoxSelfTextTooltipListRenderer;
import com.botdetector.ui.components.JLimitedTextArea;
import com.google.common.primitives.Doubles;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.components.IconTextField;
import net.runelite.client.ui.components.materialtabs.MaterialTab;
import net.runelite.client.ui.components.materialtabs.MaterialTabGroup;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.LinkBrowser;
import net.runelite.client.util.QuantityFormatter;
import org.apache.commons.text.StringEscapeUtils;

public class BotDetectorPanel
extends PluginPanel {
    private static final int MAX_RSN_LENGTH = 12;
    private static final Pattern VALID_RSN_PATTERN = Pattern.compile("^[ _\\-]*[a-zA-Z0-9][\\w\\- ]*$");
    private static final Font BOLD_FONT = FontManager.getRunescapeBoldFont();
    private static final Font NORMAL_FONT = FontManager.getRunescapeFont();
    private static final Font SMALL_FONT = FontManager.getRunescapeSmallFont();
    private static final Color BACKGROUND_COLOR = ColorScheme.DARK_GRAY_COLOR;
    private static final Color SUB_BACKGROUND_COLOR = ColorScheme.DARKER_GRAY_COLOR;
    private static final Color LINK_HEADER_COLOR = ColorScheme.LIGHT_GRAY_COLOR;
    private static final Color HEADER_COLOR = Color.WHITE;
    private static final Color TEXT_COLOR = ColorScheme.LIGHT_GRAY_COLOR;
    private static final Color VALUE_COLOR = Color.WHITE;
    private static final Color ERROR_COLOR = ColorScheme.PROGRESS_ERROR_COLOR;
    private static final Color POSITIVE_BUTTON_COLOR = ColorScheme.PROGRESS_COMPLETE_COLOR;
    private static final Color NEUTRAL_BUTTON_COLOR = ColorScheme.PROGRESS_INPROGRESS_COLOR;
    private static final Color NEGATIVE_BUTTON_COLOR = ColorScheme.PROGRESS_ERROR_COLOR;
    private static final String EMPTY_LABEL = "---";
    private static final int HEADER_PAD = 3;
    private static final int WARNING_PAD = 5;
    private static final int VALUE_PAD = 2;
    private static final int SUB_PANEL_SEPARATION_HEIGHT = 10;
    private static final Border SUB_PANEL_BORDER = new EmptyBorder(5, 10, 10, 10);
    private static final Dimension HEADER_PREFERRED_SIZE = new Dimension(0, 25);
    private static final int MAX_FEEDBACK_TEXT_CHARS = 250;
    private static final Dimension FEEDBACK_TEXTBOX_PREFERRED_SIZE = new Dimension(0, 75);
    private static final FeedbackPredictionLabel UNSURE_PREDICTION_LABEL = new FeedbackPredictionLabel("Unsure", null, FeedbackValue.NEUTRAL);
    private static final FeedbackPredictionLabel SOMETHING_ELSE_PREDICTION_LABEL = new FeedbackPredictionLabel("Something_else", null, FeedbackValue.NEGATIVE);
    private static final FeedbackPredictionLabel CORRECT_FALLBACK_PREDICTION_LABEL = new FeedbackPredictionLabel("Correct", null, FeedbackValue.POSITIVE);
    private static final PlayerStatsType[] PLAYER_STAT_TYPES = new PlayerStatsType[]{PlayerStatsType.TOTAL, PlayerStatsType.PASSIVE, PlayerStatsType.MANUAL};
    private final IconTextField searchBar;
    private final JPanel linksPanel;
    private final JPanel playerStatsPanel;
    private final JPanel primaryPredictionPanel;
    private final JPanel predictionFeedbackPanel;
    private final JPanel predictionFlaggingPanel;
    private final JPanel predictionBreakdownPanel;
    private final BotDetectorPlugin plugin;
    private final BotDetectorClient detectorClient;
    private final BotDetectorConfig config;
    private final NameAutocompleter nameAutocompleter;
    private final EventBus eventBus;
    private final Set<JComponent> switchableFontComponents = new HashSet<JComponent>();
    private boolean statsLoading;
    private boolean searchBarLoading;
    private JLabel playerStatsHeaderLabel;
    private JLabel playerStatsPluginVersionLabel;
    private JLabel playerStatsUploadedNamesLabel;
    private JLabel playerStatsTotalUploadsLabel;
    private JLabel playerStatsFeedbackSentLabel;
    private JLabel playerStatsPossibleBansLabel;
    private JLabel playerStatsConfirmedBansLabel;
    private JLabel playerStatsIncorrectFlagsLabel;
    private JLabel playerStatsFlagAccuracyLabel;
    private final Map<WarningLabel, JLabel> warningLabels = new HashMap<WarningLabel, JLabel>();
    private Map<PlayerStatsType, PlayerStats> playerStatsMap;
    private int playerCurrentManualUploads;
    private int playerCurrentPassiveUploads;
    private final MaterialTabGroup playerStatsTabGroup;
    private PlayerStatsType currentPlayerStatsType;
    private JLabel predictionPlayerIdTextLabel;
    private JLabel predictionPlayerIdLabel;
    private JLabel predictionPlayerNameLabel;
    private JLabel predictionTypeLabel;
    private JLabel predictionConfidenceLabel;
    private JLabel predictionBreakdownLabel;
    private JLabel feedbackHeaderLabel;
    private JComboBox<FeedbackPredictionLabel> feedbackLabelComboBox;
    private JButton feedbackSendButton;
    private JScrollPane feedbackTextScrollPane;
    private JLimitedTextArea feedbackTextbox;
    private JLabel flaggingHeaderLabel;
    private JButton flaggingYesButton;
    private JButton flaggingNoButton;
    private Prediction lastPrediction;
    private PlayerSighting lastPredictionPlayerSighting;
    private String lastPredictionUploaderName;

    @Inject
    public BotDetectorPanel(BotDetectorPlugin plugin, BotDetectorClient detectorClient, BotDetectorConfig config, NameAutocompleter nameAutocompleter, EventBus eventBus) {
        this.plugin = plugin;
        this.detectorClient = detectorClient;
        this.config = config;
        this.nameAutocompleter = nameAutocompleter;
        this.eventBus = eventBus;
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.setBackground(BACKGROUND_COLOR);
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.currentPlayerStatsType = config.panelDefaultStatsType();
        this.searchBar = this.playerSearchBar();
        this.linksPanel = this.linksPanel();
        this.playerStatsTabGroup = this.playerStatsTabGroup();
        this.playerStatsPanel = this.playerStatsPanel();
        this.primaryPredictionPanel = this.primaryPredictionPanel();
        this.predictionFeedbackPanel = BotDetectorPanel.putInBoxPanelWithVerticalSeparator(this.predictionFeedbackPanel());
        this.predictionFeedbackPanel.setVisible(false);
        this.predictionFlaggingPanel = BotDetectorPanel.putInBoxPanelWithVerticalSeparator(this.predictionFlaggingPanel());
        this.predictionFlaggingPanel.setVisible(false);
        this.predictionBreakdownPanel = BotDetectorPanel.putInBoxPanelWithVerticalSeparator(this.predictionBreakdownPanel());
        this.predictionBreakdownPanel.setVisible(false);
        this.add(this.linksPanel);
        this.add(Box.createVerticalStrut(10));
        this.add(this.playerStatsPanel);
        this.add(Box.createVerticalStrut(10));
        this.add((Component)this.searchBar);
        this.add(Box.createVerticalStrut(10));
        this.add(this.primaryPredictionPanel);
        this.add(this.predictionBreakdownPanel);
        this.add(this.predictionFeedbackPanel);
        this.add(this.predictionFlaggingPanel);
        this.setPlayerIdVisible(false);
        this.setPrediction(null);
        this.setPlayerStatsMap(null);
        this.setFontType(config.panelFontType());
        this.addInputKeyListener(nameAutocompleter);
    }

    public void shutdown() {
        this.removeInputKeyListener(this.nameAutocompleter);
    }

    public void onActivate() {
        this.eventBus.post((Object)new BotDetectorPanelActivated());
    }

    private static JPanel putInBoxPanelWithVerticalSeparator(JPanel panel) {
        JPanel newPanel = new JPanel();
        newPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        newPanel.setLayout(new BoxLayout(newPanel, 1));
        newPanel.add(Box.createVerticalStrut(10));
        newPanel.add(panel);
        return newPanel;
    }

    private JPanel linksPanel() {
        JPanel linksPanel = new JPanel();
        linksPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        linksPanel.setBackground(SUB_BACKGROUND_COLOR);
        JLabel title = new JLabel("Connect With Us: ");
        title.setForeground(LINK_HEADER_COLOR);
        title.setFont(NORMAL_FONT);
        linksPanel.add(title);
        for (final WebLink w : WebLink.values()) {
            JLabel link = new JLabel(w.getImage());
            link.setToolTipText(w.getTooltip());
            link.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    LinkBrowser.browse((String)w.getLink());
                }
            });
            linksPanel.add(link);
        }
        return linksPanel;
    }

    private MaterialTabGroup playerStatsTabGroup() {
        MaterialTabGroup tabGroup = new MaterialTabGroup();
        tabGroup.setLayout((LayoutManager)new GridLayout(1, PLAYER_STAT_TYPES.length, 7, 7));
        tabGroup.setBorder((Border)new EmptyBorder(2, 0, 2, 0));
        for (PlayerStatsType pst : PLAYER_STAT_TYPES) {
            MaterialTab tab = new MaterialTab(pst.getShorthand(), tabGroup, null);
            tab.setToolTipText(pst.getDescription());
            tab.setFont(SMALL_FONT);
            tab.setHorizontalAlignment(0);
            tab.setOnSelectEvent(() -> {
                this.currentPlayerStatsType = pst;
                return true;
            });
            tab.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    BotDetectorPanel.this.updatePlayerStatsLabels();
                }
            });
            tabGroup.addTab(tab);
            if (this.currentPlayerStatsType != pst) continue;
            tabGroup.select(tab);
        }
        return tabGroup;
    }

    private JPanel playerStatsPanel() {
        JPanel uploadingStatsPanel = new JPanel();
        uploadingStatsPanel.setBackground(SUB_BACKGROUND_COLOR);
        uploadingStatsPanel.setBorder(SUB_PANEL_BORDER);
        uploadingStatsPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        this.playerStatsHeaderLabel = new JLabel("Player Statistics");
        this.playerStatsHeaderLabel.setHorizontalTextPosition(2);
        this.playerStatsHeaderLabel.setFont(BOLD_FONT);
        this.playerStatsHeaderLabel.setForeground(HEADER_COLOR);
        this.playerStatsHeaderLabel.setPreferredSize(HEADER_PREFERRED_SIZE);
        this.playerStatsHeaderLabel.setMinimumSize(HEADER_PREFERRED_SIZE);
        c.gridx = 0;
        c.gridy = 0;
        c.ipady = 3;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.anchor = 11;
        uploadingStatsPanel.add((Component)this.playerStatsHeaderLabel, c);
        JLabel label = new JLabel("Plugin Version: ");
        label.setToolTipText("The Bot Detector plugin version you're running.");
        label.setForeground(TEXT_COLOR);
        c.gridy = 1;
        ++c.gridy;
        c.ipady = 2;
        c.gridwidth = 1;
        c.weightx = 0.0;
        uploadingStatsPanel.add((Component)label, c);
        this.switchableFontComponents.add(label);
        this.playerStatsPluginVersionLabel = new JLabel();
        this.playerStatsPluginVersionLabel.setForeground(VALUE_COLOR);
        c.gridx = 1;
        c.weightx = 1.0;
        uploadingStatsPanel.add((Component)this.playerStatsPluginVersionLabel, c);
        this.switchableFontComponents.add(this.playerStatsPluginVersionLabel);
        label = new JLabel("Current Uploads: ");
        label.setToolTipText("How many names uploaded during the current Runelite session.");
        label.setForeground(TEXT_COLOR);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        uploadingStatsPanel.add((Component)label, c);
        this.switchableFontComponents.add(label);
        this.playerStatsUploadedNamesLabel = new JLabel();
        this.playerStatsUploadedNamesLabel.setForeground(VALUE_COLOR);
        c.gridx = 1;
        c.weightx = 1.0;
        uploadingStatsPanel.add((Component)this.playerStatsUploadedNamesLabel, c);
        this.switchableFontComponents.add(this.playerStatsUploadedNamesLabel);
        label = new JLabel("Total Uploads: ");
        label.setToolTipText("How many unique names sent to us that were attributed to you.");
        label.setForeground(TEXT_COLOR);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        uploadingStatsPanel.add((Component)label, c);
        this.switchableFontComponents.add(label);
        this.playerStatsTotalUploadsLabel = new JLabel();
        this.playerStatsTotalUploadsLabel.setForeground(VALUE_COLOR);
        c.gridx = 1;
        c.weightx = 1.0;
        uploadingStatsPanel.add((Component)this.playerStatsTotalUploadsLabel, c);
        this.switchableFontComponents.add(this.playerStatsTotalUploadsLabel);
        label = new JLabel("Feedback Sent: ");
        label.setToolTipText("How many prediction feedbacks you've sent us.");
        label.setForeground(TEXT_COLOR);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        uploadingStatsPanel.add((Component)label, c);
        this.switchableFontComponents.add(label);
        this.playerStatsFeedbackSentLabel = new JLabel();
        this.playerStatsFeedbackSentLabel.setForeground(VALUE_COLOR);
        c.gridx = 1;
        c.weightx = 1.0;
        uploadingStatsPanel.add((Component)this.playerStatsFeedbackSentLabel, c);
        this.switchableFontComponents.add(this.playerStatsFeedbackSentLabel);
        label = new JLabel("Possible Bans: ");
        label.setToolTipText("<html>How many of your uploaded names may have been banned.<br>For example: Names that no longer appear on the Hiscores.</html>");
        label.setForeground(TEXT_COLOR);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        uploadingStatsPanel.add((Component)label, c);
        this.switchableFontComponents.add(label);
        this.playerStatsPossibleBansLabel = new JLabel();
        this.playerStatsPossibleBansLabel.setForeground(VALUE_COLOR);
        c.gridx = 1;
        c.weightx = 1.0;
        uploadingStatsPanel.add((Component)this.playerStatsPossibleBansLabel, c);
        this.switchableFontComponents.add(this.playerStatsPossibleBansLabel);
        label = new JLabel("Confirmed Bans: ");
        label.setToolTipText("How many of your uploaded names were confirmed to have been banned by Jagex.");
        label.setForeground(TEXT_COLOR);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        uploadingStatsPanel.add((Component)label, c);
        this.switchableFontComponents.add(label);
        this.playerStatsConfirmedBansLabel = new JLabel();
        this.playerStatsConfirmedBansLabel.setForeground(VALUE_COLOR);
        c.gridx = 1;
        c.weightx = 1.0;
        uploadingStatsPanel.add((Component)this.playerStatsConfirmedBansLabel, c);
        this.switchableFontComponents.add(this.playerStatsConfirmedBansLabel);
        label = new JLabel("Incorrect Flags: ");
        label.setToolTipText("How many of your flagged names were confirmed to have been real players by Jagex.");
        label.setForeground(TEXT_COLOR);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        uploadingStatsPanel.add((Component)label, c);
        this.switchableFontComponents.add(label);
        this.playerStatsIncorrectFlagsLabel = new JLabel();
        this.playerStatsIncorrectFlagsLabel.setForeground(VALUE_COLOR);
        c.gridx = 1;
        c.weightx = 1.0;
        uploadingStatsPanel.add((Component)this.playerStatsIncorrectFlagsLabel, c);
        this.switchableFontComponents.add(this.playerStatsIncorrectFlagsLabel);
        label = new JLabel("Flag Accuracy: ");
        label.setToolTipText("How accurate your flagging has been.");
        label.setForeground(TEXT_COLOR);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        uploadingStatsPanel.add((Component)label, c);
        this.switchableFontComponents.add(label);
        this.playerStatsFlagAccuracyLabel = new JLabel();
        this.playerStatsFlagAccuracyLabel.setForeground(VALUE_COLOR);
        c.gridx = 1;
        c.weightx = 1.0;
        uploadingStatsPanel.add((Component)this.playerStatsFlagAccuracyLabel, c);
        this.switchableFontComponents.add(this.playerStatsFlagAccuracyLabel);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 1.0;
        c.gridwidth = 2;
        c.ipady = 0;
        uploadingStatsPanel.add((Component)this.playerStatsTabGroup, c);
        c.ipady = 5;
        for (WarningLabel wl : WarningLabel.values()) {
            ++c.gridy;
            label = new JLabel(wl.getMessage());
            label.setToolTipText(wl.getTooltip());
            label.setIcon(wl.getImage());
            label.setFont(NORMAL_FONT);
            label.setForeground(HEADER_COLOR);
            label.setVisible(false);
            uploadingStatsPanel.add((Component)label, c);
            this.warningLabels.put(wl, label);
        }
        return uploadingStatsPanel;
    }

    private IconTextField playerSearchBar() {
        IconTextField searchBar = new IconTextField();
        searchBar.setIcon(IconTextField.Icon.SEARCH);
        searchBar.setPreferredSize(new Dimension(205, 30));
        searchBar.setBackground(SUB_BACKGROUND_COLOR);
        searchBar.setHoverBackgroundColor(ColorScheme.DARK_GRAY_HOVER_COLOR);
        searchBar.setMinimumSize(new Dimension(0, 30));
        searchBar.addActionListener(e -> this.predictPlayer());
        searchBar.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                String name = BotDetectorPanel.this.plugin.getLoggedPlayerName();
                if (name != null) {
                    BotDetectorPanel.this.predictPlayer(name);
                }
            }
        });
        searchBar.addClearListener(() -> {
            searchBar.setIcon(IconTextField.Icon.SEARCH);
            searchBar.setEditable(true);
            this.searchBarLoading = false;
        });
        return searchBar;
    }

    private JPanel primaryPredictionPanel() {
        JPanel primaryPredictionPanel = new JPanel();
        primaryPredictionPanel.setBackground(SUB_BACKGROUND_COLOR);
        primaryPredictionPanel.setLayout(new GridBagLayout());
        primaryPredictionPanel.setBorder(SUB_PANEL_BORDER);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        JLabel label = new JLabel("Primary Prediction");
        label.setFont(BOLD_FONT);
        label.setForeground(HEADER_COLOR);
        label.setPreferredSize(HEADER_PREFERRED_SIZE);
        label.setMinimumSize(HEADER_PREFERRED_SIZE);
        c.gridx = 0;
        c.gridy = 0;
        c.ipady = 3;
        c.gridwidth = 2;
        c.weightx = 1.0;
        primaryPredictionPanel.add((Component)label, c);
        this.predictionPlayerIdTextLabel = new JLabel("Player ID: ");
        this.predictionPlayerIdTextLabel.setForeground(TEXT_COLOR);
        c.gridy = 1;
        ++c.gridy;
        c.ipady = 2;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.anchor = 11;
        primaryPredictionPanel.add((Component)this.predictionPlayerIdTextLabel, c);
        this.switchableFontComponents.add(this.predictionPlayerIdTextLabel);
        this.predictionPlayerIdLabel = new JLabel();
        c.gridx = 1;
        c.weightx = 1.0;
        primaryPredictionPanel.add((Component)this.predictionPlayerIdLabel, c);
        this.switchableFontComponents.add(this.predictionPlayerIdLabel);
        label = new JLabel("Player Name: ");
        label.setForeground(TEXT_COLOR);
        c.gridx = 0;
        c.weightx = 0.0;
        ++c.gridy;
        primaryPredictionPanel.add((Component)label, c);
        this.switchableFontComponents.add(label);
        this.predictionPlayerNameLabel = new JLabel();
        c.gridx = 1;
        c.weightx = 1.0;
        primaryPredictionPanel.add((Component)this.predictionPlayerNameLabel, c);
        this.switchableFontComponents.add(this.predictionPlayerNameLabel);
        label = new JLabel("Prediction: ");
        label.setForeground(TEXT_COLOR);
        c.gridx = 0;
        c.weightx = 0.0;
        ++c.gridy;
        primaryPredictionPanel.add((Component)label, c);
        this.switchableFontComponents.add(label);
        this.predictionTypeLabel = new JLabel();
        c.gridx = 1;
        c.weightx = 1.0;
        primaryPredictionPanel.add((Component)this.predictionTypeLabel, c);
        this.switchableFontComponents.add(this.predictionTypeLabel);
        label = new JLabel("Confidence: ");
        label.setForeground(TEXT_COLOR);
        c.gridx = 0;
        c.weightx = 0.0;
        ++c.gridy;
        primaryPredictionPanel.add((Component)label, c);
        this.switchableFontComponents.add(label);
        this.predictionConfidenceLabel = new JLabel();
        c.gridx = 1;
        c.weightx = 1.0;
        primaryPredictionPanel.add((Component)this.predictionConfidenceLabel, c);
        this.switchableFontComponents.add(this.predictionConfidenceLabel);
        return primaryPredictionPanel;
    }

    private JPanel predictionFeedbackPanel() {
        JPanel panel = new JPanel();
        panel.setBackground(SUB_BACKGROUND_COLOR);
        panel.setLayout(new GridBagLayout());
        panel.setBorder(SUB_PANEL_BORDER);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        this.feedbackHeaderLabel = new JLabel("Send a prediction feedback?");
        this.feedbackHeaderLabel.setHorizontalTextPosition(2);
        this.feedbackHeaderLabel.setFont(NORMAL_FONT);
        this.feedbackHeaderLabel.setForeground(HEADER_COLOR);
        this.feedbackHeaderLabel.setPreferredSize(HEADER_PREFERRED_SIZE);
        this.feedbackHeaderLabel.setMinimumSize(HEADER_PREFERRED_SIZE);
        c.gridx = 0;
        c.gridy = 0;
        c.ipady = 3;
        c.gridwidth = 3;
        c.weightx = 1.0;
        panel.add((Component)this.feedbackHeaderLabel, c);
        this.feedbackTextbox = new JLimitedTextArea(250);
        this.feedbackTextbox.setToolTipText("Please explain your feedback (max 250 characters).");
        this.feedbackTextbox.setForeground(HEADER_COLOR);
        this.feedbackTextbox.setBackground(BACKGROUND_COLOR);
        this.feedbackTextbox.setFont(SMALL_FONT);
        this.feedbackTextbox.setWrapStyleWord(true);
        this.feedbackTextbox.setLineWrap(true);
        this.feedbackTextbox.setTabSize(2);
        this.feedbackTextbox.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.feedbackTextScrollPane = new JScrollPane(this.feedbackTextbox);
        this.feedbackTextScrollPane.setVerticalScrollBarPolicy(22);
        this.feedbackTextScrollPane.setPreferredSize(FEEDBACK_TEXTBOX_PREFERRED_SIZE);
        this.feedbackTextScrollPane.setMinimumSize(FEEDBACK_TEXTBOX_PREFERRED_SIZE);
        this.feedbackTextScrollPane.setBorder(new EmptyBorder(0, 0, 10, 0));
        this.feedbackTextScrollPane.setOpaque(false);
        ++c.gridy;
        panel.add((Component)this.feedbackTextScrollPane, c);
        JLabel label = new JLabel("Please select the correct label:");
        label.setHorizontalTextPosition(2);
        label.setForeground(HEADER_COLOR);
        label.setFont(NORMAL_FONT);
        ++c.gridy;
        panel.add((Component)label, c);
        this.feedbackLabelComboBox = new JComboBox();
        this.feedbackLabelComboBox.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                Object o = this.feedbackLabelComboBox.getSelectedItem();
                this.feedbackLabelComboBox.setToolTipText(o != null ? o.toString() : null);
            }
        });
        this.feedbackLabelComboBox.setRenderer(new ComboBoxSelfTextTooltipListRenderer());
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.6666666666666666;
        c.gridwidth = 2;
        panel.add(this.feedbackLabelComboBox, c);
        this.feedbackSendButton = new JButton("Send");
        this.feedbackSendButton.setToolTipText("<html>Tell us the correct label for <b>primary prediction</b>! Doing so will help us improve our model.<br><span style='color:red'>Please</span>, do not vote against a prediction simply because the percentage is not high enough.</html>");
        this.feedbackSendButton.setForeground(HEADER_COLOR);
        this.feedbackSendButton.setFont(SMALL_FONT);
        this.feedbackSendButton.addActionListener(l -> this.sendFeedbackToClient((FeedbackPredictionLabel)this.feedbackLabelComboBox.getSelectedItem()));
        this.feedbackSendButton.setFocusable(false);
        c.gridx = 2;
        c.weightx = 0.3333333333333333;
        c.gridwidth = 1;
        panel.add((Component)this.feedbackSendButton, c);
        return panel;
    }

    private JPanel predictionFlaggingPanel() {
        JPanel panel = new JPanel();
        panel.setBackground(SUB_BACKGROUND_COLOR);
        panel.setLayout(new GridBagLayout());
        panel.setBorder(SUB_PANEL_BORDER);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        this.flaggingHeaderLabel = new JLabel("Flag this player as a bot?");
        this.flaggingHeaderLabel.setHorizontalTextPosition(2);
        this.flaggingHeaderLabel.setFont(NORMAL_FONT);
        this.flaggingHeaderLabel.setForeground(HEADER_COLOR);
        this.flaggingHeaderLabel.setPreferredSize(HEADER_PREFERRED_SIZE);
        this.flaggingHeaderLabel.setMinimumSize(HEADER_PREFERRED_SIZE);
        c.gridx = 0;
        c.gridy = 0;
        c.ipady = 3;
        c.gridwidth = 2;
        c.weightx = 1.0;
        panel.add((Component)this.flaggingHeaderLabel, c);
        this.flaggingYesButton = new JButton("Yes");
        this.flaggingYesButton.setToolTipText("<html>This is <span style='color:red'>NOT</span> the same as reporting the player in-game!<br>Flagging a player as a bot tells us to pay more attention to them when training our model.</html>");
        this.flaggingYesButton.setForeground(HEADER_COLOR);
        this.flaggingYesButton.setFont(SMALL_FONT);
        this.flaggingYesButton.addActionListener(l -> this.sendFlagToClient(true));
        this.flaggingYesButton.setFocusable(false);
        ++c.gridy;
        c.weightx = 0.5;
        c.gridwidth = 1;
        panel.add((Component)this.flaggingYesButton, c);
        this.flaggingNoButton = new JButton("No");
        this.flaggingNoButton.setForeground(HEADER_COLOR);
        this.flaggingNoButton.setFont(SMALL_FONT);
        this.flaggingNoButton.addActionListener(l -> this.sendFlagToClient(false));
        this.flaggingNoButton.setFocusable(false);
        ++c.gridx;
        panel.add((Component)this.flaggingNoButton, c);
        return panel;
    }

    private JPanel predictionBreakdownPanel() {
        JPanel predictionBreakdownPanel = new JPanel();
        predictionBreakdownPanel.setBackground(SUB_BACKGROUND_COLOR);
        predictionBreakdownPanel.setBorder(SUB_PANEL_BORDER);
        predictionBreakdownPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        JLabel label = new JLabel("Prediction Breakdown");
        label.setFont(BOLD_FONT);
        label.setForeground(HEADER_COLOR);
        label.setPreferredSize(HEADER_PREFERRED_SIZE);
        label.setMinimumSize(HEADER_PREFERRED_SIZE);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.ipady = 3;
        predictionBreakdownPanel.add((Component)label, c);
        this.predictionBreakdownLabel = new JLabel();
        this.predictionBreakdownLabel.setForeground(TEXT_COLOR);
        c.anchor = 20;
        ++c.gridy;
        predictionBreakdownPanel.add((Component)this.predictionBreakdownLabel, c);
        this.switchableFontComponents.add(this.predictionBreakdownLabel);
        return predictionBreakdownPanel;
    }

    public void setPluginVersion(String pluginVersion) {
        this.playerStatsPluginVersionLabel.setText(pluginVersion);
    }

    public void setNamesUploaded(int num, boolean manual) {
        if (manual) {
            this.playerCurrentManualUploads = num;
        } else {
            this.playerCurrentPassiveUploads = num;
        }
        this.updateCurrentUploadsLabel();
    }

    public void setPlayerStatsMap(Map<PlayerStatsType, PlayerStats> psm) {
        this.playerStatsMap = psm;
        this.updatePlayerStatsLabels();
    }

    private void updatePlayerStatsLabels() {
        PlayerStats totalStats;
        PlayerStats ps;
        PlayerStats playerStats = ps = this.playerStatsMap != null ? this.playerStatsMap.get((Object)this.currentPlayerStatsType) : null;
        if (ps != null) {
            this.playerStatsTotalUploadsLabel.setText(QuantityFormatter.formatNumber((long)ps.getNamesUploaded()));
            this.playerStatsConfirmedBansLabel.setText(QuantityFormatter.formatNumber((long)ps.getConfirmedBans()));
            this.playerStatsPossibleBansLabel.setText(QuantityFormatter.formatNumber((long)ps.getPossibleBans()));
            if (this.currentPlayerStatsType.canDisplayAccuracy()) {
                this.playerStatsIncorrectFlagsLabel.setText(QuantityFormatter.formatNumber((long)ps.getIncorrectFlags()));
                this.playerStatsFlagAccuracyLabel.setText(BotDetectorPanel.wrapHTML(BotDetectorPanel.toColoredPercentSpan(ps.getAccuracy()), false));
            } else {
                this.playerStatsIncorrectFlagsLabel.setText(EMPTY_LABEL);
                this.playerStatsFlagAccuracyLabel.setText(EMPTY_LABEL);
            }
        } else {
            this.playerStatsTotalUploadsLabel.setText(EMPTY_LABEL);
            this.playerStatsConfirmedBansLabel.setText(EMPTY_LABEL);
            this.playerStatsPossibleBansLabel.setText(EMPTY_LABEL);
            this.playerStatsIncorrectFlagsLabel.setText(EMPTY_LABEL);
            this.playerStatsFlagAccuracyLabel.setText(EMPTY_LABEL);
        }
        PlayerStats playerStats2 = totalStats = this.playerStatsMap != null ? this.playerStatsMap.get((Object)PlayerStatsType.TOTAL) : null;
        if (totalStats != null) {
            this.playerStatsFeedbackSentLabel.setText(QuantityFormatter.formatNumber((long)totalStats.getFeedbackSent()));
        } else {
            this.playerStatsFeedbackSentLabel.setText(EMPTY_LABEL);
        }
        this.updateCurrentUploadsLabel();
    }

    private void updateCurrentUploadsLabel() {
        int val;
        switch (this.currentPlayerStatsType) {
            case MANUAL: {
                val = this.playerCurrentManualUploads;
                break;
            }
            case PASSIVE: {
                val = this.playerCurrentPassiveUploads;
                break;
            }
            default: {
                val = this.playerCurrentManualUploads + this.playerCurrentPassiveUploads;
            }
        }
        this.playerStatsUploadedNamesLabel.setText(QuantityFormatter.formatNumber((long)val));
    }

    public boolean getWarningVisible(WarningLabel wl) {
        JLabel label = this.warningLabels.get((Object)wl);
        return label != null && label.isVisible();
    }

    public void setWarningVisible(WarningLabel wl, boolean visible) {
        JLabel label = this.warningLabels.get((Object)wl);
        if (label != null) {
            label.setVisible(visible);
        }
    }

    public void setPlayerStatsLoading(boolean loading) {
        this.statsLoading = loading;
        this.playerStatsHeaderLabel.setIcon(loading ? Icons.LOADING_SPINNER : null);
    }

    public void setPlayerIdVisible(boolean visible) {
        this.predictionPlayerIdTextLabel.setVisible(visible);
        this.predictionPlayerIdLabel.setVisible(visible);
    }

    public void setFeedbackTextboxVisible(boolean visible) {
        this.feedbackTextScrollPane.setVisible(visible);
    }

    public void forceHideFeedbackPanel() {
        this.predictionFeedbackPanel.setVisible(false);
    }

    public void forceHideFlaggingPanel() {
        this.predictionFlaggingPanel.setVisible(false);
    }

    private void setPredictionLabelsColor(Color color) {
        this.predictionPlayerIdLabel.setForeground(color);
        this.predictionPlayerNameLabel.setForeground(color);
        this.predictionTypeLabel.setForeground(color);
        this.predictionConfidenceLabel.setForeground(color);
    }

    public void setPrediction(Prediction pred) {
        this.setPrediction(pred, null);
    }

    public void setPrediction(Prediction pred, PlayerSighting sighting) {
        this.setPredictionLabelsColor(VALUE_COLOR);
        this.feedbackLabelComboBox.removeAllItems();
        if (pred != null) {
            boolean isNullConfidence = pred.getConfidence() == null;
            this.nameAutocompleter.addToSearchHistory(pred.getPlayerName().toLowerCase());
            this.lastPrediction = pred;
            this.lastPredictionPlayerSighting = sighting;
            this.lastPredictionUploaderName = this.plugin.getUploaderName(true);
            this.predictionPlayerIdLabel.setText(String.valueOf(pred.getPlayerId()));
            this.predictionPlayerNameLabel.setText(BotDetectorPanel.wrapHTML(pred.getPlayerName()));
            this.predictionTypeLabel.setText(BotDetectorPanel.wrapHTML(FeedbackPredictionLabel.normalizeLabel(pred.getPredictionLabel())));
            this.predictionConfidenceLabel.setText(isNullConfidence ? EMPTY_LABEL : BotDetectorPanel.wrapHTML(BotDetectorPanel.toColoredPercentSpan(pred.getConfidence()), false));
            this.feedbackLabelComboBox.addItem(UNSURE_PREDICTION_LABEL);
            this.feedbackLabelComboBox.setSelectedItem(UNSURE_PREDICTION_LABEL);
            this.feedbackLabelComboBox.addItem(SOMETHING_ELSE_PREDICTION_LABEL);
            if (pred.getPredictionBreakdown() == null || pred.getPredictionBreakdown().size() == 0) {
                this.predictionBreakdownLabel.setText(EMPTY_LABEL);
                this.predictionBreakdownPanel.setVisible(false);
                this.feedbackLabelComboBox.addItem(CORRECT_FALLBACK_PREDICTION_LABEL);
            } else {
                if (isNullConfidence && !this.config.showBreakdownOnNullConfidence()) {
                    this.predictionBreakdownLabel.setText(EMPTY_LABEL);
                    this.predictionBreakdownPanel.setVisible(false);
                } else {
                    this.predictionBreakdownLabel.setText(BotDetectorPanel.toPredictionBreakdownString(pred.getPredictionBreakdown()));
                    this.predictionBreakdownPanel.setVisible(true);
                }
                String primaryLabel = pred.getPredictionLabel();
                pred.getPredictionBreakdown().entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> {
                    FeedbackPredictionLabel pLabel = new FeedbackPredictionLabel((String)entry.getKey(), (Double)entry.getValue(), ((String)entry.getKey()).equals(primaryLabel) ? FeedbackValue.POSITIVE : FeedbackValue.NEGATIVE);
                    this.feedbackLabelComboBox.addItem(pLabel);
                    if (pLabel.getFeedbackValue() == FeedbackValue.POSITIVE) {
                        this.feedbackLabelComboBox.setSelectedItem(pLabel);
                    }
                });
            }
            if (this.lastPredictionUploaderName != null) {
                this.resetFeedbackPanel(true);
                CaseInsensitiveString name = BotDetectorPlugin.normalizeAndWrapPlayerName(pred.getPlayerName());
                if (pred.getPlayerId() <= 0L) {
                    this.predictionFeedbackPanel.setVisible(false);
                } else {
                    String feedbackText;
                    FeedbackPredictionLabel feedbacked = this.plugin.getFeedbackedPlayers().get(name);
                    if (feedbacked != null) {
                        this.disableAndSetComboBoxOnFeedbackPanel(feedbacked, true);
                    }
                    if ((feedbackText = this.plugin.getFeedbackedPlayersText().get(name)) != null) {
                        this.feedbackTextbox.setText(feedbackText);
                    }
                    this.predictionFeedbackPanel.setVisible(true);
                }
                this.resetFlaggingPanel();
                if (sighting == null || !this.shouldAllowFlagging()) {
                    this.predictionFlaggingPanel.setVisible(false);
                } else {
                    Boolean flagged = this.plugin.getFlaggedPlayers().get(name);
                    if (flagged != null) {
                        this.disableAndSetColorOnFlaggingPanel(flagged);
                    }
                    this.predictionFlaggingPanel.setVisible(true);
                }
            } else {
                this.predictionFeedbackPanel.setVisible(false);
                this.predictionFlaggingPanel.setVisible(false);
            }
        } else {
            this.lastPrediction = null;
            this.lastPredictionPlayerSighting = null;
            this.lastPredictionUploaderName = null;
            this.predictionPlayerIdLabel.setText(EMPTY_LABEL);
            this.predictionPlayerNameLabel.setText(EMPTY_LABEL);
            this.predictionTypeLabel.setText(EMPTY_LABEL);
            this.predictionConfidenceLabel.setText(EMPTY_LABEL);
            this.predictionBreakdownLabel.setText(EMPTY_LABEL);
            this.predictionBreakdownPanel.setVisible(false);
            this.predictionFeedbackPanel.setVisible(false);
            this.predictionFlaggingPanel.setVisible(false);
        }
    }

    public void setPredictionError(String playerName, String error) {
        this.setPredictionError(playerName, error, EMPTY_LABEL);
    }

    public void setPredictionError(String playerName, String error, String details) {
        this.setPrediction(null);
        this.setPredictionLabelsColor(ERROR_COLOR);
        this.predictionPlayerNameLabel.setText(BotDetectorPanel.wrapHTML(playerName));
        this.predictionTypeLabel.setText(BotDetectorPanel.wrapHTML(error));
        this.predictionConfidenceLabel.setText(BotDetectorPanel.wrapHTML(details));
    }

    public void predictPlayer(String playerName) {
        this.searchBar.setText(playerName);
        this.predictPlayer();
    }

    private void predictPlayer() {
        String target = BotDetectorPanel.sanitize(this.searchBar.getText());
        if (target.length() <= 0) {
            return;
        }
        if (target.length() > 12) {
            this.searchBar.setIcon(IconTextField.Icon.ERROR);
            this.searchBarLoading = false;
            this.setPredictionError(target.substring(0, 12) + "...", "Name Input Error", "Name cannot be longer than 12 characters");
            return;
        }
        if (!BotDetectorPanel.isValidPlayerName(target)) {
            this.searchBar.setIcon(IconTextField.Icon.ERROR);
            this.searchBarLoading = false;
            this.setPredictionError(target, "Name Input Error", "Entered name is not a valid Runescape name");
            return;
        }
        this.searchBar.setIcon(IconTextField.Icon.LOADING_DARKER);
        this.searchBar.setEditable(false);
        this.searchBarLoading = true;
        this.setPrediction(null);
        this.detectorClient.requestPrediction(target).whenCompleteAsync((pred, ex) -> SwingUtilities.invokeLater(() -> {
            if (!BotDetectorPanel.sanitize(this.searchBar.getText()).equals(target)) {
                return;
            }
            this.searchBar.setEditable(true);
            this.searchBarLoading = false;
            if (ex != null) {
                this.searchBar.setIcon(IconTextField.Icon.ERROR);
                this.setPredictionError(target, "Server Error", ex.getMessage());
                return;
            }
            this.searchBar.setIcon(IconTextField.Icon.SEARCH);
            Prediction p = pred;
            if (p == null) {
                p = Prediction.builder().playerName(target).playerId(-1L).confidence(null).predictionBreakdown(null).predictionLabel("Player not found").build();
            }
            this.setPrediction(p, this.plugin.getPersistentSightings().get(BotDetectorPlugin.normalizeAndWrapPlayerName(target)));
        }));
    }

    private void sendFeedbackToClient(FeedbackPredictionLabel proposedLabel) {
        if (this.lastPrediction == null || this.lastPredictionUploaderName == null || proposedLabel == null || proposedLabel.getLabel() == null) {
            return;
        }
        this.disableAndSetComboBoxOnFeedbackPanel(proposedLabel, false);
        CaseInsensitiveString wrappedName = BotDetectorPlugin.normalizeAndWrapPlayerName(this.lastPrediction.getPlayerName());
        Map<CaseInsensitiveString, FeedbackPredictionLabel> feedbackMap = this.plugin.getFeedbackedPlayers();
        feedbackMap.put(wrappedName, proposedLabel);
        String feedbackText = this.feedbackTextbox.getText().trim();
        if (feedbackText.isEmpty()) {
            feedbackText = null;
        } else {
            this.plugin.getFeedbackedPlayersText().put(wrappedName, feedbackText);
        }
        this.feedbackHeaderLabel.setIcon(Icons.LOADING_SPINNER);
        this.feedbackHeaderLabel.setToolTipText(null);
        this.detectorClient.sendFeedback(this.lastPrediction, this.lastPredictionUploaderName, proposedLabel, feedbackText).whenComplete((b, ex) -> {
            String message;
            boolean stillSame;
            boolean bl = stillSame = this.lastPrediction != null && wrappedName.equals(BotDetectorPlugin.normalizeAndWrapPlayerName(this.lastPrediction.getPlayerName()));
            if (ex == null && b.booleanValue()) {
                message = "Thank you for your prediction feedback for '%s'!";
                if (stillSame) {
                    this.feedbackHeaderLabel.setIcon(null);
                    this.feedbackHeaderLabel.setToolTipText(null);
                }
            } else {
                message = "Error sending your prediction feedback for '%s'.";
                feedbackMap.remove(wrappedName);
                if (stillSame) {
                    this.resetFeedbackPanel(false);
                    this.feedbackHeaderLabel.setIcon(Icons.ERROR_ICON);
                    this.feedbackHeaderLabel.setToolTipText(ex != null ? ex.getMessage() : "Unknown error");
                }
            }
            this.plugin.sendChatStatusMessage(String.format(message, wrappedName));
        });
    }

    private void sendFlagToClient(boolean doFlag) {
        if (this.lastPredictionPlayerSighting == null || !this.shouldAllowFlagging()) {
            return;
        }
        this.disableAndSetColorOnFlaggingPanel(doFlag);
        CaseInsensitiveString wrappedName = BotDetectorPlugin.normalizeAndWrapPlayerName(this.lastPredictionPlayerSighting.getPlayerName());
        Map<CaseInsensitiveString, Boolean> flagMap = this.plugin.getFlaggedPlayers();
        flagMap.put(wrappedName, doFlag);
        if (!doFlag) {
            return;
        }
        this.flaggingHeaderLabel.setIcon(Icons.LOADING_SPINNER);
        this.flaggingHeaderLabel.setToolTipText(null);
        this.detectorClient.sendSighting(this.lastPredictionPlayerSighting, this.lastPredictionUploaderName, true).whenComplete((b, ex) -> {
            String message;
            boolean stillSame;
            boolean bl = stillSame = this.lastPredictionPlayerSighting != null && wrappedName.equals(BotDetectorPlugin.normalizeAndWrapPlayerName(this.lastPredictionPlayerSighting.getPlayerName()));
            if (ex == null && b.booleanValue()) {
                message = "Thank you for flagging '%s' as a bot to us!";
                this.setNamesUploaded(this.playerCurrentManualUploads + 1, true);
                if (stillSame) {
                    this.flaggingHeaderLabel.setIcon(null);
                    this.flaggingHeaderLabel.setToolTipText(null);
                }
            } else {
                message = "Error sending your bot flag for '%s'.";
                flagMap.remove(wrappedName);
                if (stillSame) {
                    this.resetFlaggingPanel();
                    this.flaggingHeaderLabel.setIcon(Icons.ERROR_ICON);
                    this.flaggingHeaderLabel.setToolTipText(ex != null ? ex.getMessage() : "Unknown error");
                }
            }
            this.plugin.sendChatStatusMessage(String.format(message, wrappedName));
        });
    }

    private boolean shouldAllowFlagging() {
        return this.lastPredictionUploaderName != null && !this.lastPredictionUploaderName.startsWith("AnonymousUser");
    }

    private void resetFeedbackPanel(boolean clearText) {
        this.feedbackHeaderLabel.setIcon(null);
        this.feedbackHeaderLabel.setToolTipText(null);
        this.feedbackSendButton.setBackground(null);
        this.feedbackSendButton.setEnabled(true);
        this.feedbackTextbox.setEnabled(true);
        this.feedbackLabelComboBox.setEnabled(true);
        if (clearText) {
            this.feedbackTextbox.setText("");
        }
    }

    private void disableAndSetComboBoxOnFeedbackPanel(FeedbackPredictionLabel label, boolean clearAndForceSetComboBoxLabel) {
        this.feedbackSendButton.setEnabled(false);
        this.feedbackTextbox.setEnabled(false);
        this.feedbackLabelComboBox.setEnabled(false);
        if (clearAndForceSetComboBoxLabel) {
            this.feedbackLabelComboBox.removeAllItems();
            this.feedbackLabelComboBox.addItem(label);
        }
        this.feedbackLabelComboBox.setSelectedItem(label);
        switch (label.getFeedbackValue()) {
            case POSITIVE: {
                this.feedbackSendButton.setBackground(POSITIVE_BUTTON_COLOR);
                break;
            }
            case NEUTRAL: {
                this.feedbackSendButton.setBackground(NEUTRAL_BUTTON_COLOR);
                break;
            }
            case NEGATIVE: {
                this.feedbackSendButton.setBackground(NEGATIVE_BUTTON_COLOR);
            }
        }
    }

    private void resetFlaggingPanel() {
        this.flaggingHeaderLabel.setIcon(null);
        this.flaggingHeaderLabel.setToolTipText(null);
        this.flaggingYesButton.setBackground(null);
        this.flaggingYesButton.setEnabled(true);
        this.flaggingNoButton.setBackground(null);
        this.flaggingNoButton.setEnabled(true);
    }

    private void disableAndSetColorOnFlaggingPanel(boolean flagged) {
        this.flaggingYesButton.setEnabled(false);
        this.flaggingNoButton.setEnabled(false);
        if (flagged) {
            this.flaggingYesButton.setBackground(POSITIVE_BUTTON_COLOR);
        } else {
            this.flaggingNoButton.setBackground(NEGATIVE_BUTTON_COLOR);
        }
    }

    public void setFontType(PanelFontType fontType) {
        Font f;
        switch (fontType) {
            case SMALL: {
                f = SMALL_FONT;
                break;
            }
            case BOLD: {
                f = BOLD_FONT;
                break;
            }
            default: {
                f = NORMAL_FONT;
            }
        }
        this.switchableFontComponents.forEach(c -> c.setFont(f));
    }

    private static String wrapHTML(String str) {
        return BotDetectorPanel.wrapHTML(str, true);
    }

    private static String wrapHTML(String str, boolean escape) {
        return "<html>" + (escape ? StringEscapeUtils.escapeHtml4((String)str) : str) + "</html>";
    }

    private static String sanitize(String lookup) {
        return lookup.replace('\u00a0', ' ');
    }

    private static boolean isValidPlayerName(String playerName) {
        if (playerName == null || playerName.length() > 12) {
            return false;
        }
        return VALID_RSN_PATTERN.matcher(playerName).matches();
    }

    private static Color getPercentColor(double percent) {
        return (percent = Doubles.constrainToRange((double)percent, (double)0.0, (double)1.0)) < 0.5 ? ColorUtil.colorLerp((Color)Color.RED, (Color)Color.YELLOW, (double)(percent * 2.0)) : ColorUtil.colorLerp((Color)Color.YELLOW, (Color)Color.GREEN, (double)((percent - 0.5) * 2.0));
    }

    private static String toPercentString(double percent) {
        return new DecimalFormat("0.00%").format(percent);
    }

    private static String toColoredPercentSpan(double percent) {
        return String.format("<span style='color:%s'>%s</span>", ColorUtil.toHexColor((Color)BotDetectorPanel.getPercentColor(percent)), BotDetectorPanel.toPercentString(percent));
    }

    private static String toPredictionBreakdownString(Map<String, Double> predictionMap) {
        if (predictionMap == null || predictionMap.size() == 0) {
            return null;
        }
        String openingTags = "<html><body style='margin:0;padding:0;color:" + ColorUtil.toHexColor((Color)TEXT_COLOR) + "'><table border='0' cellspacing='0' cellpadding='0'>";
        String closingTags = "</table></body></html>";
        StringBuilder sb = new StringBuilder();
        sb.append(openingTags);
        String rowString = "<tr><td>%s:</td><td style='padding-left:5;text-align:right;color:%s'>%s</td></tr>";
        predictionMap.entrySet().stream().filter(e -> (Double)e.getValue() > 0.0).sorted(Map.Entry.comparingByValue().reversed().thenComparing(Map.Entry.comparingByKey())).forEach(e -> sb.append(String.format(rowString, FeedbackPredictionLabel.normalizeLabel((String)e.getKey()), ColorUtil.toHexColor((Color)BotDetectorPanel.getPercentColor((Double)e.getValue())), BotDetectorPanel.toPercentString((Double)e.getValue()))));
        return sb.append(closingTags).toString();
    }

    void addInputKeyListener(KeyListener l) {
        this.searchBar.addKeyListener(l);
    }

    void removeInputKeyListener(KeyListener l) {
        this.searchBar.removeKeyListener(l);
    }

    public static enum WarningLabel {
        ANONYMOUS(Icons.WARNING_ICON, " Anonymous Uploading Active", "<html>Your name will not be included with your uploads and your tallies will not increase.<br>Manual bot flagging is also disabled.</html>"),
        BLOCKED_WORLD(Icons.WARNING_ICON, " No Uploading For Current World", "<html>You are currently logged into a world where player sightings are not being collected.<br>Your tallies will not increase from seeing players in this world.</html>"),
        PLAYER_STATS_ERROR(Icons.ERROR_ICON, " Could Not Retrieve Statistics", "<html>Your player statistics could not be retrieved at this time.<br>Either the server could not assign you an ID or the server is down at the moment.</html>"),
        NAME_ERROR(Icons.ERROR_ICON, " Invalid Player Name", "<html>Your player name could not be loaded correctly.<br>Most likely you spawned on Tutorial Island or your name was forcibly reset by Jagex.<br>Try relogging after setting a name.</html>");

        private final Icon image;
        private final String message;
        private final String tooltip;

        public Icon getImage() {
            return this.image;
        }

        public String getMessage() {
            return this.message;
        }

        public String getTooltip() {
            return this.tooltip;
        }

        private WarningLabel(Icon image, String message, String tooltip) {
            this.image = image;
            this.message = message;
            this.tooltip = tooltip;
        }
    }

    public static enum WebLink {
        WEBSITE(Icons.WEB_ICON, "Our website", "https://www.osrsbotdetector.com/"),
        TWITTER(Icons.TWITTER_ICON, "Follow us on Twitter!", "https://www.twitter.com/OSRSBotDetector"),
        DISCORD(Icons.DISCORD_ICON, "Join our Discord!", "https://discord.com/invite/JCAGpcjbfP"),
        GITHUB(Icons.GITHUB_ICON, "Check out the project's source code", "https://github.com/Bot-detector"),
        PATREON(Icons.PATREON_ICON, "Help keep us going!", "https://www.patreon.com/Ferrariic");

        private final ImageIcon image;
        private final String tooltip;
        private final String link;

        public ImageIcon getImage() {
            return this.image;
        }

        public String getTooltip() {
            return this.tooltip;
        }

        public String getLink() {
            return this.link;
        }

        private WebLink(ImageIcon image, String tooltip, String link) {
            this.image = image;
            this.tooltip = tooltip;
            this.link = link;
        }
    }
}

