/*
 * Decompiled with CFR 0.152.
 */
package com.botdetector.model;

import com.google.gson.annotations.SerializedName;
import java.util.Map;

public final class Prediction {
    @SerializedName(value="player_id")
    private final long playerId;
    @SerializedName(value="player_name")
    private final String playerName;
    @SerializedName(value="prediction_label")
    private final String predictionLabel;
    @SerializedName(value="prediction_confidence")
    private final Double confidence;
    @SerializedName(value="predictions_breakdown")
    private final Map<String, Double> predictionBreakdown;

    Prediction(long playerId, String playerName, String predictionLabel, Double confidence, Map<String, Double> predictionBreakdown) {
        this.playerId = playerId;
        this.playerName = playerName;
        this.predictionLabel = predictionLabel;
        this.confidence = confidence;
        this.predictionBreakdown = predictionBreakdown;
    }

    public static PredictionBuilder builder() {
        return new PredictionBuilder();
    }

    public long getPlayerId() {
        return this.playerId;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public String getPredictionLabel() {
        return this.predictionLabel;
    }

    public Double getConfidence() {
        return this.confidence;
    }

    public Map<String, Double> getPredictionBreakdown() {
        return this.predictionBreakdown;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Prediction)) {
            return false;
        }
        Prediction other = (Prediction)o;
        if (this.getPlayerId() != other.getPlayerId()) {
            return false;
        }
        String this$playerName = this.getPlayerName();
        String other$playerName = other.getPlayerName();
        if (this$playerName == null ? other$playerName != null : !this$playerName.equals(other$playerName)) {
            return false;
        }
        String this$predictionLabel = this.getPredictionLabel();
        String other$predictionLabel = other.getPredictionLabel();
        if (this$predictionLabel == null ? other$predictionLabel != null : !this$predictionLabel.equals(other$predictionLabel)) {
            return false;
        }
        Double this$confidence = this.getConfidence();
        Double other$confidence = other.getConfidence();
        if (this$confidence == null ? other$confidence != null : !((Object)this$confidence).equals(other$confidence)) {
            return false;
        }
        Map<String, Double> this$predictionBreakdown = this.getPredictionBreakdown();
        Map<String, Double> other$predictionBreakdown = other.getPredictionBreakdown();
        return !(this$predictionBreakdown == null ? other$predictionBreakdown != null : !((Object)this$predictionBreakdown).equals(other$predictionBreakdown));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $playerId = this.getPlayerId();
        result = result * 59 + (int)($playerId >>> 32 ^ $playerId);
        String $playerName = this.getPlayerName();
        result = result * 59 + ($playerName == null ? 43 : $playerName.hashCode());
        String $predictionLabel = this.getPredictionLabel();
        result = result * 59 + ($predictionLabel == null ? 43 : $predictionLabel.hashCode());
        Double $confidence = this.getConfidence();
        result = result * 59 + ($confidence == null ? 43 : ((Object)$confidence).hashCode());
        Map<String, Double> $predictionBreakdown = this.getPredictionBreakdown();
        result = result * 59 + ($predictionBreakdown == null ? 43 : ((Object)$predictionBreakdown).hashCode());
        return result;
    }

    public String toString() {
        return "Prediction(playerId=" + this.getPlayerId() + ", playerName=" + this.getPlayerName() + ", predictionLabel=" + this.getPredictionLabel() + ", confidence=" + this.getConfidence() + ", predictionBreakdown=" + this.getPredictionBreakdown() + ")";
    }

    public static class PredictionBuilder {
        private long playerId;
        private String playerName;
        private String predictionLabel;
        private Double confidence;
        private Map<String, Double> predictionBreakdown;

        PredictionBuilder() {
        }

        public PredictionBuilder playerId(long playerId) {
            this.playerId = playerId;
            return this;
        }

        public PredictionBuilder playerName(String playerName) {
            this.playerName = playerName;
            return this;
        }

        public PredictionBuilder predictionLabel(String predictionLabel) {
            this.predictionLabel = predictionLabel;
            return this;
        }

        public PredictionBuilder confidence(Double confidence) {
            this.confidence = confidence;
            return this;
        }

        public PredictionBuilder predictionBreakdown(Map<String, Double> predictionBreakdown) {
            this.predictionBreakdown = predictionBreakdown;
            return this;
        }

        public Prediction build() {
            return new Prediction(this.playerId, this.playerName, this.predictionLabel, this.confidence, this.predictionBreakdown);
        }

        public String toString() {
            return "Prediction.PredictionBuilder(playerId=" + this.playerId + ", playerName=" + this.playerName + ", predictionLabel=" + this.predictionLabel + ", confidence=" + this.confidence + ", predictionBreakdown=" + this.predictionBreakdown + ")";
        }
    }
}

