/*
 * Decompiled with CFR 0.152.
 */
package com.botdetector.model;

public final class PlayerStats {
    private final long namesUploaded;
    private final long confirmedBans;
    private final long possibleBans;
    private final long incorrectFlags;
    private final long feedbackSent;

    public double getAccuracy() {
        long divisor = this.incorrectFlags + this.confirmedBans;
        return divisor > 0L ? (double)this.confirmedBans / (double)divisor : 0.0;
    }

    PlayerStats(long namesUploaded, long confirmedBans, long possibleBans, long incorrectFlags, long feedbackSent) {
        this.namesUploaded = namesUploaded;
        this.confirmedBans = confirmedBans;
        this.possibleBans = possibleBans;
        this.incorrectFlags = incorrectFlags;
        this.feedbackSent = feedbackSent;
    }

    public static PlayerStatsBuilder builder() {
        return new PlayerStatsBuilder();
    }

    public long getNamesUploaded() {
        return this.namesUploaded;
    }

    public long getConfirmedBans() {
        return this.confirmedBans;
    }

    public long getPossibleBans() {
        return this.possibleBans;
    }

    public long getIncorrectFlags() {
        return this.incorrectFlags;
    }

    public long getFeedbackSent() {
        return this.feedbackSent;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlayerStats)) {
            return false;
        }
        PlayerStats other = (PlayerStats)o;
        if (this.getNamesUploaded() != other.getNamesUploaded()) {
            return false;
        }
        if (this.getConfirmedBans() != other.getConfirmedBans()) {
            return false;
        }
        if (this.getPossibleBans() != other.getPossibleBans()) {
            return false;
        }
        if (this.getIncorrectFlags() != other.getIncorrectFlags()) {
            return false;
        }
        return this.getFeedbackSent() == other.getFeedbackSent();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $namesUploaded = this.getNamesUploaded();
        result = result * 59 + (int)($namesUploaded >>> 32 ^ $namesUploaded);
        long $confirmedBans = this.getConfirmedBans();
        result = result * 59 + (int)($confirmedBans >>> 32 ^ $confirmedBans);
        long $possibleBans = this.getPossibleBans();
        result = result * 59 + (int)($possibleBans >>> 32 ^ $possibleBans);
        long $incorrectFlags = this.getIncorrectFlags();
        result = result * 59 + (int)($incorrectFlags >>> 32 ^ $incorrectFlags);
        long $feedbackSent = this.getFeedbackSent();
        result = result * 59 + (int)($feedbackSent >>> 32 ^ $feedbackSent);
        return result;
    }

    public String toString() {
        return "PlayerStats(namesUploaded=" + this.getNamesUploaded() + ", confirmedBans=" + this.getConfirmedBans() + ", possibleBans=" + this.getPossibleBans() + ", incorrectFlags=" + this.getIncorrectFlags() + ", feedbackSent=" + this.getFeedbackSent() + ")";
    }

    public static class PlayerStatsBuilder {
        private long namesUploaded;
        private long confirmedBans;
        private long possibleBans;
        private long incorrectFlags;
        private long feedbackSent;

        PlayerStatsBuilder() {
        }

        public PlayerStatsBuilder namesUploaded(long namesUploaded) {
            this.namesUploaded = namesUploaded;
            return this;
        }

        public PlayerStatsBuilder confirmedBans(long confirmedBans) {
            this.confirmedBans = confirmedBans;
            return this;
        }

        public PlayerStatsBuilder possibleBans(long possibleBans) {
            this.possibleBans = possibleBans;
            return this;
        }

        public PlayerStatsBuilder incorrectFlags(long incorrectFlags) {
            this.incorrectFlags = incorrectFlags;
            return this;
        }

        public PlayerStatsBuilder feedbackSent(long feedbackSent) {
            this.feedbackSent = feedbackSent;
            return this;
        }

        public PlayerStats build() {
            return new PlayerStats(this.namesUploaded, this.confirmedBans, this.possibleBans, this.incorrectFlags, this.feedbackSent);
        }

        public String toString() {
            return "PlayerStats.PlayerStatsBuilder(namesUploaded=" + this.namesUploaded + ", confirmedBans=" + this.confirmedBans + ", possibleBans=" + this.possibleBans + ", incorrectFlags=" + this.incorrectFlags + ", feedbackSent=" + this.feedbackSent + ")";
        }
    }
}

