/*
 * Decompiled with CFR 0.152.
 */
package com.botdetector.model;

import com.google.gson.annotations.SerializedName;
import java.time.Instant;
import java.util.Map;
import net.runelite.api.kit.KitType;

public final class PlayerSighting {
    @SerializedName(value="reported")
    private final String playerName;
    @SerializedName(value="region_id")
    private final int regionID;
    @SerializedName(value="x_coord")
    private final int worldX;
    @SerializedName(value="y_coord")
    private final int worldY;
    @SerializedName(value="z_coord")
    private final int plane;
    @SerializedName(value="equipment")
    private final Map<KitType, Integer> equipment;
    @SerializedName(value="equipment_ge_value")
    private final long equipmentGEValue;
    @SerializedName(value="world_number")
    private final int worldNumber;
    @SerializedName(value="on_members_world")
    private final boolean inMembersWorld;
    @SerializedName(value="on_pvp_world")
    private final boolean inPVPWorld;
    @SerializedName(value="ts")
    private final Instant timestamp;

    PlayerSighting(String playerName, int regionID, int worldX, int worldY, int plane, Map<KitType, Integer> equipment, long equipmentGEValue, int worldNumber, boolean inMembersWorld, boolean inPVPWorld, Instant timestamp) {
        this.playerName = playerName;
        this.regionID = regionID;
        this.worldX = worldX;
        this.worldY = worldY;
        this.plane = plane;
        this.equipment = equipment;
        this.equipmentGEValue = equipmentGEValue;
        this.worldNumber = worldNumber;
        this.inMembersWorld = inMembersWorld;
        this.inPVPWorld = inPVPWorld;
        this.timestamp = timestamp;
    }

    public static PlayerSightingBuilder builder() {
        return new PlayerSightingBuilder();
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public int getRegionID() {
        return this.regionID;
    }

    public int getWorldX() {
        return this.worldX;
    }

    public int getWorldY() {
        return this.worldY;
    }

    public int getPlane() {
        return this.plane;
    }

    public Map<KitType, Integer> getEquipment() {
        return this.equipment;
    }

    public long getEquipmentGEValue() {
        return this.equipmentGEValue;
    }

    public int getWorldNumber() {
        return this.worldNumber;
    }

    public boolean isInMembersWorld() {
        return this.inMembersWorld;
    }

    public boolean isInPVPWorld() {
        return this.inPVPWorld;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlayerSighting)) {
            return false;
        }
        PlayerSighting other = (PlayerSighting)o;
        String this$playerName = this.getPlayerName();
        String other$playerName = other.getPlayerName();
        if (this$playerName == null ? other$playerName != null : !this$playerName.equals(other$playerName)) {
            return false;
        }
        if (this.getRegionID() != other.getRegionID()) {
            return false;
        }
        if (this.getWorldX() != other.getWorldX()) {
            return false;
        }
        if (this.getWorldY() != other.getWorldY()) {
            return false;
        }
        if (this.getPlane() != other.getPlane()) {
            return false;
        }
        Map<KitType, Integer> this$equipment = this.getEquipment();
        Map<KitType, Integer> other$equipment = other.getEquipment();
        if (this$equipment == null ? other$equipment != null : !((Object)this$equipment).equals(other$equipment)) {
            return false;
        }
        if (this.getEquipmentGEValue() != other.getEquipmentGEValue()) {
            return false;
        }
        if (this.getWorldNumber() != other.getWorldNumber()) {
            return false;
        }
        if (this.isInMembersWorld() != other.isInMembersWorld()) {
            return false;
        }
        if (this.isInPVPWorld() != other.isInPVPWorld()) {
            return false;
        }
        Instant this$timestamp = this.getTimestamp();
        Instant other$timestamp = other.getTimestamp();
        return !(this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $playerName = this.getPlayerName();
        result = result * 59 + ($playerName == null ? 43 : $playerName.hashCode());
        result = result * 59 + this.getRegionID();
        result = result * 59 + this.getWorldX();
        result = result * 59 + this.getWorldY();
        result = result * 59 + this.getPlane();
        Map<KitType, Integer> $equipment = this.getEquipment();
        result = result * 59 + ($equipment == null ? 43 : ((Object)$equipment).hashCode());
        long $equipmentGEValue = this.getEquipmentGEValue();
        result = result * 59 + (int)($equipmentGEValue >>> 32 ^ $equipmentGEValue);
        result = result * 59 + this.getWorldNumber();
        result = result * 59 + (this.isInMembersWorld() ? 79 : 97);
        result = result * 59 + (this.isInPVPWorld() ? 79 : 97);
        Instant $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        return result;
    }

    public String toString() {
        return "PlayerSighting(playerName=" + this.getPlayerName() + ", regionID=" + this.getRegionID() + ", worldX=" + this.getWorldX() + ", worldY=" + this.getWorldY() + ", plane=" + this.getPlane() + ", equipment=" + this.getEquipment() + ", equipmentGEValue=" + this.getEquipmentGEValue() + ", worldNumber=" + this.getWorldNumber() + ", inMembersWorld=" + this.isInMembersWorld() + ", inPVPWorld=" + this.isInPVPWorld() + ", timestamp=" + this.getTimestamp() + ")";
    }

    public static class PlayerSightingBuilder {
        private String playerName;
        private int regionID;
        private int worldX;
        private int worldY;
        private int plane;
        private Map<KitType, Integer> equipment;
        private long equipmentGEValue;
        private int worldNumber;
        private boolean inMembersWorld;
        private boolean inPVPWorld;
        private Instant timestamp;

        PlayerSightingBuilder() {
        }

        public PlayerSightingBuilder playerName(String playerName) {
            this.playerName = playerName;
            return this;
        }

        public PlayerSightingBuilder regionID(int regionID) {
            this.regionID = regionID;
            return this;
        }

        public PlayerSightingBuilder worldX(int worldX) {
            this.worldX = worldX;
            return this;
        }

        public PlayerSightingBuilder worldY(int worldY) {
            this.worldY = worldY;
            return this;
        }

        public PlayerSightingBuilder plane(int plane) {
            this.plane = plane;
            return this;
        }

        public PlayerSightingBuilder equipment(Map<KitType, Integer> equipment) {
            this.equipment = equipment;
            return this;
        }

        public PlayerSightingBuilder equipmentGEValue(long equipmentGEValue) {
            this.equipmentGEValue = equipmentGEValue;
            return this;
        }

        public PlayerSightingBuilder worldNumber(int worldNumber) {
            this.worldNumber = worldNumber;
            return this;
        }

        public PlayerSightingBuilder inMembersWorld(boolean inMembersWorld) {
            this.inMembersWorld = inMembersWorld;
            return this;
        }

        public PlayerSightingBuilder inPVPWorld(boolean inPVPWorld) {
            this.inPVPWorld = inPVPWorld;
            return this;
        }

        public PlayerSightingBuilder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public PlayerSighting build() {
            return new PlayerSighting(this.playerName, this.regionID, this.worldX, this.worldY, this.plane, this.equipment, this.equipmentGEValue, this.worldNumber, this.inMembersWorld, this.inPVPWorld, this.timestamp);
        }

        public String toString() {
            return "PlayerSighting.PlayerSightingBuilder(playerName=" + this.playerName + ", regionID=" + this.regionID + ", worldX=" + this.worldX + ", worldY=" + this.worldY + ", plane=" + this.plane + ", equipment=" + this.equipment + ", equipmentGEValue=" + this.equipmentGEValue + ", worldNumber=" + this.worldNumber + ", inMembersWorld=" + this.inMembersWorld + ", inPVPWorld=" + this.inPVPWorld + ", timestamp=" + this.timestamp + ")";
        }
    }
}

