/*
 * Decompiled with CFR 0.152.
 */
package com.botdetector.model;

import com.botdetector.model.FeedbackValue;
import java.util.Objects;
import org.apache.commons.text.WordUtils;

public final class FeedbackPredictionLabel {
    private final String label;
    private final String normalizedLabel;
    private final FeedbackValue feedbackValue;
    private final Double labelConfidence;

    public FeedbackPredictionLabel(String label, Double labelConfidence, FeedbackValue feedbackValue) {
        this.label = label;
        this.normalizedLabel = FeedbackPredictionLabel.normalizeLabel(label);
        this.labelConfidence = labelConfidence;
        this.feedbackValue = feedbackValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof FeedbackPredictionLabel) {
            FeedbackPredictionLabel that = (FeedbackPredictionLabel)o;
            return Objects.equals(this.label, that.label) && Objects.equals(this.labelConfidence, that.labelConfidence) && Objects.equals((Object)this.feedbackValue, (Object)that.feedbackValue);
        }
        return false;
    }

    public int hashCode() {
        return (this.label != null ? this.label.hashCode() : 0) + (this.labelConfidence != null ? this.labelConfidence.hashCode() : 0) + (this.feedbackValue != null ? this.feedbackValue.hashCode() : 0);
    }

    public String toString() {
        return this.normalizedLabel;
    }

    public static String normalizeLabel(String label) {
        if (label == null) {
            return null;
        }
        return WordUtils.capitalize((String)label.replace('_', ' ').trim(), (char[])new char[]{' '});
    }

    public String getLabel() {
        return this.label;
    }

    public String getNormalizedLabel() {
        return this.normalizedLabel;
    }

    public FeedbackValue getFeedbackValue() {
        return this.feedbackValue;
    }

    public Double getLabelConfidence() {
        return this.labelConfidence;
    }
}

