/*
 * Decompiled with CFR 0.152.
 */
package com.botdetector.model;

import com.botdetector.model.AuthTokenType;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class AuthToken {
    private final AuthTokenType tokenType;
    private final String token;
    public static final AuthToken EMPTY_TOKEN = new AuthToken(AuthTokenType.NONE, "");
    public static final String AUTH_TOKEN_SEPARATOR = "|";
    public static final Pattern AUTH_TOKEN_PATTERN = Pattern.compile("^([a-zA-Z_]+)" + Pattern.quote("|") + "([\\w\\-]{12,32})$");
    public static final String AUTH_TOKEN_DESCRIPTION_MESSAGE = "Auth token in clipboard must be of format 'prefix|Suffix_Alpha-numeric' with a valid prefix and a suffix between 12 and 32 characters long.";

    public static AuthToken fromFullToken(String fullToken) {
        if (fullToken == null) {
            return EMPTY_TOKEN;
        }
        Matcher m = AUTH_TOKEN_PATTERN.matcher(fullToken);
        if (m.matches()) {
            return new AuthToken(AuthTokenType.fromPrefix(m.group(1)), m.group(2));
        }
        return EMPTY_TOKEN;
    }

    public String toFullToken() {
        return this.tokenType.name() + AUTH_TOKEN_SEPARATOR + this.token;
    }

    public AuthToken(AuthTokenType tokenType, String token) {
        this.tokenType = tokenType;
        this.token = token;
    }

    public AuthTokenType getTokenType() {
        return this.tokenType;
    }

    public String getToken() {
        return this.token;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthToken)) {
            return false;
        }
        AuthToken other = (AuthToken)o;
        AuthTokenType this$tokenType = this.getTokenType();
        AuthTokenType other$tokenType = other.getTokenType();
        if (this$tokenType == null ? other$tokenType != null : !((Object)((Object)this$tokenType)).equals((Object)other$tokenType)) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        return !(this$token == null ? other$token != null : !this$token.equals(other$token));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AuthTokenType $tokenType = this.getTokenType();
        result = result * 59 + ($tokenType == null ? 43 : ((Object)((Object)$tokenType)).hashCode());
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        return result;
    }

    public String toString() {
        return "AuthToken(tokenType=" + this.getTokenType() + ", token=" + this.getToken() + ")";
    }
}

