/*
 * Decompiled with CFR 0.152.
 */
package com.botdetector.http;

import com.botdetector.http.UnauthorizedTokenException;
import com.botdetector.model.FeedbackPredictionLabel;
import com.botdetector.model.PlayerSighting;
import com.botdetector.model.PlayerStats;
import com.botdetector.model.PlayerStatsType;
import com.botdetector.model.Prediction;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.lang.reflect.Type;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.runelite.api.kit.KitType;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class BotDetectorClient {
    private static final Logger log = LoggerFactory.getLogger(BotDetectorClient.class);
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private static final String API_VERSION_FALLBACK_WORD = "latest";
    private static final HttpUrl BASE_HTTP_URL = HttpUrl.parse((String)System.getProperty("BotDetectorAPIPath", "https://api.prd.osrsbotdetector.com"));
    private static final Supplier<String> CURRENT_EPOCH_SUPPLIER = () -> String.valueOf(Instant.now().getEpochSecond());
    public OkHttpClient okHttpClient;
    @Inject
    private Gson gson;
    private String pluginVersion;
    private final Supplier<String> pluginVersionSupplier = () -> this.pluginVersion != null && !this.pluginVersion.isEmpty() ? this.pluginVersion : API_VERSION_FALLBACK_WORD;

    private HttpUrl getUrl(ApiPath path, boolean addVersion) {
        HttpUrl.Builder builder = BASE_HTTP_URL.newBuilder();
        if (addVersion) {
            builder.addPathSegment(this.pluginVersionSupplier.get());
        }
        return builder.addPathSegments(path.getPath()).build();
    }

    private HttpUrl getUrl(ApiPath path) {
        return this.getUrl(path, false);
    }

    @Inject
    public BotDetectorClient(OkHttpClient rlClient) {
        this.okHttpClient = rlClient.newBuilder().pingInterval(0L, TimeUnit.SECONDS).connectTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).addNetworkInterceptor(chain -> {
            Request headerRequest = chain.request().newBuilder().header("Request-Epoch", CURRENT_EPOCH_SUPPLIER.get()).header("Plugin-Version", this.pluginVersionSupplier.get()).build();
            return chain.proceed(headerRequest);
        }).build();
    }

    public CompletableFuture<Boolean> sendSighting(PlayerSighting sighting, String uploaderName, boolean manual) {
        return this.sendSightings((Collection<PlayerSighting>)ImmutableList.of((Object)sighting), uploaderName, manual);
    }

    public CompletableFuture<Boolean> sendSightings(Collection<PlayerSighting> sightings, String uploaderName, boolean manual) {
        List wrappedList = sightings.stream().map(p -> new PlayerSightingWrapper(uploaderName, manual, (PlayerSighting)p)).collect(Collectors.toList());
        Gson bdGson = this.gson.newBuilder().enableComplexMapKeySerialization().registerTypeAdapter(PlayerSightingWrapper.class, (Object)new PlayerSightingWrapperSerializer()).registerTypeAdapter(KitType.class, (Object)new KitTypeSerializer()).registerTypeAdapter(Boolean.class, (Object)new BooleanToZeroOneConverter()).registerTypeAdapter(Instant.class, (Object)new InstantSecondsConverter()).create();
        Request request = new Request.Builder().url(this.getUrl(ApiPath.DETECTION).newBuilder().build()).post(RequestBody.create((MediaType)JSON, (String)bdGson.toJson(wrappedList))).build();
        final CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        this.okHttpClient.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                log.warn("Error sending player sighting data", (Throwable)e);
                future.completeExceptionally(e);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(Call call, Response response) {
                try {
                    if (!response.isSuccessful()) {
                        throw BotDetectorClient.this.getIOException(response);
                    }
                    future.complete(true);
                }
                catch (IOException e) {
                    log.warn("Error sending player sighting data", (Throwable)e);
                    future.completeExceptionally(e);
                }
                finally {
                    response.close();
                }
            }
        });
        return future;
    }

    public CompletableFuture<Boolean> verifyDiscord(String token, String nameToVerify, String code) {
        Request request = new Request.Builder().url(this.getUrl(ApiPath.VERIFY_DISCORD, true).newBuilder().addPathSegment(token).build()).post(RequestBody.create((MediaType)JSON, (String)this.gson.toJson((Object)new DiscordVerification(nameToVerify, code)))).build();
        final CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        this.okHttpClient.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                log.warn("Error verifying discord user", (Throwable)e);
                future.completeExceptionally(e);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(Call call, Response response) {
                try {
                    if (!response.isSuccessful()) {
                        if (response.code() == 401) {
                            throw new UnauthorizedTokenException("Invalid or unauthorized token for operation");
                        }
                        throw BotDetectorClient.this.getIOException(response);
                    }
                    future.complete(true);
                }
                catch (UnauthorizedTokenException | IOException e) {
                    log.warn("Error verifying discord user", (Throwable)e);
                    future.completeExceptionally(e);
                }
                finally {
                    response.close();
                }
            }
        });
        return future;
    }

    public CompletableFuture<Boolean> sendFeedback(Prediction pred, String uploaderName, FeedbackPredictionLabel proposedLabel, String feedbackText) {
        Request request = new Request.Builder().url(this.getUrl(ApiPath.FEEDBACK)).post(RequestBody.create((MediaType)JSON, (String)this.gson.toJson((Object)new PredictionFeedback(uploaderName, proposedLabel.getFeedbackValue().getApiValue(), pred.getPredictionLabel(), Optional.ofNullable(pred.getConfidence()).orElse(0.0), pred.getPlayerId(), proposedLabel.getLabel(), proposedLabel.getLabelConfidence(), feedbackText)))).build();
        final CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        this.okHttpClient.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                log.warn("Error sending prediction feedback", (Throwable)e);
                future.completeExceptionally(e);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(Call call, Response response) {
                try {
                    if (!response.isSuccessful()) {
                        throw BotDetectorClient.this.getIOException(response);
                    }
                    future.complete(true);
                }
                catch (IOException e) {
                    log.warn("Error sending prediction feedback", (Throwable)e);
                    future.completeExceptionally(e);
                }
                finally {
                    response.close();
                }
            }
        });
        return future;
    }

    public CompletableFuture<Prediction> requestPrediction(String playerName) {
        return this.requestPrediction(playerName, true);
    }

    public CompletableFuture<Prediction> requestPrediction(String playerName, boolean receiveBreakdownOnSpecialCases) {
        Request request = new Request.Builder().url(this.getUrl(ApiPath.PREDICTION).newBuilder().addQueryParameter("name", playerName).addQueryParameter("breakdown", Boolean.toString(receiveBreakdownOnSpecialCases)).build()).build();
        final CompletableFuture<Prediction> future = new CompletableFuture<Prediction>();
        this.okHttpClient.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                log.warn("Error obtaining player prediction data", (Throwable)e);
                future.completeExceptionally(e);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(Call call, Response response) {
                try {
                    future.complete((Prediction)BotDetectorClient.this.processResponse(BotDetectorClient.this.gson, response, (Type)((Object)Prediction.class)));
                }
                catch (IOException e) {
                    log.warn("Error obtaining player prediction data", (Throwable)e);
                    future.completeExceptionally(e);
                }
                finally {
                    response.close();
                }
            }
        });
        return future;
    }

    public CompletableFuture<Map<PlayerStatsType, PlayerStats>> requestPlayerStats(String playerName) {
        Gson bdGson = this.gson.newBuilder().registerTypeAdapter(Boolean.TYPE, (Object)new BooleanToZeroOneConverter()).create();
        Request requestP = new Request.Builder().url(this.getUrl(ApiPath.PLAYER_STATS_PASSIVE).newBuilder().addQueryParameter("name", playerName).build()).build();
        Request requestM = new Request.Builder().url(this.getUrl(ApiPath.PLAYER_STATS_MANUAL).newBuilder().addQueryParameter("name", playerName).build()).build();
        Request requestF = new Request.Builder().url(this.getUrl(ApiPath.PLAYER_STATS_FEEDBACK).newBuilder().addQueryParameter("name", playerName).build()).build();
        CompletableFuture<Collection<PlayerStatsAPIItem>> passiveFuture = new CompletableFuture<Collection<PlayerStatsAPIItem>>();
        CompletableFuture<Collection<PlayerStatsAPIItem>> manualFuture = new CompletableFuture<Collection<PlayerStatsAPIItem>>();
        CompletableFuture<Collection<PlayerStatsAPIItem>> feedbackFuture = new CompletableFuture<Collection<PlayerStatsAPIItem>>();
        this.okHttpClient.newCall(requestP).enqueue((Callback)new PlayerStatsCallback(passiveFuture, bdGson));
        this.okHttpClient.newCall(requestM).enqueue((Callback)new PlayerStatsCallback(manualFuture, bdGson));
        this.okHttpClient.newCall(requestF).enqueue((Callback)new PlayerStatsCallback(feedbackFuture, bdGson));
        CompletableFuture<Map<PlayerStatsType, PlayerStats>> finalFuture = new CompletableFuture<Map<PlayerStatsType, PlayerStats>>();
        CompletableFuture.allOf(passiveFuture, manualFuture, feedbackFuture).whenComplete((v, e) -> {
            if (e != null) {
                log.warn("Error obtaining player stats data", e.getCause());
                finalFuture.completeExceptionally(e.getCause());
            } else {
                finalFuture.complete(this.processPlayerStats((Collection)passiveFuture.join(), (Collection)manualFuture.join(), (Collection)feedbackFuture.join()));
            }
        });
        return finalFuture;
    }

    private <T> T processResponse(Gson gson, Response response, Type type) throws IOException {
        if (!response.isSuccessful()) {
            if (response.code() == 404) {
                return null;
            }
            throw this.getIOException(response);
        }
        try {
            return (T)gson.fromJson(response.body().string(), type);
        }
        catch (JsonSyntaxException | IOException | IllegalStateException ex) {
            throw new IOException("Error parsing API response body", ex);
        }
    }

    private IOException getIOException(Response response) {
        int code = response.code();
        if (code >= 400 && code < 500) {
            try {
                String body = response.body().string();
                try {
                    Map map = (Map)this.gson.fromJson(body, new TypeToken<Map<String, String>>(){}.getType());
                    String error = (String)map.get("error");
                    if (Strings.isNullOrEmpty((String)error)) {
                        error = (String)((Object)map.getOrDefault("detail", "Unknown " + code + " error from API"));
                    }
                    return new IOException(error);
                }
                catch (JsonSyntaxException ex) {
                    log.warn("Received HTTP error code " + code + " from API with the following response body:\n" + body);
                    return new IOException("Error " + code + ", see log for more info");
                }
            }
            catch (IOException ex) {
                return new IOException("Error " + code + " with no error info", ex);
            }
        }
        return new IOException("Error " + code + " from API");
    }

    private Map<PlayerStatsType, PlayerStats> processPlayerStats(Collection<PlayerStatsAPIItem> passive, Collection<PlayerStatsAPIItem> manual, Collection<PlayerStatsAPIItem> feedback) {
        if (passive == null || manual == null || feedback == null) {
            return null;
        }
        PlayerStats passiveStats = this.countStats(passive, false);
        PlayerStats manualStats = this.countStats(manual, true);
        PlayerStats feedbackStats = this.countStats(feedback, false);
        PlayerStats totalStats = PlayerStats.builder().namesUploaded(passiveStats.getNamesUploaded() + manualStats.getNamesUploaded()).confirmedBans(passiveStats.getConfirmedBans() + manualStats.getConfirmedBans()).possibleBans(passiveStats.getPossibleBans() + manualStats.getPossibleBans()).feedbackSent(feedbackStats.getNamesUploaded()).build();
        return ImmutableMap.of((Object)((Object)PlayerStatsType.TOTAL), (Object)totalStats, (Object)((Object)PlayerStatsType.PASSIVE), (Object)passiveStats, (Object)((Object)PlayerStatsType.MANUAL), (Object)manualStats);
    }

    private PlayerStats countStats(Collection<PlayerStatsAPIItem> fromAPI, boolean countIncorrect) {
        long total = 0L;
        long confirmedBans = 0L;
        long possibleBans = 0L;
        long incorrectFlags = 0L;
        for (PlayerStatsAPIItem item : fromAPI) {
            if (item.isBanned()) {
                confirmedBans += item.getCount();
            } else {
                if (item.isPossibleBanned()) {
                    possibleBans += item.getCount();
                }
                if (countIncorrect && item.isPlayer()) {
                    incorrectFlags += item.getCount();
                }
            }
            total += item.getCount();
        }
        return PlayerStats.builder().namesUploaded(total).confirmedBans(confirmedBans).possibleBans(possibleBans).incorrectFlags(incorrectFlags).build();
    }

    public String getPluginVersion() {
        return this.pluginVersion;
    }

    public void setPluginVersion(String pluginVersion) {
        this.pluginVersion = pluginVersion;
    }

    private static class InstantSecondsConverter
    implements JsonSerializer<Instant>,
    JsonDeserializer<Instant> {
        private InstantSecondsConverter() {
        }

        public JsonElement serialize(Instant src, Type srcType, JsonSerializationContext context) {
            return new JsonPrimitive((Number)src.getEpochSecond());
        }

        public Instant deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            return Instant.ofEpochSecond(json.getAsLong());
        }
    }

    private static class BooleanToZeroOneConverter
    implements JsonSerializer<Boolean>,
    JsonDeserializer<Boolean> {
        private BooleanToZeroOneConverter() {
        }

        public JsonElement serialize(Boolean src, Type typeOfSrc, JsonSerializationContext context) {
            return context.serialize((Object)(src != false ? 1 : 0));
        }

        public Boolean deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            return json.getAsInt() != 0;
        }
    }

    private static class KitTypeSerializer
    implements JsonSerializer<KitType> {
        private KitTypeSerializer() {
        }

        public JsonElement serialize(KitType kitType, Type typeOfSrc, JsonSerializationContext context) {
            return context.serialize((Object)("equip_" + kitType.name().toLowerCase() + "_id"));
        }
    }

    private static class PlayerSightingWrapperSerializer
    implements JsonSerializer<PlayerSightingWrapper> {
        private PlayerSightingWrapperSerializer() {
        }

        public JsonElement serialize(PlayerSightingWrapper src, Type typeOfSrc, JsonSerializationContext context) {
            JsonElement json = context.serialize((Object)src.getSightingData());
            JsonObject jo = json.getAsJsonObject();
            jo.addProperty("reporter", src.getUploaderName());
            jo.add("manual_detect", context.serialize((Object)src.isManualDetect()));
            return json;
        }
    }

    private static final class PlayerStatsAPIItem {
        @SerializedName(value="possible_ban")
        private final boolean possibleBanned;
        @SerializedName(value="confirmed_ban")
        private final boolean banned;
        @SerializedName(value="confirmed_player")
        private final boolean player;
        private final long count;

        public PlayerStatsAPIItem(boolean possibleBanned, boolean banned, boolean player, long count) {
            this.possibleBanned = possibleBanned;
            this.banned = banned;
            this.player = player;
            this.count = count;
        }

        public boolean isPossibleBanned() {
            return this.possibleBanned;
        }

        public boolean isBanned() {
            return this.banned;
        }

        public boolean isPlayer() {
            return this.player;
        }

        public long getCount() {
            return this.count;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PlayerStatsAPIItem)) {
                return false;
            }
            PlayerStatsAPIItem other = (PlayerStatsAPIItem)o;
            if (this.isPossibleBanned() != other.isPossibleBanned()) {
                return false;
            }
            if (this.isBanned() != other.isBanned()) {
                return false;
            }
            if (this.isPlayer() != other.isPlayer()) {
                return false;
            }
            return this.getCount() == other.getCount();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isPossibleBanned() ? 79 : 97);
            result = result * 59 + (this.isBanned() ? 79 : 97);
            result = result * 59 + (this.isPlayer() ? 79 : 97);
            long $count = this.getCount();
            result = result * 59 + (int)($count >>> 32 ^ $count);
            return result;
        }

        public String toString() {
            return "BotDetectorClient.PlayerStatsAPIItem(possibleBanned=" + this.isPossibleBanned() + ", banned=" + this.isBanned() + ", player=" + this.isPlayer() + ", count=" + this.getCount() + ")";
        }
    }

    private static final class PredictionFeedback {
        @SerializedName(value="player_name")
        private final String playerName;
        private final int vote;
        @SerializedName(value="prediction")
        private final String predictionLabel;
        @SerializedName(value="confidence")
        private final double predictionConfidence;
        @SerializedName(value="subject_id")
        private final long targetId;
        @SerializedName(value="proposed_label")
        private final String proposedLabel;
        @SerializedName(value="proposed_label_confidence")
        private final Double proposedLabelConfidence;
        @SerializedName(value="feedback_text")
        private final String feedbackText;

        public PredictionFeedback(String playerName, int vote, String predictionLabel, double predictionConfidence, long targetId, String proposedLabel, Double proposedLabelConfidence, String feedbackText) {
            this.playerName = playerName;
            this.vote = vote;
            this.predictionLabel = predictionLabel;
            this.predictionConfidence = predictionConfidence;
            this.targetId = targetId;
            this.proposedLabel = proposedLabel;
            this.proposedLabelConfidence = proposedLabelConfidence;
            this.feedbackText = feedbackText;
        }

        public String getPlayerName() {
            return this.playerName;
        }

        public int getVote() {
            return this.vote;
        }

        public String getPredictionLabel() {
            return this.predictionLabel;
        }

        public double getPredictionConfidence() {
            return this.predictionConfidence;
        }

        public long getTargetId() {
            return this.targetId;
        }

        public String getProposedLabel() {
            return this.proposedLabel;
        }

        public Double getProposedLabelConfidence() {
            return this.proposedLabelConfidence;
        }

        public String getFeedbackText() {
            return this.feedbackText;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PredictionFeedback)) {
                return false;
            }
            PredictionFeedback other = (PredictionFeedback)o;
            String this$playerName = this.getPlayerName();
            String other$playerName = other.getPlayerName();
            if (this$playerName == null ? other$playerName != null : !this$playerName.equals(other$playerName)) {
                return false;
            }
            if (this.getVote() != other.getVote()) {
                return false;
            }
            String this$predictionLabel = this.getPredictionLabel();
            String other$predictionLabel = other.getPredictionLabel();
            if (this$predictionLabel == null ? other$predictionLabel != null : !this$predictionLabel.equals(other$predictionLabel)) {
                return false;
            }
            if (Double.compare(this.getPredictionConfidence(), other.getPredictionConfidence()) != 0) {
                return false;
            }
            if (this.getTargetId() != other.getTargetId()) {
                return false;
            }
            String this$proposedLabel = this.getProposedLabel();
            String other$proposedLabel = other.getProposedLabel();
            if (this$proposedLabel == null ? other$proposedLabel != null : !this$proposedLabel.equals(other$proposedLabel)) {
                return false;
            }
            Double this$proposedLabelConfidence = this.getProposedLabelConfidence();
            Double other$proposedLabelConfidence = other.getProposedLabelConfidence();
            if (this$proposedLabelConfidence == null ? other$proposedLabelConfidence != null : !((Object)this$proposedLabelConfidence).equals(other$proposedLabelConfidence)) {
                return false;
            }
            String this$feedbackText = this.getFeedbackText();
            String other$feedbackText = other.getFeedbackText();
            return !(this$feedbackText == null ? other$feedbackText != null : !this$feedbackText.equals(other$feedbackText));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $playerName = this.getPlayerName();
            result = result * 59 + ($playerName == null ? 43 : $playerName.hashCode());
            result = result * 59 + this.getVote();
            String $predictionLabel = this.getPredictionLabel();
            result = result * 59 + ($predictionLabel == null ? 43 : $predictionLabel.hashCode());
            long $predictionConfidence = Double.doubleToLongBits(this.getPredictionConfidence());
            result = result * 59 + (int)($predictionConfidence >>> 32 ^ $predictionConfidence);
            long $targetId = this.getTargetId();
            result = result * 59 + (int)($targetId >>> 32 ^ $targetId);
            String $proposedLabel = this.getProposedLabel();
            result = result * 59 + ($proposedLabel == null ? 43 : $proposedLabel.hashCode());
            Double $proposedLabelConfidence = this.getProposedLabelConfidence();
            result = result * 59 + ($proposedLabelConfidence == null ? 43 : ((Object)$proposedLabelConfidence).hashCode());
            String $feedbackText = this.getFeedbackText();
            result = result * 59 + ($feedbackText == null ? 43 : $feedbackText.hashCode());
            return result;
        }

        public String toString() {
            return "BotDetectorClient.PredictionFeedback(playerName=" + this.getPlayerName() + ", vote=" + this.getVote() + ", predictionLabel=" + this.getPredictionLabel() + ", predictionConfidence=" + this.getPredictionConfidence() + ", targetId=" + this.getTargetId() + ", proposedLabel=" + this.getProposedLabel() + ", proposedLabelConfidence=" + this.getProposedLabelConfidence() + ", feedbackText=" + this.getFeedbackText() + ")";
        }
    }

    private static final class DiscordVerification {
        @SerializedName(value="player_name")
        private final String nameToVerify;
        private final String code;

        public DiscordVerification(String nameToVerify, String code) {
            this.nameToVerify = nameToVerify;
            this.code = code;
        }

        public String getNameToVerify() {
            return this.nameToVerify;
        }

        public String getCode() {
            return this.code;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DiscordVerification)) {
                return false;
            }
            DiscordVerification other = (DiscordVerification)o;
            String this$nameToVerify = this.getNameToVerify();
            String other$nameToVerify = other.getNameToVerify();
            if (this$nameToVerify == null ? other$nameToVerify != null : !this$nameToVerify.equals(other$nameToVerify)) {
                return false;
            }
            String this$code = this.getCode();
            String other$code = other.getCode();
            return !(this$code == null ? other$code != null : !this$code.equals(other$code));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $nameToVerify = this.getNameToVerify();
            result = result * 59 + ($nameToVerify == null ? 43 : $nameToVerify.hashCode());
            String $code = this.getCode();
            result = result * 59 + ($code == null ? 43 : $code.hashCode());
            return result;
        }

        public String toString() {
            return "BotDetectorClient.DiscordVerification(nameToVerify=" + this.getNameToVerify() + ", code=" + this.getCode() + ")";
        }
    }

    private static final class PlayerSightingWrapper {
        private final String uploaderName;
        private final boolean manualDetect;
        private final PlayerSighting sightingData;

        public PlayerSightingWrapper(String uploaderName, boolean manualDetect, PlayerSighting sightingData) {
            this.uploaderName = uploaderName;
            this.manualDetect = manualDetect;
            this.sightingData = sightingData;
        }

        public String getUploaderName() {
            return this.uploaderName;
        }

        public boolean isManualDetect() {
            return this.manualDetect;
        }

        public PlayerSighting getSightingData() {
            return this.sightingData;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PlayerSightingWrapper)) {
                return false;
            }
            PlayerSightingWrapper other = (PlayerSightingWrapper)o;
            String this$uploaderName = this.getUploaderName();
            String other$uploaderName = other.getUploaderName();
            if (this$uploaderName == null ? other$uploaderName != null : !this$uploaderName.equals(other$uploaderName)) {
                return false;
            }
            if (this.isManualDetect() != other.isManualDetect()) {
                return false;
            }
            PlayerSighting this$sightingData = this.getSightingData();
            PlayerSighting other$sightingData = other.getSightingData();
            return !(this$sightingData == null ? other$sightingData != null : !((Object)this$sightingData).equals(other$sightingData));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $uploaderName = this.getUploaderName();
            result = result * 59 + ($uploaderName == null ? 43 : $uploaderName.hashCode());
            result = result * 59 + (this.isManualDetect() ? 79 : 97);
            PlayerSighting $sightingData = this.getSightingData();
            result = result * 59 + ($sightingData == null ? 43 : ((Object)$sightingData).hashCode());
            return result;
        }

        public String toString() {
            return "BotDetectorClient.PlayerSightingWrapper(uploaderName=" + this.getUploaderName() + ", manualDetect=" + this.isManualDetect() + ", sightingData=" + this.getSightingData() + ")";
        }
    }

    private class PlayerStatsCallback
    implements Callback {
        private final CompletableFuture<Collection<PlayerStatsAPIItem>> future;
        private final Gson gson;

        public PlayerStatsCallback(CompletableFuture<Collection<PlayerStatsAPIItem>> future, Gson gson) {
            this.future = future;
            this.gson = gson;
        }

        public void onFailure(Call call, IOException e) {
            this.future.completeExceptionally(e);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onResponse(Call call, Response response) throws IOException {
            try {
                this.future.complete((Collection)BotDetectorClient.this.processResponse(this.gson, response, new TypeToken<Collection<PlayerStatsAPIItem>>(){}.getType()));
            }
            catch (IOException e) {
                this.future.completeExceptionally(e);
            }
            finally {
                response.close();
            }
        }
    }

    private static enum ApiPath {
        DETECTION("v1/report"),
        PLAYER_STATS_PASSIVE("v1/report/count"),
        PLAYER_STATS_MANUAL("v1/report/manual/count"),
        PLAYER_STATS_FEEDBACK("v1/feedback/count"),
        PREDICTION("v1/prediction"),
        FEEDBACK("v1/feedback/"),
        VERIFY_DISCORD("site/discord_user/");

        final String path;

        public String getPath() {
            return this.path;
        }

        private ApiPath(String path) {
            this.path = path;
        }
    }
}

