/*
 * Decompiled with CFR 0.152.
 */
package com.botdetector;

import com.botdetector.BotDetectorConfig;
import com.botdetector.events.BotDetectorPanelActivated;
import com.botdetector.http.BotDetectorClient;
import com.botdetector.http.UnauthorizedTokenException;
import com.botdetector.http.ValidationException;
import com.botdetector.model.AuthToken;
import com.botdetector.model.AuthTokenPermission;
import com.botdetector.model.AuthTokenType;
import com.botdetector.model.CaseInsensitiveString;
import com.botdetector.model.FeedbackPredictionLabel;
import com.botdetector.model.PlayerSighting;
import com.botdetector.model.PlayerStats;
import com.botdetector.model.PlayerStatsType;
import com.botdetector.model.StatsCommandDetailLevel;
import com.botdetector.ui.BotDetectorPanel;
import com.google.common.collect.EvictingQueue;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.google.common.primitives.Ints;
import com.google.inject.Provides;
import java.awt.Color;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.text.DecimalFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.MessageNode;
import net.runelite.api.Player;
import net.runelite.api.WorldType;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.CommandExecuted;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.events.MenuOpened;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.PlayerSpawned;
import net.runelite.api.events.WorldChanged;
import net.runelite.api.kit.KitType;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatCommandManager;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.config.RuneScapeProfileType;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ClientShutdown;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.menus.MenuManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.PluginManager;
import net.runelite.client.task.Schedule;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.LinkBrowser;
import net.runelite.client.util.Text;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Bot Detector", description="This plugin sends encountered Player Names to a server in order to detect Botting Behavior.", tags={"Bot", "Detector", "Player"})
public class BotDetectorPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(BotDetectorPlugin.class);
    private static final ImmutableSet<RuneScapeProfileType> ALLOWED_PROFILE_TYPES = ImmutableSet.of((Object)RuneScapeProfileType.STANDARD);
    private static final int MAX_ALLOWED_REGION_ID = 16000;
    private static final Pattern UUID_PATTERN = Pattern.compile("^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$");
    private static final String PREDICT_OPTION = "Predict";
    private static final String REPORT_OPTION = "Report";
    private static final String KICK_OPTION = "Kick";
    private static final String DELETE_OPTION = "Delete";
    private static final ImmutableSet<String> AFTER_OPTIONS = ImmutableSet.of((Object)"Message", (Object)"Add ignore", (Object)"Remove friend", (Object)"Delete", (Object)"Kick");
    private static final ImmutableSet<MenuAction> PLAYER_MENU_ACTIONS = ImmutableSet.of((Object)MenuAction.PLAYER_FIRST_OPTION, (Object)MenuAction.PLAYER_SECOND_OPTION, (Object)MenuAction.PLAYER_THIRD_OPTION, (Object)MenuAction.PLAYER_FOURTH_OPTION, (Object)MenuAction.PLAYER_FIFTH_OPTION, (Object)MenuAction.PLAYER_SIXTH_OPTION, (Object[])new MenuAction[]{MenuAction.PLAYER_SEVENTH_OPTION, MenuAction.PLAYER_EIGHTH_OPTION});
    private static final String VERIFY_DISCORD_COMMAND = "!code";
    private static final int VERIFY_DISCORD_CODE_SIZE = 4;
    private static final Pattern VERIFY_DISCORD_CODE_PATTERN = Pattern.compile("\\d{1,4}");
    private static final String STATS_CHAT_COMMAND = "!bdstats";
    private static final String COMMAND_PREFIX = "bd";
    private static final String MANUAL_FLUSH_COMMAND = "bdFlush";
    private static final String MANUAL_SIGHT_COMMAND = "bdSnap";
    private static final String MANUAL_REFRESH_COMMAND = "bdRefresh";
    private static final String SHOW_HIDE_ID_COMMAND = "bdShowId";
    private static final String GET_AUTH_TOKEN_COMMAND = "bdGetToken";
    private static final String SET_AUTH_TOKEN_COMMAND = "bdSetToken";
    private static final String CLEAR_AUTH_TOKEN_COMMAND = "bdClearToken";
    private static final String TOGGLE_SHOW_DISCORD_VERIFICATION_ERRORS_COMMAND = "bdToggleShowDiscordVerificationErrors";
    private static final String TOGGLE_SHOW_DISCORD_VERIFICATION_ERRORS_COMMAND_ALIAS = "bdToggleDVE";
    private final ImmutableMap<CaseInsensitiveString, Consumer<String[]>> commandConsumerMap = ImmutableMap.builder().put((Object)CaseInsensitiveString.wrap("bdFlush"), s -> this.manualFlushCommand()).put((Object)CaseInsensitiveString.wrap("bdSnap"), s -> this.manualSightCommand()).put((Object)CaseInsensitiveString.wrap("bdRefresh"), s -> this.manualRefreshStatsCommand()).put((Object)CaseInsensitiveString.wrap("bdShowId"), this::showHideIdCommand).put((Object)CaseInsensitiveString.wrap("bdGetToken"), s -> this.putAuthTokenIntoClipboardCommand()).put((Object)CaseInsensitiveString.wrap("bdSetToken"), s -> this.setAuthTokenFromClipboardCommand()).put((Object)CaseInsensitiveString.wrap("bdClearToken"), s -> this.clearAuthTokenCommand()).put((Object)CaseInsensitiveString.wrap("bdToggleShowDiscordVerificationErrors"), s -> this.toggleShowDiscordVerificationErrors()).put((Object)CaseInsensitiveString.wrap("bdToggleDVE"), s -> this.toggleShowDiscordVerificationErrors()).build();
    private static final int MANUAL_FLUSH_COOLDOWN_SECONDS = 60;
    private static final int AUTO_REFRESH_STATS_COOLDOWN_SECONDS = 150;
    private static final int AUTO_REFRESH_LAST_FLUSH_GRACE_PERIOD_SECONDS = 30;
    private static final int API_HIT_SCHEDULE_SECONDS = 5;
    private static final String CHAT_MESSAGE_HEADER = "[Bot Detector] ";
    public static final String ANONYMOUS_USER_NAME = "AnonymousUser";
    public static final String ANONYMOUS_USER_NAME_UUID_FORMAT = "AnonymousUser_%s";
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ConfigManager configManager;
    @Inject
    private MenuManager menuManager;
    @Inject
    private ItemManager itemManager;
    @Inject
    private BotDetectorConfig config;
    @Inject
    private PluginManager pluginManager;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private ChatCommandManager chatCommandManager;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private BotDetectorClient detectorClient;
    private BotDetectorPanel panel;
    private NavigationButton navButton;
    private String loggedPlayerName;
    private Instant timeToAutoSend;
    private int namesUploaded;
    private Instant lastFlush = Instant.MIN;
    private Instant lastStatsRefresh = Instant.MIN;
    private int currentWorldNumber;
    private boolean isCurrentWorldMembers;
    private boolean isCurrentWorldPVP;
    private boolean isCurrentWorldBlocked;
    private EvictingQueue<GameState> previousTwoGameStates = EvictingQueue.create((int)2);
    private AuthToken authToken = AuthToken.EMPTY_TOKEN;
    private String anonymousUUID;
    private final Table<CaseInsensitiveString, Integer, PlayerSighting> sightingTable = Tables.synchronizedTable((Table)HashBasedTable.create());
    private final Map<CaseInsensitiveString, PlayerSighting> persistentSightings = new ConcurrentHashMap<CaseInsensitiveString, PlayerSighting>();
    private final Map<CaseInsensitiveString, FeedbackPredictionLabel> feedbackedPlayers = new ConcurrentHashMap<CaseInsensitiveString, FeedbackPredictionLabel>();
    private final Map<CaseInsensitiveString, String> feedbackedPlayersText = new ConcurrentHashMap<CaseInsensitiveString, String>();
    private final Map<CaseInsensitiveString, Boolean> flaggedPlayers = new ConcurrentHashMap<CaseInsensitiveString, Boolean>();

    @Provides
    BotDetectorConfig provideConfig(ConfigManager configManager) {
        return (BotDetectorConfig)configManager.getConfig(BotDetectorConfig.class);
    }

    protected void startUp() {
        try {
            Properties props = new Properties();
            props.load(((Object)((Object)this)).getClass().getResourceAsStream("version.txt"));
            this.detectorClient.setPluginVersion(props.getProperty("version"));
        }
        catch (Exception e) {
            log.error("Could not parse plugin version from properties file!", (Throwable)e);
            this.pluginManager.setPluginEnabled((Plugin)this, false);
            this.displayPluginVersionError();
            return;
        }
        this.anonymousUUID = this.configManager.getConfiguration("botdetector", "anonymousUUID");
        if (StringUtils.isBlank((CharSequence)this.anonymousUUID) || !UUID_PATTERN.matcher(this.anonymousUUID).matches()) {
            this.anonymousUUID = UUID.randomUUID().toString();
            this.configManager.setConfiguration("botdetector", "anonymousUUID", this.anonymousUUID);
        }
        this.panel = (BotDetectorPanel)((Object)this.injector.getInstance(BotDetectorPanel.class));
        SwingUtilities.invokeLater(() -> {
            this.panel.setWarningVisible(BotDetectorPanel.WarningLabel.ANONYMOUS, this.config.enableAnonymousUploading());
            this.panel.setPluginVersion(this.detectorClient.getPluginVersion());
            this.panel.setNamesUploaded(0, false);
            this.panel.setNamesUploaded(0, true);
            this.panel.setFeedbackTextboxVisible(this.config.showFeedbackTextbox());
        });
        this.processCurrentWorld();
        BufferedImage icon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"bot-icon.png");
        this.navButton = NavigationButton.builder().panel((PluginPanel)this.panel).tooltip("Bot Detector").icon(icon).priority(90).build();
        this.clientToolbar.addNavigation(this.navButton);
        if (this.config.addPredictOption() && this.client != null) {
            this.menuManager.addPlayerMenuItem(PREDICT_OPTION);
        }
        this.updateTimeToAutoSend();
        this.authToken = AuthToken.fromFullToken(this.config.authFullToken());
        this.previousTwoGameStates.offer((Object)this.client.getGameState());
        this.chatCommandManager.registerCommand(VERIFY_DISCORD_COMMAND, this::verifyDiscord);
        this.chatCommandManager.registerCommand(STATS_CHAT_COMMAND, this::statsChatCommand);
    }

    protected void shutDown() {
        this.panel.shutdown();
        this.flushPlayersToClient(false);
        this.persistentSightings.clear();
        this.feedbackedPlayers.clear();
        this.feedbackedPlayersText.clear();
        this.flaggedPlayers.clear();
        if (this.client != null) {
            this.menuManager.removePlayerMenuItem(PREDICT_OPTION);
        }
        this.clientToolbar.removeNavigation(this.navButton);
        this.namesUploaded = 0;
        this.loggedPlayerName = null;
        this.lastFlush = Instant.MIN;
        this.lastStatsRefresh = Instant.MIN;
        this.authToken = AuthToken.EMPTY_TOKEN;
        this.previousTwoGameStates.clear();
        this.chatCommandManager.unregisterCommand(VERIFY_DISCORD_COMMAND);
        this.chatCommandManager.unregisterCommand(STATS_CHAT_COMMAND);
    }

    private void updateTimeToAutoSend() {
        this.timeToAutoSend = Instant.now().plusSeconds(60L * (long)Ints.constrainToRange((int)this.config.autoSendMinutes(), (int)5, (int)360));
    }

    @Schedule(period=5L, unit=ChronoUnit.SECONDS, asynchronous=true)
    public void hitApi() {
        if (this.loggedPlayerName == null) {
            return;
        }
        if (!this.config.onlySendAtLogout() && Instant.now().isAfter(this.timeToAutoSend)) {
            this.flushPlayersToClient(true);
        }
        this.refreshPlayerStats(false);
    }

    public synchronized CompletableFuture<Boolean> flushPlayersToClient(boolean restoreOnFailure) {
        return this.flushPlayersToClient(restoreOnFailure, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized CompletableFuture<Boolean> flushPlayersToClient(boolean restoreOnFailure, boolean forceChatNotification) {
        int numUploads;
        ArrayList<PlayerSighting> sightings;
        int uniqueNames;
        String uploader = this.getUploaderName();
        if (uploader == null) {
            return null;
        }
        this.updateTimeToAutoSend();
        Table<CaseInsensitiveString, Integer, PlayerSighting> table = this.sightingTable;
        synchronized (table) {
            uniqueNames = this.sightingTable.rowKeySet().size();
            if (uniqueNames <= 0) {
                return null;
            }
            sightings = new ArrayList<PlayerSighting>(this.sightingTable.values());
            this.sightingTable.clear();
            numUploads = sightings.size();
        }
        this.lastFlush = Instant.now();
        return this.detectorClient.sendSightings(sightings, this.getUploaderName(), false).whenComplete((b, ex) -> {
            if (ex == null && b.booleanValue()) {
                this.namesUploaded += uniqueNames;
                SwingUtilities.invokeLater(() -> this.panel.setNamesUploaded(this.namesUploaded, false));
                this.sendChatStatusMessage("Successfully uploaded " + numUploads + " locations for " + uniqueNames + " unique players.", forceChatNotification);
            } else {
                this.sendChatStatusMessage("Error sending player sightings!", forceChatNotification);
                if (restoreOnFailure && !(ex instanceof ValidationException)) {
                    Table<CaseInsensitiveString, Integer, PlayerSighting> table = this.sightingTable;
                    synchronized (table) {
                        sightings.forEach(s -> {
                            int region;
                            CaseInsensitiveString name = CaseInsensitiveString.wrap(s.getPlayerName());
                            if (!this.sightingTable.contains((Object)name, (Object)(region = s.getRegionID()))) {
                                this.sightingTable.put((Object)name, (Object)region, s);
                            }
                        });
                    }
                }
            }
        });
    }

    public synchronized void refreshPlayerStats(boolean forceRefresh) {
        if (!forceRefresh) {
            Instant now = Instant.now();
            if (this.config.enableAnonymousUploading() || this.loggedPlayerName == null || !this.navButton.isSelected() || now.isBefore(this.lastStatsRefresh.plusSeconds(150L)) || now.isBefore(this.lastFlush.plusSeconds(30L))) {
                return;
            }
        }
        this.lastStatsRefresh = Instant.now();
        if (this.config.enableAnonymousUploading() || this.loggedPlayerName == null) {
            SwingUtilities.invokeLater(() -> {
                this.panel.setPlayerStatsMap(null);
                this.panel.setPlayerStatsLoading(false);
                this.panel.setWarningVisible(BotDetectorPanel.WarningLabel.ANONYMOUS, this.config.enableAnonymousUploading());
                this.panel.setWarningVisible(BotDetectorPanel.WarningLabel.PLAYER_STATS_ERROR, false);
                if (this.loggedPlayerName == null) {
                    this.panel.forceHideFeedbackPanel();
                }
                this.panel.forceHideFlaggingPanel();
            });
            return;
        }
        SwingUtilities.invokeLater(() -> {
            this.panel.setPlayerStatsLoading(true);
            this.panel.setWarningVisible(BotDetectorPanel.WarningLabel.ANONYMOUS, false);
        });
        String nameAtRequest = this.loggedPlayerName;
        this.detectorClient.requestPlayerStats(nameAtRequest).whenComplete((psm, ex) -> {
            if (this.config.enableAnonymousUploading() || !nameAtRequest.equals(this.loggedPlayerName)) {
                return;
            }
            SwingUtilities.invokeLater(() -> this.panel.setPlayerStatsLoading(false));
            if (ex == null && psm != null) {
                SwingUtilities.invokeLater(() -> {
                    this.panel.setPlayerStatsMap((Map<PlayerStatsType, PlayerStats>)psm);
                    this.panel.setWarningVisible(BotDetectorPanel.WarningLabel.PLAYER_STATS_ERROR, false);
                });
            } else {
                SwingUtilities.invokeLater(() -> this.panel.setWarningVisible(BotDetectorPanel.WarningLabel.PLAYER_STATS_ERROR, true));
            }
        });
    }

    @Subscribe
    private void onBotDetectorPanelActivated(BotDetectorPanelActivated event) {
        if (!this.config.enableAnonymousUploading()) {
            this.refreshPlayerStats(false);
        }
    }

    @Subscribe
    private void onConfigChanged(ConfigChanged event) {
        if (!event.getGroup().equals("botdetector") || event.getKey() == null) {
            return;
        }
        switch (event.getKey()) {
            case "addDetectOption": {
                if (this.client == null) break;
                this.menuManager.removePlayerMenuItem(PREDICT_OPTION);
                if (!this.config.addPredictOption()) break;
                this.menuManager.addPlayerMenuItem(PREDICT_OPTION);
                break;
            }
            case "enableAnonymousReporting": {
                this.refreshPlayerStats(true);
                SwingUtilities.invokeLater(() -> {
                    this.panel.forceHideFeedbackPanel();
                    this.panel.forceHideFlaggingPanel();
                });
                break;
            }
            case "panelFontType": {
                SwingUtilities.invokeLater(() -> this.panel.setFontType(this.config.panelFontType()));
                break;
            }
            case "showFeedbackTextbox": {
                SwingUtilities.invokeLater(() -> this.panel.setFeedbackTextboxVisible(this.config.showFeedbackTextbox()));
                break;
            }
            case "autoSendMinutes": 
            case "sendAtLogout": {
                this.updateTimeToAutoSend();
            }
        }
    }

    @Subscribe
    private void onGameStateChanged(GameStateChanged event) {
        switch (event.getGameState()) {
            case LOGIN_SCREEN: {
                if (this.loggedPlayerName == null) break;
                this.flushPlayersToClient(false);
                this.persistentSightings.clear();
                this.feedbackedPlayers.clear();
                this.feedbackedPlayersText.clear();
                this.flaggedPlayers.clear();
                this.loggedPlayerName = null;
                this.refreshPlayerStats(true);
                SwingUtilities.invokeLater(() -> this.panel.setWarningVisible(BotDetectorPanel.WarningLabel.NAME_ERROR, false));
                this.lastStatsRefresh = Instant.MIN;
                break;
            }
            case LOGGED_IN: {
                if (this.isCurrentWorldBlocked || this.loggedPlayerName == null || !this.previousTwoGameStates.contains((Object)GameState.LOGGED_IN) || !this.previousTwoGameStates.contains((Object)GameState.LOADING)) break;
                this.client.getPlayers().forEach(this::processPlayer);
            }
        }
        this.previousTwoGameStates.offer((Object)event.getGameState());
    }

    @Subscribe
    private void onPlayerSpawned(PlayerSpawned event) {
        this.processPlayer(event.getPlayer());
    }

    private void processPlayer(Player player) {
        boolean invalidName;
        if (player == null) {
            return;
        }
        String rawName = player.getName();
        boolean bl = invalidName = rawName == null || rawName.length() == 0 || rawName.charAt(0) == '#' || rawName.charAt(0) == '[';
        if (player == this.client.getLocalPlayer()) {
            if (this.loggedPlayerName == null || !this.loggedPlayerName.equals(rawName)) {
                if (invalidName) {
                    this.loggedPlayerName = null;
                    SwingUtilities.invokeLater(() -> this.panel.setWarningVisible(BotDetectorPanel.WarningLabel.NAME_ERROR, true));
                } else {
                    this.loggedPlayerName = rawName;
                    this.updateTimeToAutoSend();
                    this.refreshPlayerStats(true);
                    SwingUtilities.invokeLater(() -> this.panel.setWarningVisible(BotDetectorPanel.WarningLabel.NAME_ERROR, false));
                }
            }
            return;
        }
        if (this.isCurrentWorldBlocked || invalidName) {
            return;
        }
        String playerName = BotDetectorPlugin.normalizePlayerName(rawName);
        CaseInsensitiveString wrappedName = CaseInsensitiveString.wrap(playerName);
        this.clientThread.invoke(() -> {
            WorldPoint wp;
            boolean instanced = this.client.isInInstancedRegion();
            WorldPoint worldPoint = wp = !instanced ? player.getWorldLocation() : WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)player.getLocalLocation());
            if (wp.getRegionID() > 16000) {
                log.warn(String.format("Player sighting with invalid region ID. (name:'%s' x:%d y:%d z:%d r:%d s:%d)", playerName, wp.getX(), wp.getY(), wp.getPlane(), wp.getRegionID(), (instanced ? 1 : 0) + (this.client.isInInstancedRegion() ? 2 : 0)));
                return;
            }
            HashMap<KitType, Integer> equipment = new HashMap<KitType, Integer>();
            long geValue = 0L;
            for (KitType kitType : KitType.values()) {
                int itemId = player.getPlayerComposition().getEquipmentId(kitType);
                if (itemId < 0) continue;
                equipment.put(kitType, itemId);
                geValue += (long)this.itemManager.getItemPriceWithSource(itemId, false);
            }
            PlayerSighting p = PlayerSighting.builder().playerName(playerName).regionID(wp.getRegionID()).worldX(wp.getX()).worldY(wp.getY()).plane(wp.getPlane()).equipment(equipment).equipmentGEValue(geValue).timestamp(Instant.now()).worldNumber(this.currentWorldNumber).inMembersWorld(this.isCurrentWorldMembers).inPVPWorld(this.isCurrentWorldPVP).build();
            Table<CaseInsensitiveString, Integer, PlayerSighting> table = this.sightingTable;
            synchronized (table) {
                this.sightingTable.put((Object)wrappedName, (Object)p.getRegionID(), (Object)p);
            }
            this.persistentSightings.put(wrappedName, p);
        });
    }

    @Subscribe
    private void onCommandExecuted(CommandExecuted event) {
        Consumer consumer = (Consumer)this.commandConsumerMap.get((Object)CaseInsensitiveString.wrap(event.getCommand()));
        if (consumer != null) {
            consumer.accept(event.getArguments());
        }
    }

    @Subscribe
    private void onClientShutdown(ClientShutdown event) {
        CompletableFuture<Boolean> future;
        if (this.config.uploadOnShutdown() && (future = this.flushPlayersToClient(false)) != null) {
            event.waitFor(future);
        }
    }

    private void verifyDiscord(ChatMessage chatMessage, String message) {
        if (!this.authToken.getTokenType().getPermissions().contains((Object)AuthTokenPermission.VERIFY_DISCORD)) {
            return;
        }
        if (message.length() <= VERIFY_DISCORD_COMMAND.length()) {
            return;
        }
        String author = chatMessage.getType().equals((Object)ChatMessageType.PRIVATECHATOUT) ? this.loggedPlayerName : Text.sanitize((String)chatMessage.getName());
        String code = message.substring(VERIFY_DISCORD_COMMAND.length() + 1).trim();
        if (!VERIFY_DISCORD_CODE_PATTERN.matcher(code).matches()) {
            return;
        }
        this.detectorClient.verifyDiscord(this.authToken.getToken(), author, StringUtils.leftPad((String)code, (int)4, (char)'0')).whenComplete((b, ex) -> {
            if (ex == null && b.booleanValue()) {
                this.sendChatStatusMessage("Discord verified for '" + author + "'!", true);
            } else if (ex instanceof UnauthorizedTokenException) {
                this.sendChatStatusMessage("Invalid token for Discord verification, cannot verify '" + author + "'.", true);
            } else if (this.config.showDiscordVerificationErrors()) {
                this.sendChatStatusMessage("Could not verify Discord for '" + author + "'" + (String)(ex != null ? ": " + ex.getMessage() : "."), true);
            }
        });
    }

    private void statsChatCommand(ChatMessage chatMessage, String message) {
        if (message.length() != STATS_CHAT_COMMAND.length()) {
            return;
        }
        StatsCommandDetailLevel detailLevel = this.config.statsChatCommandDetailLevel();
        if (detailLevel == StatsCommandDetailLevel.OFF) {
            return;
        }
        String author = chatMessage.getType().equals((Object)ChatMessageType.PRIVATECHATOUT) ? this.loggedPlayerName : Text.sanitize((String)chatMessage.getName());
        this.detectorClient.requestPlayerStats(author).whenComplete((map, ex) -> {
            if (ex == null && map != null) {
                PlayerStats totalStats = (PlayerStats)map.get((Object)PlayerStatsType.TOTAL);
                ChatMessageBuilder response = new ChatMessageBuilder().append(ChatColorType.HIGHLIGHT).append("Bot Detector stats -");
                if (totalStats == null || totalStats.getNamesUploaded() <= 0L) {
                    response.append(ChatColorType.NORMAL).append(" No plugin stats for this player");
                } else {
                    if (detailLevel == StatsCommandDetailLevel.DETAILED) {
                        response.append(ChatColorType.NORMAL).append(" Total Uploads:").append(ChatColorType.HIGHLIGHT).append(String.format(" %,d", totalStats.getNamesUploaded())).append(ChatColorType.NORMAL).append(" Feedback Sent:").append(ChatColorType.HIGHLIGHT).append(String.format(" %,d", totalStats.getFeedbackSent())).append(ChatColorType.NORMAL).append(" Possible Bans:").append(ChatColorType.HIGHLIGHT).append(String.format(" %,d", totalStats.getPossibleBans()));
                    }
                    response.append(ChatColorType.NORMAL).append(" Confirmed Bans:").append(ChatColorType.HIGHLIGHT).append(String.format(" %,d", totalStats.getConfirmedBans()));
                    PlayerStats manualStats = (PlayerStats)map.get((Object)PlayerStatsType.MANUAL);
                    if (manualStats != null && manualStats.getNamesUploaded() > 0L) {
                        if (detailLevel == StatsCommandDetailLevel.DETAILED) {
                            response.append(ChatColorType.NORMAL).append(" Manual Flags:").append(ChatColorType.HIGHLIGHT).append(String.format(" %,d", manualStats.getNamesUploaded())).append(ChatColorType.NORMAL).append(" Manual Possible Bans:").append(ChatColorType.HIGHLIGHT).append(String.format(" %,d", manualStats.getPossibleBans()));
                        }
                        response.append(ChatColorType.NORMAL).append(" Manual Confirmed Bans:").append(ChatColorType.HIGHLIGHT).append(String.format(" %,d", manualStats.getConfirmedBans()));
                        response.append(ChatColorType.NORMAL).append(" Manual Flag Accuracy:").append(ChatColorType.HIGHLIGHT).append(new DecimalFormat(" 0.00%").format(manualStats.getAccuracy()));
                    }
                }
                String builtResponse = response.build();
                MessageNode messageNode = chatMessage.getMessageNode();
                this.clientThread.invokeLater(() -> {
                    messageNode.setRuneLiteFormatMessage(builtResponse);
                    this.client.refreshChat();
                });
            }
        });
    }

    @Subscribe
    private void onMenuEntryAdded(MenuEntryAdded event) {
        if (!this.config.addPredictOption()) {
            return;
        }
        int componentId = event.getActionParam1();
        int groupId = WidgetInfo.TO_GROUP((int)componentId);
        String option = event.getOption();
        if (groupId == WidgetInfo.FRIENDS_LIST.getGroupId() || groupId == WidgetInfo.FRIENDS_CHAT.getGroupId() || groupId == WidgetInfo.CHATBOX.getGroupId() && !KICK_OPTION.equals(option) || groupId == WidgetInfo.RAIDING_PARTY.getGroupId() || groupId == WidgetInfo.PRIVATE_CHAT_MESSAGE.getGroupId() || groupId == WidgetInfo.IGNORE_LIST.getGroupId() || componentId == WidgetInfo.CLAN_MEMBER_LIST.getId() || componentId == WidgetInfo.CLAN_GUEST_MEMBER_LIST.getId()) {
            if (!AFTER_OPTIONS.contains((Object)option) || option.equals(DELETE_OPTION) && groupId != WidgetInfo.IGNORE_LIST.getGroupId()) {
                return;
            }
            this.client.createMenuEntry(-1).setOption(this.getPredictOption(event.getTarget())).setTarget(event.getTarget()).setType(MenuAction.RUNELITE).setParam0(event.getActionParam0()).setParam1(event.getActionParam1()).setIdentifier(event.getIdentifier());
        }
    }

    @Subscribe
    private void onMenuOpened(MenuOpened event) {
        MenuEntry[] menuEntries;
        if (this.config.predictOptionDefaultColor() == null && this.config.predictOptionFlaggedColor() == null) {
            return;
        }
        boolean changeReportOption = this.config.applyPredictColorsOnReportOption();
        for (MenuEntry entry : menuEntries = event.getMenuEntries()) {
            Player player;
            int type = entry.getType().getId();
            if (type >= 2000) {
                type -= 2000;
            }
            if (type == MenuAction.RUNELITE_PLAYER.getId() && entry.getOption().equals(PREDICT_OPTION) && (player = this.client.getCachedPlayers()[entry.getIdentifier()]) != null) {
                entry.setOption(this.getPredictOption(player.getName()));
            }
            if (!changeReportOption || !entry.getOption().equals(REPORT_OPTION) || !PLAYER_MENU_ACTIONS.contains((Object)entry.getType()) && entry.getType() != MenuAction.CC_OP_LOW_PRIORITY || (player = this.client.getCachedPlayers()[entry.getIdentifier()]) == null) continue;
            entry.setOption(this.getReportOption(player.getName()));
        }
    }

    @Subscribe
    private void onMenuOptionClicked(MenuOptionClicked event) {
        String optionText = Text.removeTags((String)event.getMenuOption());
        if ((event.getMenuAction() == MenuAction.RUNELITE || event.getMenuAction() == MenuAction.RUNELITE_PLAYER) && optionText.equals(PREDICT_OPTION) || this.config.predictOnReport() && (PLAYER_MENU_ACTIONS.contains((Object)event.getMenuAction()) || event.getMenuAction() == MenuAction.CC_OP_LOW_PRIORITY) && optionText.equals(REPORT_OPTION)) {
            String name;
            if (event.getMenuAction() == MenuAction.RUNELITE_PLAYER || PLAYER_MENU_ACTIONS.contains((Object)event.getMenuAction())) {
                Player player = this.client.getCachedPlayers()[event.getId()];
                if (player == null) {
                    return;
                }
                name = player.getName();
            } else {
                name = event.getMenuTarget();
            }
            if (name != null) {
                String toPredict = Text.removeTags((String)name);
                if (this.config.predictOptionCopyName()) {
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(toPredict), null);
                }
                this.predictPlayer(toPredict);
            }
        }
    }

    @Subscribe
    private void onWorldChanged(WorldChanged event) {
        this.processCurrentWorld();
    }

    public void predictPlayer(String playerName) {
        SwingUtilities.invokeLater(() -> {
            if (!this.navButton.isSelected()) {
                this.navButton.getOnSelect().run();
            }
            this.panel.predictPlayer(playerName);
        });
    }

    public void sendChatStatusMessage(String msg) {
        this.sendChatStatusMessage(msg, false);
    }

    public void sendChatStatusMessage(String msg, boolean forceShow) {
        if ((forceShow || this.config.enableChatStatusMessages()) && this.loggedPlayerName != null) {
            String message = new ChatMessageBuilder().append(ChatColorType.HIGHLIGHT).append(CHAT_MESSAGE_HEADER + msg).build();
            this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(message).build());
        }
    }

    private void processCurrentWorld() {
        this.currentWorldNumber = this.client.getWorld();
        EnumSet types = this.client.getWorldType();
        this.isCurrentWorldMembers = types.contains(WorldType.MEMBERS);
        this.isCurrentWorldPVP = types.contains(WorldType.PVP);
        this.isCurrentWorldBlocked = !ALLOWED_PROFILE_TYPES.contains((Object)RuneScapeProfileType.getCurrent((Client)this.client));
        SwingUtilities.invokeLater(() -> this.panel.setWarningVisible(BotDetectorPanel.WarningLabel.BLOCKED_WORLD, this.isCurrentWorldBlocked));
    }

    public String getUploaderName() {
        return this.getUploaderName(false);
    }

    public String getUploaderName(boolean useAnonymousUUIDFormat) {
        if (this.loggedPlayerName == null) {
            return null;
        }
        if (this.config.enableAnonymousUploading()) {
            return useAnonymousUUIDFormat ? String.format(ANONYMOUS_USER_NAME_UUID_FORMAT, this.anonymousUUID) : ANONYMOUS_USER_NAME;
        }
        return this.loggedPlayerName;
    }

    private String getPredictOption(String playerName) {
        return this.getMenuOption(playerName, PREDICT_OPTION);
    }

    private String getReportOption(String playerName) {
        return this.getMenuOption(playerName, REPORT_OPTION);
    }

    private String getMenuOption(String playerName, String option) {
        CaseInsensitiveString name = BotDetectorPlugin.normalizeAndWrapPlayerName(playerName);
        Color prepend = this.feedbackedPlayers.containsKey(name) || this.flaggedPlayers.containsKey(name) ? this.config.predictOptionFlaggedColor() : this.config.predictOptionDefaultColor();
        return prepend != null ? ColorUtil.prependColorTag((String)option, (Color)prepend) : option;
    }

    public static String normalizePlayerName(String playerName) {
        if (playerName == null) {
            return null;
        }
        return Text.removeTags((String)Text.toJagexName((String)playerName));
    }

    public static CaseInsensitiveString normalizeAndWrapPlayerName(String playerName) {
        return CaseInsensitiveString.wrap(BotDetectorPlugin.normalizePlayerName(playerName));
    }

    private void manualFlushCommand() {
        Instant canFlush = this.lastFlush.plusSeconds(60L);
        Instant now = Instant.now();
        if (now.isAfter(canFlush)) {
            if (this.flushPlayersToClient(true, true) == null) {
                this.sendChatStatusMessage("No player sightings to flush!", true);
            }
        } else {
            long secs = Duration.between(now, canFlush).toMillis() / 1000L + 1L;
            this.sendChatStatusMessage("Please wait " + secs + " seconds before manually flushing players.", true);
        }
    }

    private void manualSightCommand() {
        if (this.isCurrentWorldBlocked) {
            this.sendChatStatusMessage("Cannot refresh player sightings on a blocked world.", true);
        } else if (this.client.getGameState() != GameState.LOGGED_IN) {
            this.sendChatStatusMessage("Current game state must be 'LOGGED_IN'!", true);
        } else {
            this.client.getPlayers().forEach(this::processPlayer);
            this.sendChatStatusMessage("Player sightings refreshed.", true);
        }
    }

    private void manualRefreshStatsCommand() {
        this.refreshPlayerStats(true);
        this.sendChatStatusMessage("Refreshing player stats...", true);
    }

    private void showHideIdCommand(String[] args) {
        String arg;
        switch (arg = args.length > 0 ? args[0] : "") {
            case "1": {
                SwingUtilities.invokeLater(() -> this.panel.setPlayerIdVisible(true));
                this.sendChatStatusMessage("Player ID field added to panel.", true);
                break;
            }
            case "0": {
                SwingUtilities.invokeLater(() -> this.panel.setPlayerIdVisible(false));
                this.sendChatStatusMessage("Player ID field hidden.", true);
                break;
            }
            default: {
                this.sendChatStatusMessage("Argument must be 0 or 1.", true);
            }
        }
    }

    private void putAuthTokenIntoClipboardCommand() {
        if (this.authToken.getTokenType() == AuthTokenType.NONE) {
            this.sendChatStatusMessage("No auth token currently set.", true);
        } else {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(this.authToken.toFullToken()), null);
            this.sendChatStatusMessage(this.authToken.getTokenType() + " auth token copied to clipboard.", true);
        }
    }

    private void setAuthTokenFromClipboardCommand() {
        String clipboardText;
        try {
            clipboardText = Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor).toString().trim();
        }
        catch (UnsupportedFlavorException | IOException ex) {
            this.sendChatStatusMessage("Unable to read system clipboard for dev token.", true);
            log.warn("Error reading clipboard", (Throwable)ex);
            return;
        }
        AuthToken token = AuthToken.fromFullToken(clipboardText);
        if (token.getTokenType() == AuthTokenType.NONE) {
            this.sendChatStatusMessage("Auth token in clipboard must be of format 'prefix|Suffix_Alpha-numeric' with a valid prefix and a suffix between 12 and 32 characters long.", true);
        } else {
            this.authToken = token;
            this.config.setAuthFullToken(token.toFullToken());
            this.sendChatStatusMessage(token.getTokenType() + " auth token successfully set from clipboard.", true);
        }
    }

    private void clearAuthTokenCommand() {
        this.authToken = AuthToken.EMPTY_TOKEN;
        this.config.setAuthFullToken(null);
        this.sendChatStatusMessage("Auth token cleared.", true);
    }

    private void toggleShowDiscordVerificationErrors() {
        boolean newVal = !this.config.showDiscordVerificationErrors();
        this.config.setShowDiscordVerificationErrors(newVal);
        if (newVal) {
            this.sendChatStatusMessage("Discord verification errors will now be shown in the chat", true);
        } else {
            this.sendChatStatusMessage("Discord verification errors will no longer be shown in the chat", true);
        }
    }

    private void displayPluginVersionError() {
        JEditorPane ep = new JEditorPane("text/html", "<html><body>Could not parse the plugin version from the properties file!<br>This should never happen! Please contact us on our <a href=" + BotDetectorPanel.WebLink.DISCORD.getLink() + ">Discord</a>.</body></html>");
        ep.addHyperlinkListener(e -> {
            if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                LinkBrowser.browse((String)e.getURL().toString());
            }
        });
        ep.setEditable(false);
        JOptionPane.showOptionDialog(null, ep, "Error starting Bot Detector!", -1, 0, null, new String[]{"Ok"}, "Ok");
    }

    public String getLoggedPlayerName() {
        return this.loggedPlayerName;
    }

    public AuthToken getAuthToken() {
        return this.authToken;
    }

    public Table<CaseInsensitiveString, Integer, PlayerSighting> getSightingTable() {
        return this.sightingTable;
    }

    public Map<CaseInsensitiveString, PlayerSighting> getPersistentSightings() {
        return this.persistentSightings;
    }

    public Map<CaseInsensitiveString, FeedbackPredictionLabel> getFeedbackedPlayers() {
        return this.feedbackedPlayers;
    }

    public Map<CaseInsensitiveString, String> getFeedbackedPlayersText() {
        return this.feedbackedPlayersText;
    }

    public Map<CaseInsensitiveString, Boolean> getFlaggedPlayers() {
        return this.flaggedPlayers;
    }
}

