/*
 * Decompiled with CFR 0.152.
 */
package com.botdetector;

import com.botdetector.model.PlayerStatsType;
import com.botdetector.model.StatsCommandDetailLevel;
import com.botdetector.ui.PanelFontType;
import java.awt.Color;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;
import net.runelite.client.config.Range;
import net.runelite.client.config.Units;

@ConfigGroup(value="botdetector")
public interface BotDetectorConfig
extends Config {
    public static final String CONFIG_GROUP = "botdetector";
    public static final String ONLY_SEND_AT_LOGOUT_KEY = "sendAtLogout";
    public static final String AUTO_SEND_MINUTES_KEY = "autoSendMinutes";
    public static final String ADD_PREDICT_OPTION_KEY = "addDetectOption";
    public static final String ANONYMOUS_UPLOADING_KEY = "enableAnonymousReporting";
    public static final String PANEL_FONT_TYPE_KEY = "panelFontType";
    public static final String AUTH_FULL_TOKEN_KEY = "authToken";
    public static final String SHOW_FEEDBACK_TEXTBOX = "showFeedbackTextbox";
    public static final String SHOW_DISCORD_VERIFICATION_ERRORS = "showDiscordVerificationErrors";
    public static final String ANONYMOUS_UUID_KEY = "anonymousUUID";
    public static final int AUTO_SEND_MINIMUM_MINUTES = 5;
    public static final int AUTO_SEND_MAXIMUM_MINUTES = 360;
    @ConfigSection(position=1, name="Upload Settings", description="Settings for how the plugin uploads player data.")
    public static final String uploadSection = "uploadSection";
    @ConfigSection(position=2, name="Panel Settings", description="Settings for the plugin's panel.")
    public static final String panelSection = "panelSection";
    @ConfigSection(position=3, name="'Predict' Settings", description="Settings for the 'Predict' right-click option.")
    public static final String predictSection = "predictSection";
    @ConfigSection(position=4, name="Other Settings", description="Other miscellaneous settings.")
    public static final String miscSection = "miscSection";

    @ConfigItem(position=1, keyName="enableAnonymousReporting", name="Anonymous Uploading", description="Your name will not be included with your name uploads.<br>Disable if you'd like to track your contributions.", section="uploadSection")
    default public boolean enableAnonymousUploading() {
        return true;
    }

    @ConfigItem(position=2, keyName="sendAtLogout", name="Send Names Only After Logout", description="Waits to upload names until you've logged out. Use this if you have a poor connection.<br><span style='color:red'>WARNING:</span> Names <b>will not</b> be sent if RuneLite is closed completely<br>before logging out, unless 'Attempt Send on Close' is turned on.", section="uploadSection")
    default public boolean onlySendAtLogout() {
        return false;
    }

    @ConfigItem(position=3, keyName="uploadOnShutdown", name="Attempt Send on Close", description="Attempts to upload names when closing RuneLite while being logged in.<br><span style='color:red'>WARNING:</span> This may cause the client to take significantly longer to close<br>in the event that the Bot Detector server is being slow or unresponsive.", section="uploadSection")
    default public boolean uploadOnShutdown() {
        return false;
    }

    @ConfigItem(position=4, keyName="autoSendMinutes", name="Send Names Every", description="Sets the amount of time between automatic name uploads.", section="uploadSection")
    @Range(min=5, max=360)
    @Units(value=" mins")
    default public int autoSendMinutes() {
        return 5;
    }

    @ConfigItem(position=1, keyName="autocomplete", name="Prediction Autocomplete", description="Autocomplete names when typing a name to predict in the prediction panel.", section="panelSection")
    default public boolean panelAutocomplete() {
        return true;
    }

    @ConfigItem(position=2, keyName="showBreakdownOnNullConfidence", name="Show Breakdown in Special Cases", description="Show the Prediction Breakdown when predicting certain types of accounts, such as 'Stats Too Low'.", section="panelSection")
    default public boolean showBreakdownOnNullConfidence() {
        return false;
    }

    @ConfigItem(position=3, keyName="showFeedbackTextbox", name="Show Feedback Textbox", description="Show a textbox on the prediction feedback panel where you can explain your feedback to us.", section="panelSection")
    default public boolean showFeedbackTextbox() {
        return true;
    }

    @ConfigItem(position=4, keyName="panelDefaultStatsType", name="Panel Default Stats Tab", description="Sets the initial player statistics tab in the prediction panel for when the plugin is launched.", section="panelSection")
    default public PlayerStatsType panelDefaultStatsType() {
        return PlayerStatsType.TOTAL;
    }

    @ConfigItem(position=5, keyName="panelFontType", name="Panel Font Size", description="Sets the size of the label fields in the prediction panel.", section="panelSection")
    default public PanelFontType panelFontType() {
        return PanelFontType.NORMAL;
    }

    @ConfigItem(position=1, keyName="addDetectOption", name="Right-click 'Predict' Players", description="Adds an entry to player menus to quickly check them in the prediction panel.", section="predictSection")
    default public boolean addPredictOption() {
        return false;
    }

    @ConfigItem(position=2, keyName="predictOnReport", name="'Predict' on Right-click 'Report'", description="Makes the in-game right-click 'Report' option also open the prediction panel.", section="predictSection")
    default public boolean predictOnReport() {
        return false;
    }

    @ConfigItem(position=3, keyName="predictOptionCopyName", name="'Predict' Copy Name to Clipboard", description="Copies the player's name to the clipboard when right-click predicting a player.", section="predictSection")
    default public boolean predictOptionCopyName() {
        return false;
    }

    @ConfigItem(position=4, keyName="predictOptionDefaultColor", name="'Predict' Default Color", description="When right-clicking on a player, the predict option will be this color by default.", section="predictSection")
    public Color predictOptionDefaultColor();

    @ConfigItem(position=5, keyName="predictOptionFlaggedColor", name="'Predict' Voted/Flagged Color", description="When right-clicking on a player that has been flagged or given feedback, the predict option will be this color instead.", section="predictSection")
    public Color predictOptionFlaggedColor();

    @ConfigItem(position=6, keyName="applyPredictColorsOnReportOption", name="Apply Colors to 'Report'", description="Applies the above 'Predict' color options to the in-game 'Report' option as well.", section="predictSection", warning="Enabling this setting may cause issues with other plugins that rely on the 'Report' option being unchanged.")
    default public boolean applyPredictColorsOnReportOption() {
        return false;
    }

    @ConfigItem(position=1, keyName="enableChatNotifications", name="Enable Chat Status Messages", description="Show various plugin status messages in the game chat.", section="miscSection")
    default public boolean enableChatStatusMessages() {
        return false;
    }

    @ConfigItem(position=2, keyName="statsChatCommandDetailLevel", name="'!bdstats' Chat Command Detail Level", description="Enable processing the '!bdstats' command when it appears in the chatbox,<br>which will fetch the message author's plugin stats and display them.", section="miscSection")
    default public StatsCommandDetailLevel statsChatCommandDetailLevel() {
        return StatsCommandDetailLevel.CONFIRMED_ONLY;
    }

    @ConfigItem(keyName="authToken", name="", description="", hidden=true)
    default public String authFullToken() {
        return null;
    }

    @ConfigItem(keyName="authToken", name="", description="", hidden=true)
    public void setAuthFullToken(String var1);

    @ConfigItem(keyName="showDiscordVerificationErrors", name="", description="", hidden=true)
    default public boolean showDiscordVerificationErrors() {
        return true;
    }

    @ConfigItem(keyName="showDiscordVerificationErrors", name="", description="", hidden=true)
    public void setShowDiscordVerificationErrors(boolean var1);
}

