/*
 * Decompiled with CFR 0.152.
 */
package com.dabolink;

import com.dabolink.XPRelicSoundConfig;
import com.google.inject.Provides;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Skill;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.StatChanged;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="XP Relic Sound")
public class XPRelicSoundPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(XPRelicSoundPlugin.class);
    private static final String RELIC_CHAT_MESSAGE = new ChatMessageBuilder().append(ChatColorType.HIGHLIGHT).append("You have a sad feeling like you would have got a relic.").build();
    private final Map<Skill, Integer> skillXPMap = new HashMap<Skill, Integer>();
    @Inject
    private Client client;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private XPRelicSoundConfig config;

    protected void startUp() throws Exception {
    }

    protected void shutDown() throws Exception {
    }

    @Subscribe
    public void onStatChanged(StatChanged statChanged) {
        Skill skill = statChanged.getSkill();
        int experience = statChanged.getXp();
        if (!this.skillXPMap.containsKey(skill)) {
            this.skillXPMap.put(skill, experience);
            return;
        }
        if (!this.config.includeMaxedSkills() && statChanged.getLevel() >= 99) {
            this.skillXPMap.put(skill, experience);
            return;
        }
        if (this.rollChance(experience - this.skillXPMap.get(skill))) {
            this.procRelicEffect();
        }
        this.skillXPMap.put(skill, experience);
    }

    private void procRelicEffect() {
        if (this.config.includeChatMessage()) {
            this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(RELIC_CHAT_MESSAGE).build());
        }
        this.client.playSoundEffect(this.config.relicSound());
    }

    private boolean rollChance(int experienceGained) {
        double chance = this.config.procChance();
        if (chance == 0.0) {
            return false;
        }
        double procChance = 1.0 - Math.pow((chance - 1.0) / chance, experienceGained);
        double roll = Math.random();
        return roll <= procChance;
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOGGED_IN) {
            this.skillXPMap.clear();
        }
    }

    @Provides
    XPRelicSoundConfig provideConfig(ConfigManager configManager) {
        return (XPRelicSoundConfig)configManager.getConfig(XPRelicSoundConfig.class);
    }
}

