/*
 * Decompiled with CFR 0.152.
 */
package io.hydrox.contextualcursor;

import java.util.HashMap;
import java.util.Map;

public enum SpellSprite {
    WIND_STRIKE(15),
    CONFUSE(16),
    WATER_STRIKE(17),
    LVL_1_ENCHANT("lvl-1 enchant", 18),
    EARTH_STRIKE(19),
    WEAKEN(20),
    FIRE_STRIKE(21),
    WIND_BOLT(23),
    CURSE(24),
    BIND(319),
    LOW_LEVEL_ALCHEMY(25),
    WATER_BOLT(26),
    LVL_2_ENCHANT("lvl-2 enchant", 28),
    EARTH_BOLT(29),
    TELEKINETIC_GRAB(31),
    FIRE_BOLT(32),
    CRUMBLE_UNDEAD(34),
    WIND_BLAST(35),
    SUPERHEAT_ITEM(36),
    WATER_BLAST(38),
    LVL_3_ENCHANT("lvl-3 enchant", 39),
    IBAN_BLAST(53),
    SNARE(320),
    MAGIC_DART(324),
    EARTH_BLAST(40),
    HIGH_LEVEL_ALCHEMY(41),
    CHARGE_WATER_ORB(42),
    LVL_4_ENCHANT("lvl-4 enchant", 43),
    FIRE_BLAST(44),
    CHARGE_EARTH_ORB(45),
    SARADOMIN_STRIKE(61),
    CLAWS_OF_GUTHIX(60),
    FLAMES_OF_ZAMORAK(59),
    WIND_WAVE(46),
    CHARGE_FIRE_ORB(47),
    WATER_WAVE(48),
    CHARGE_AIR_ORB(49),
    VULNERABILITY(56),
    LVL_5_ENCHANT("lvl-5 enchant", 50),
    EARTH_WAVE(51),
    ENFEEBLE(57),
    TELEOTHER_LUMBRIDGE(349),
    FIRE_WAVE(52),
    ENTANGLE(321),
    STUN(58),
    WIND_SURGE(362),
    TELEOTHER_FALADOR(350),
    WATER_SURGE(363),
    TELE_BLOCK(352),
    LVL_6_ENCHANT("lvl-6 enchant", 353),
    TELEOTHER_CAMELOT(351),
    EARTH_SURGE(364),
    LVL_7_ENCHANT("lvl-7 enchant", 361),
    FIRE_SURGE(365),
    SMOKE_RUSH(329),
    SHADOW_RUSH(337),
    BLOOD_RUSH(333),
    ICE_RUSH(325),
    SMOKE_BURST(330),
    SHADOW_BURST(338),
    BLOOD_BURST(334),
    ICE_BURST(326),
    SMOKE_BLITZ(331),
    SHADOW_BLITZ(339),
    BLOOD_BLITZ(335),
    ICE_BLITZ(327),
    SMOKE_BARRAGE(332),
    SHADOW_BARRAGE(340),
    BLOOD_BARRAGE(336),
    ICE_BARRAGE(328),
    CURE_PLANT(567),
    MONSTER_EXAMINE(577),
    STAT_SPY(576),
    FERTILE_SOIL(553),
    PLANK_MAKE(581),
    CURE_OTHER(559),
    STAT_RESTORE_POT_SHARE(554),
    BOOST_POTION_SHARE(551),
    ENERGY_TRANSFER(558),
    HEAL_OTHER(560),
    VENGEANCE_OTHER(561),
    BASIC_REANIMATION(1247),
    ADEPT_REANIMATION(1248),
    EXPERT_REANIMATION(1249),
    MASTER_REANIMATION(1250),
    RESURRECT_CROPS(1266),
    DARK_LURE(1316),
    MARK_OF_DARKNESS(1305),
    GHOSTLY_GRASP(1267),
    SKELETAL_GRASP(1268),
    UNDEAD_GRASP(1269),
    INFERIOR_DEMONBANE(1302),
    SUPERIOR_DEMONBANE(1303),
    DARK_DEMONBANE(1304);

    private final String name;
    final int spriteID;
    private static final Map<String, SpellSprite> map;

    private SpellSprite(int spriteID) {
        this(null, spriteID);
    }

    private String getName() {
        return this.name != null ? this.name : this.name().toLowerCase().replace("_", " ");
    }

    static SpellSprite get(String spell) {
        return map.get(spell);
    }

    private SpellSprite(String name, int spriteID) {
        this.name = name;
        this.spriteID = spriteID;
    }

    static {
        map = new HashMap<String, SpellSprite>();
        for (SpellSprite spell : SpellSprite.values()) {
            map.put(spell.getName(), spell);
        }
    }
}

