/*
 * Decompiled with CFR 0.152.
 */
package io.hydrox.contextualcursor;

import com.google.common.collect.Sets;
import io.hydrox.contextualcursor.ContextualCursor;
import io.hydrox.contextualcursor.ContextualCursorPlugin;
import io.hydrox.contextualcursor.SpellSprite;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.lang.reflect.Field;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.swing.JPanel;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.Point;
import net.runelite.api.SpritePixels;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.ui.ClientUI;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.ImageComponent;
import net.runelite.client.ui.overlay.components.LayoutableRenderableEntity;
import net.runelite.client.ui.overlay.tooltip.Tooltip;
import net.runelite.client.ui.overlay.tooltip.TooltipManager;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextualCursorWorkerOverlay
extends Overlay {
    private static final Logger log = LoggerFactory.getLogger(ContextualCursorWorkerOverlay.class);
    private static final Cursor BLANK_MOUSE = Toolkit.getDefaultToolkit().createCustomCursor(new BufferedImage(32, 32, 2), new java.awt.Point(0, 0), "blank");
    private static final Tooltip SPACER_TOOLTIP = new Tooltip((LayoutableRenderableEntity)new ImageComponent(new BufferedImage(1, 10, 2)));
    private static final Pattern SPELL_FINDER = Pattern.compile(">(.*?)(?:</col>| -> )");
    private static final int MENU_OPTION_HEIGHT = 15;
    private static final int MENU_EXTRA_TOP = 4;
    private static final int MENU_EXTRA_BOTTOM = 3;
    private static final int MENU_BORDERS_TOTAL = 22;
    private static final Set<MenuAction> IGNORED_ACTIONS = Sets.newHashSet((Object[])new MenuAction[]{MenuAction.WALK, MenuAction.CC_OP, MenuAction.CANCEL, MenuAction.CC_OP_LOW_PRIORITY});
    private final Client client;
    private final ClientUI clientUI;
    private final ContextualCursorPlugin plugin;
    private final SpriteManager spriteManager;
    private final TooltipManager tooltipManager;
    private Point menuOpenPoint;
    private boolean cursorOverriden;
    private Cursor originalCursor;
    private static final Set<MenuAction> SPELL_TYPES = Sets.newHashSet((Object[])new MenuAction[]{MenuAction.WIDGET_TARGET_ON_GAME_OBJECT, MenuAction.WIDGET_TARGET_ON_NPC, MenuAction.WIDGET_TARGET_ON_PLAYER, MenuAction.WIDGET_TARGET_ON_GROUND_ITEM, MenuAction.WIDGET_TARGET_ON_WIDGET, MenuAction.WIDGET_TARGET});

    @Inject
    ContextualCursorWorkerOverlay(Client client, ClientUI clientUI, ContextualCursorPlugin plugin, SpriteManager spriteManager, TooltipManager tooltipManager) {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
        this.setPriority(OverlayPriority.HIGHEST);
        this.client = client;
        this.clientUI = clientUI;
        this.plugin = plugin;
        this.spriteManager = spriteManager;
        this.tooltipManager = tooltipManager;
    }

    private void storeOriginalCursor() {
        if (this.cursorOverriden) {
            return;
        }
        try {
            Field f = this.clientUI.getClass().getDeclaredField("container");
            f.setAccessible(true);
            JPanel container = (JPanel)f.get(this.clientUI);
            Cursor currentCursor = container.getCursor();
            if (!currentCursor.getName().equals("blank")) {
                this.originalCursor = container.getCursor();
            }
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            // empty catch block
        }
    }

    void resetCursor() {
        if (this.cursorOverriden) {
            this.cursorOverriden = false;
            this.plugin.setSpriteToDraw(null);
            if (this.originalCursor != null) {
                this.clientUI.setCursor(this.originalCursor);
            } else {
                this.clientUI.resetCursor();
            }
        }
    }

    public Dimension render(Graphics2D graphics) {
        MenuEntry menuEntry;
        if (this.plugin.isAltPressed()) {
            this.resetCursor();
            return null;
        }
        if (this.client.isMenuOpen()) {
            menuEntry = this.processMenu();
        } else {
            this.menuOpenPoint = this.client.getMouseCanvasPosition();
            MenuEntry[] menuEntries = this.client.getMenuEntries();
            int last = menuEntries.length - 1;
            if (last < 0) {
                return null;
            }
            menuEntry = menuEntries[last];
        }
        if (menuEntry == null || !menuEntry.isItemOp() && !menuEntry.getOption().equals("Examine") && IGNORED_ACTIONS.contains(menuEntry.getType())) {
            this.resetCursor();
            return null;
        }
        this.processEntry(graphics, menuEntry.getType(), menuEntry.getOption(), menuEntry.getTarget());
        return null;
    }

    private MenuEntry processMenu() {
        MenuEntry[] menuEntries = this.client.getMenuEntries();
        int menuHeight = menuEntries.length * 15 + 22;
        int menuTop = menuHeight + this.menuOpenPoint.getY() > this.client.getCanvasHeight() ? this.client.getCanvasHeight() - menuHeight : this.menuOpenPoint.getY();
        int fromTop = this.client.getMouseCanvasPosition().getY() - 4 - menuTop;
        int index = menuEntries.length - fromTop / 15;
        if (index >= menuEntries.length || index < 0) {
            return null;
        }
        return menuEntries[index];
    }

    private void processEntry(Graphics2D graphics, MenuAction type, String option, String target) {
        if (SPELL_TYPES.contains(type) && option.equals("Cast")) {
            Matcher spellFinder = SPELL_FINDER.matcher(target.toLowerCase());
            if (!spellFinder.find()) {
                return;
            }
            String spellText = spellFinder.group(1);
            SpellSprite spell = SpellSprite.get(spellText);
            BufferedImage magicSprite = this.spriteManager.getSprite(spell.spriteID, 0);
            if (magicSprite == null) {
                return;
            }
            this.setSpriteToDraw(magicSprite);
            return;
        }
        ContextualCursor cursor = option.equals("Lookup") && Text.removeTags((String)target).startsWith("Wiki ->") ? ContextualCursor.WIKI : ContextualCursor.get(Text.removeTags((String)option));
        if (cursor == null) {
            this.resetCursor();
            return;
        }
        BufferedImage sprite = cursor.getCursor();
        if (cursor.getSpriteID() != null && (sprite = this.client.getSpriteOverrides().containsKey(cursor.getSpriteID()) ? ((SpritePixels)this.client.getSpriteOverrides().get(cursor.getSpriteID())).toBufferedImage() : this.spriteManager.getSprite(cursor.getSpriteID().intValue(), 0)) == null) {
            return;
        }
        if (sprite != null) {
            this.setSpriteToDraw(sprite);
        }
    }

    private void setSpriteToDraw(BufferedImage sprite) {
        this.storeOriginalCursor();
        this.clientUI.setCursor(BLANK_MOUSE);
        this.cursorOverriden = true;
        this.plugin.setSpriteToDraw(sprite);
        this.tooltipManager.addFront(SPACER_TOOLTIP);
    }
}

