/*
 * Decompiled with CFR 0.152.
 */
package io.hydrox.contextualcursor;

import io.hydrox.contextualcursor.ContextualCursorDrawOverlay;
import io.hydrox.contextualcursor.ContextualCursorWorkerOverlay;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import net.runelite.api.GameState;
import net.runelite.api.events.GameStateChanged;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.input.MouseListener;
import net.runelite.client.input.MouseManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Contextual Cursor", description="RSHD-style image cursors")
public class ContextualCursorPlugin
extends Plugin
implements KeyListener,
MouseListener {
    private static final Logger log = LoggerFactory.getLogger(ContextualCursorPlugin.class);
    @Inject
    private ContextualCursorDrawOverlay contextualCursorDrawOverlay;
    @Inject
    private ContextualCursorWorkerOverlay contextualCursorWorkerOverlay;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private KeyManager keyManager;
    @Inject
    private MouseManager mouseManager;
    private boolean altPressed;
    private BufferedImage spriteToDraw;

    protected void startUp() {
        this.overlayManager.add((Overlay)this.contextualCursorWorkerOverlay);
        this.overlayManager.add((Overlay)this.contextualCursorDrawOverlay);
        this.keyManager.registerKeyListener((KeyListener)this);
        this.mouseManager.registerMouseListener((MouseListener)this);
    }

    protected void shutDown() {
        this.overlayManager.remove((Overlay)this.contextualCursorWorkerOverlay);
        this.overlayManager.remove((Overlay)this.contextualCursorDrawOverlay);
        this.contextualCursorWorkerOverlay.resetCursor();
        this.keyManager.unregisterKeyListener((KeyListener)this);
        this.mouseManager.unregisterMouseListener((MouseListener)this);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() != GameState.LOGGED_IN && event.getGameState() != GameState.LOADING) {
            this.contextualCursorWorkerOverlay.resetCursor();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.altPressed = keyEvent.isAltDown();
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.altPressed = keyEvent.isAltDown();
    }

    public MouseEvent mouseEntered(MouseEvent mouseEvent) {
        this.altPressed = mouseEvent.isAltDown();
        return mouseEvent;
    }

    public MouseEvent mouseExited(MouseEvent mouseEvent) {
        this.altPressed = mouseEvent.isAltDown();
        return mouseEvent;
    }

    public MouseEvent mouseDragged(MouseEvent mouseEvent) {
        return mouseEvent;
    }

    public MouseEvent mouseMoved(MouseEvent mouseEvent) {
        return mouseEvent;
    }

    public MouseEvent mouseClicked(MouseEvent mouseEvent) {
        return mouseEvent;
    }

    public MouseEvent mousePressed(MouseEvent mouseEvent) {
        return mouseEvent;
    }

    public MouseEvent mouseReleased(MouseEvent mouseEvent) {
        return mouseEvent;
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public boolean isAltPressed() {
        return this.altPressed;
    }

    public BufferedImage getSpriteToDraw() {
        return this.spriteToDraw;
    }

    public void setSpriteToDraw(BufferedImage spriteToDraw) {
        this.spriteToDraw = spriteToDraw;
    }
}

