/*
 * Decompiled with CFR 0.152.
 */
package io.hydrox.contextualcursor;

import io.hydrox.contextualcursor.ContextualCursor;
import io.hydrox.contextualcursor.ContextualCursorPlugin;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Point;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;

public class ContextualCursorDrawOverlay
extends Overlay {
    private static final Point POINTER_OFFSET = new Point(-5, 0);
    private static final Point CENTRAL_POINT = new Point(16, 18);
    private final Client client;
    private final ContextualCursorPlugin plugin;

    @Inject
    ContextualCursorDrawOverlay(Client client, ContextualCursorPlugin plugin) {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ALWAYS_ON_TOP);
        this.setPriority(OverlayPriority.HIGHEST);
        this.client = client;
        this.plugin = plugin;
    }

    public Dimension render(Graphics2D graphics) {
        BufferedImage sprite = this.plugin.getSpriteToDraw();
        if (sprite == null) {
            return null;
        }
        Point mousePos = this.client.getMouseCanvasPosition();
        ContextualCursor blank = ContextualCursor.BLANK;
        graphics.drawImage((Image)blank.getCursor(), mousePos.getX() + POINTER_OFFSET.getX(), mousePos.getY() + POINTER_OFFSET.getY(), null);
        int spriteX = POINTER_OFFSET.getX() + CENTRAL_POINT.getX() - sprite.getWidth() / 2;
        int spriteY = POINTER_OFFSET.getY() + CENTRAL_POINT.getY() - sprite.getHeight() / 2;
        graphics.drawImage((Image)sprite, mousePos.getX() + spriteX, mousePos.getY() + spriteY, null);
        return null;
    }
}

