/*
 * Decompiled with CFR 0.152.
 */
package io.hydrox.contextualcursor;

import io.hydrox.contextualcursor.ContextualCursorPlugin;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import net.runelite.client.util.ImageUtil;

public enum ContextualCursor {
    BLANK("blank", new String[0]),
    GENERIC("generic", new String[0]),
    BANK("bank", "bank"),
    CLOSE("close", "close"),
    CONFIGURE(1654, "configure", "configuration"),
    DRINK("drink", "drink"),
    DROP("drop", "drop", "empty", "deposit"),
    EAT("eat", "eat"),
    ENTER("enter", "climb-into", "enter", "exit", "yanille", "varrock", "seers' village", "camelot", "grand exchange", "watchtower", "go-through"),
    EQUIP("equip", "wield", "wear", "equip"),
    EXCHANGE(1112, "exchange", "trade", "trade with", "collect"),
    FRIEND(782, "add friend"),
    IGNORE(783, "add ignore"),
    IMPOSSIBLE("impossible", "destroy"),
    LADDER("ladder", "climb"),
    LADDER_DOWN("ladder_down", "climb-down", "climb down"),
    LADDER_UP("ladder_up", "climb-up", "climb up"),
    OPEN("open", "open"),
    PICK_UP("pick_up", "take", "withdraw", "fill"),
    PLANK("plank", "buy-plank"),
    READ("read", "read", "story"),
    REPORT(1239, "report"),
    SEARCH("search", "search", "lookup", "examine", "view", "look-inside"),
    TALK("talk", "talk", "talk-to", "talk to"),
    UNTIE("untie", "tether"),
    USE("use", "use"),
    WIKI("wiki", "lookup-entity"),
    AGILITY(204, "balance", "balance-across", "climb-across", "climb-on", "climb-over", "cross", "grab", "grapple", "hurdle", "jump", "jump-up", "jump-to", "jump-off", "jump-in", "jump-on", "kick", "leap", "shoot", "squeeze-past", "squeeze-through", "swing", "swing across", "swing-across", "swing-on", "tap", "tag", "teeth-grip", "tread-softly", "vault", "walk-on", "walk-across", "crawl-through", "jump-over"),
    ATTACK(197, "attack"),
    CONSTRUCTION(221, "build", "remove"),
    COOKING(212, "cook", "churn", "cook-at", "prepare-fish"),
    CRAFTING(207, "spin"),
    FARMING(217, "check-health", "harvest", "rake", "pick", "pick-fruit", "clear", "pay"),
    FIREMAKING(213, "light", "feed"),
    FISHING(211, "net", "bait", "lure", "small net", "harpoon", "cage", "big net", "use-rod", "fish", "take-net"),
    HERBLORE(205, "clean"),
    HUNTER(220, "catch", "lay", "dismantle", "reset", "check"),
    MAGIC(202, "spellbook", "teleport", "teleport menu"),
    MINING(209, "mine", "smash-to-bits"),
    PRAYER(201, "pray", "bury", "pray-at", "offer-fish", "scatter"),
    RUNECRAFTING(215, "craft-rune", "imbue"),
    SMITHING(210, "smelt", "smith", "hammer", "refine"),
    SLAYER(216, "assignment"),
    STRENGTH(198, "bang", "move"),
    THIEVING(206, "steal-from", "pickpocket", "search for traps", "pick-lock"),
    WOODCUTTING(214, "chop down", "chop-down", "chop", "cut", "hack");

    private BufferedImage cursor;
    private Integer spriteID;
    private String[] actions;
    private static final Map<String, ContextualCursor> cursorMap;

    private ContextualCursor(String cursor_path, String ... actions) {
        this.cursor = ImageUtil.loadImageResource(ContextualCursorPlugin.class, (String)String.format("cursors/%s.png", cursor_path));
        this.actions = actions;
    }

    private ContextualCursor(int spriteID, String ... actions) {
        this.spriteID = spriteID;
        this.actions = actions;
    }

    static ContextualCursor get(String action) {
        return cursorMap.getOrDefault(action.toLowerCase(), GENERIC);
    }

    public BufferedImage getCursor() {
        return this.cursor;
    }

    public Integer getSpriteID() {
        return this.spriteID;
    }

    public String[] getActions() {
        return this.actions;
    }

    static {
        cursorMap = new HashMap<String, ContextualCursor>();
        for (ContextualCursor cursor : ContextualCursor.values()) {
            for (String action : cursor.actions) {
                cursorMap.put(action, cursor);
            }
        }
    }
}

