/*
 * Decompiled with CFR 0.152.
 */
package com.infernostats;

import com.google.inject.Provides;
import com.infernostats.DeathChargeReminderConfig;
import com.infernostats.DeathChargeReminderOverlay;
import com.infernostats.DeathChargeTimer;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameTick;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Death Charge Reminder")
public class DeathChargeReminderPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(DeathChargeReminderPlugin.class);
    private DeathChargeTimer timer = null;
    private int overlayVisible;
    @Inject
    private DeathChargeReminderConfig config;
    @Inject
    private DeathChargeReminderOverlay overlay;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private Client client;
    public static final Pattern DEATH_CHARGE_ACTIVE = Pattern.compile("<col=[A-Fa-f\\d]+>Upon the death of your next foe, some of your special attack energy will be restored\\.</col>");

    protected void startUp() {
        this.overlayVisible = -1;
        this.timer = new DeathChargeTimer();
    }

    protected void shutDown() {
        this.removeOverlay();
        this.timer = null;
    }

    @Provides
    DeathChargeReminderConfig provideConfig(ConfigManager configManager) {
        return (DeathChargeReminderConfig)configManager.getConfig(DeathChargeReminderConfig.class);
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        String message = event.getMessage();
        if (message.matches(DEATH_CHARGE_ACTIVE.pattern())) {
            this.timer.start();
        }
    }

    @Subscribe
    public void onGameTick(GameTick e) {
        if (this.overlayVisible != -1) {
            this.checkOverlay();
        }
        if (this.timer == null) {
            return;
        }
        switch (this.timer.getState()) {
            case ACTIVE: {
                this.removeOverlay();
                break;
            }
            case EXPIRED: {
                this.addOverlay();
                this.timer.stop();
                break;
            }
        }
    }

    private void addOverlay() {
        this.overlayManager.add((Overlay)this.overlay);
        this.overlayVisible = this.client.getTickCount();
    }

    private void removeOverlay() {
        this.overlayManager.remove((Overlay)this.overlay);
        this.overlayVisible = -1;
    }

    private void checkOverlay() {
        if (this.client.getTickCount() - this.overlayVisible >= this.config.overlayDuration()) {
            this.removeOverlay();
        }
    }
}

