/*
 * Decompiled with CFR 0.152.
 */
package com.optimalpoints;

import com.optimalpoints.CurrentBossData;
import com.optimalpoints.DefenseComparer;
import com.optimalpoints.OptimalPointsConfig;
import com.optimalpoints.OptimalPointsPlugin;
import com.optimalpoints.PointsComparer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.NPCComposition;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;
import net.runelite.client.ui.overlay.outline.ModelOutlineRenderer;

public class OptimalPointsSceneOverlay
extends Overlay {
    private static final Color TOP_TEXT_COLOR = Color.RED;
    private static final Color STANDARD_TEXT_COLOR = Color.WHITE;
    private static final NumberFormat TIME_LEFT_FORMATTER = DecimalFormat.getInstance(Locale.US);
    private final Client client;
    private final OptimalPointsConfig config;
    private final OptimalPointsPlugin plugin;
    private final ModelOutlineRenderer modelOutlineRenderer;

    @Inject
    OptimalPointsSceneOverlay(Client client, OptimalPointsConfig config, OptimalPointsPlugin plugin, ModelOutlineRenderer modelOutlineRenderer) {
        this.client = client;
        this.config = config;
        this.plugin = plugin;
        this.modelOutlineRenderer = modelOutlineRenderer;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.plugin.isInNightmareZone()) {
            return null;
        }
        List<CurrentBossData> bossDataList = this.plugin.getHighlightedNpcs();
        if (bossDataList.size() == 0) {
            return null;
        }
        if (!this.config.rankByDefense()) {
            bossDataList.sort(new PointsComparer());
        } else {
            bossDataList.sort(new DefenseComparer());
        }
        int rank = 1;
        for (CurrentBossData bossData : bossDataList) {
            this.renderNpcOverlay(graphics, bossData.getNpcData(), this.config.rankByDefense() ? bossData.getDefense_score() : bossData.getPoints_score(), rank);
            ++rank;
        }
        return null;
    }

    private void renderNpcOverlay(Graphics2D graphics, NPC actor, Integer score, Integer rank) {
        String displayText;
        Point textLocation;
        LocalPoint lp;
        if (rank > this.config.maxRankToShow()) {
            return;
        }
        Color colour = this.getColorForRank(rank);
        NPCComposition npcComposition = actor.getTransformedComposition();
        if (npcComposition == null || !npcComposition.isInteractible() || actor.isDead()) {
            return;
        }
        if (this.config.highlightHull()) {
            Shape objectClickbox = actor.getConvexHull();
            this.renderPoly(graphics, colour, objectClickbox);
        }
        if (this.config.highlightOutline()) {
            this.modelOutlineRenderer.drawOutline(actor, this.config.borderWidth(), colour, this.config.outlineFeather());
        }
        if (this.config.highlightTile()) {
            int size = npcComposition.getSize();
            lp = actor.getLocalLocation();
            Polygon tilePoly = Perspective.getCanvasTileAreaPoly((Client)this.client, (LocalPoint)lp, (int)size);
            this.renderPoly(graphics, colour, tilePoly);
        }
        if (this.config.highlightSouthWestTile()) {
            int size = npcComposition.getSize();
            lp = actor.getLocalLocation();
            int x = lp.getX() - (size - 1) * 128 / 2;
            int y = lp.getY() - (size - 1) * 128 / 2;
            Polygon southWestTilePoly = Perspective.getCanvasTilePoly((Client)this.client, (LocalPoint)new LocalPoint(x, y));
            this.renderPoly(graphics, colour, southWestTilePoly);
        }
        if ((textLocation = actor.getCanvasTextLocation(graphics, displayText = score.toString(), actor.getLogicalHeight() + 40)) != null) {
            OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)textLocation, (String)displayText, (Color)(rank == 1 ? TOP_TEXT_COLOR : STANDARD_TEXT_COLOR));
        }
    }

    private void renderPoly(Graphics2D graphics, Color color, Shape polygon) {
        if (polygon != null) {
            graphics.setColor(color);
            graphics.setStroke(new BasicStroke(this.config.borderWidth()));
            graphics.draw(polygon);
            graphics.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), 20));
            graphics.fill(polygon);
        }
    }

    private Color getColorForRank(int rank) {
        switch (rank) {
            case 1: {
                return this.config.getHighlightColor1();
            }
            case 2: {
                return this.config.getHighlightColor2();
            }
            case 3: {
                return this.config.getHighlightColor3();
            }
            case 4: {
                return this.config.getHighlightColor4();
            }
        }
        return Color.WHITE;
    }

    static {
        ((DecimalFormat)TIME_LEFT_FORMATTER).applyPattern("#0.0");
    }
}

