/*
 * Decompiled with CFR 0.152.
 */
package com.optimalpoints;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Provides;
import com.optimalpoints.CurrentBossData;
import com.optimalpoints.MemorizedNpc;
import com.optimalpoints.NMZBoss;
import com.optimalpoints.NMZBossList;
import com.optimalpoints.OptimalPointsConfig;
import com.optimalpoints.OptimalPointsSceneOverlay;
import java.io.InputStream;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.GraphicsObject;
import net.runelite.api.NPC;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.GraphicsObjectCreated;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.NpcSpawned;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.WildcardMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="NMZ Optimal Points", description="Highlight NMZ bosses and displays their point value", tags={"highlight", "npcs", "nmz"})
public class OptimalPointsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(OptimalPointsPlugin.class);
    private static final int[] NMZ_MAP_REGION = new int[]{9033};
    private static final int MAX_ACTOR_VIEW_RANGE = 15;
    private static final String HARD_IDENTIFIER = "(hard)";
    @Inject
    private Client client;
    @Inject
    private OptimalPointsConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private OptimalPointsSceneOverlay optimalPointsSceneOverlay;
    @Inject
    private KeyManager keyManager;
    @Inject
    private ClientThread clientThread;
    private final List<CurrentBossData> highlightedNpcs = new ArrayList<CurrentBossData>();
    private final Map<Integer, MemorizedNpc> deadNpcsToDisplay = new HashMap<Integer, MemorizedNpc>();
    private Instant lastTickUpdate;
    private final Map<Integer, MemorizedNpc> memorizedNpcs = new HashMap<Integer, MemorizedNpc>();
    private final List<String> highlights = new ArrayList<String>();
    private final List<NMZBoss> nmzBosses = new ArrayList<NMZBoss>();
    private final Set<Integer> npcTags = new HashSet<Integer>();
    private final List<NPC> spawnedNpcsThisTick = new ArrayList<NPC>();
    private final List<NPC> despawnedNpcsThisTick = new ArrayList<NPC>();
    private final Set<WorldPoint> teleportGraphicsObjectSpawnedThisTick = new HashSet<WorldPoint>();
    private WorldPoint lastPlayerLocation;
    private boolean skipNextSpawnCheck = false;

    @Provides
    OptimalPointsConfig provideConfig(ConfigManager configManager) {
        return (OptimalPointsConfig)configManager.getConfig(OptimalPointsConfig.class);
    }

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.optimalPointsSceneOverlay);
        this.clientThread.invoke(() -> {
            this.skipNextSpawnCheck = true;
            this.rebuildAllNpcs();
        });
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.optimalPointsSceneOverlay);
        this.clientThread.invoke(() -> {
            this.deadNpcsToDisplay.clear();
            this.memorizedNpcs.clear();
            this.spawnedNpcsThisTick.clear();
            this.despawnedNpcsThisTick.clear();
            this.teleportGraphicsObjectSpawnedThisTick.clear();
            this.npcTags.clear();
            this.highlightedNpcs.clear();
        });
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOGIN_SCREEN || event.getGameState() == GameState.HOPPING) {
            this.highlightedNpcs.clear();
            this.deadNpcsToDisplay.clear();
            this.memorizedNpcs.forEach((id, npc) -> npc.setDiedOnTick(-1));
            this.lastPlayerLocation = null;
            this.skipNextSpawnCheck = true;
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if (!configChanged.getGroup().equals("npcindicators")) {
            return;
        }
        this.clientThread.invoke(this::rebuildAllNpcs);
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned npcSpawned) {
        NPC npc = npcSpawned.getNpc();
        String npcName = npc.getName();
        if (npcName == null) {
            return;
        }
        if (this.npcTags.contains(npc.getIndex())) {
            this.memorizeNpc(npc);
            this.addHighlightedNpc(npc);
            this.spawnedNpcsThisTick.add(npc);
            return;
        }
        if (this.highlightMatchesNPCName(npcName)) {
            this.addHighlightedNpc(npc);
            if (!this.client.isInInstancedRegion()) {
                this.memorizeNpc(npc);
                this.spawnedNpcsThisTick.add(npc);
            }
        }
    }

    @Subscribe
    public void onNpcDespawned(NpcDespawned npcDespawned) {
        NPC npc = npcDespawned.getNpc();
        if (this.memorizedNpcs.containsKey(npc.getIndex())) {
            this.despawnedNpcsThisTick.add(npc);
        }
        this.highlightedNpcs.removeIf(t -> t.getNpcData() == npc);
    }

    @Subscribe
    public void onGraphicsObjectCreated(GraphicsObjectCreated event) {
        GraphicsObject go = event.getGraphicsObject();
        if (go.getId() == 86) {
            this.teleportGraphicsObjectSpawnedThisTick.add(WorldPoint.fromLocal((Client)this.client, (LocalPoint)go.getLocation()));
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        this.removeOldHighlightedRespawns();
        this.validateSpawnedNpcs();
        this.lastTickUpdate = Instant.now();
        this.lastPlayerLocation = this.client.getLocalPlayer().getWorldLocation();
    }

    private static boolean isInViewRange(WorldPoint wp1, WorldPoint wp2) {
        int distance = wp1.distanceTo(wp2);
        return distance < 15;
    }

    private static WorldPoint getWorldLocationBehind(NPC npc) {
        int orientation = npc.getOrientation() / 256;
        int dx = 0;
        int dy = 0;
        switch (orientation) {
            case 0: {
                dy = -1;
                break;
            }
            case 1: {
                dx = -1;
                dy = -1;
                break;
            }
            case 2: {
                dx = -1;
                break;
            }
            case 3: {
                dx = -1;
                dy = 1;
                break;
            }
            case 4: {
                dy = 1;
                break;
            }
            case 5: {
                dx = 1;
                dy = 1;
                break;
            }
            case 6: {
                dx = 1;
                break;
            }
            case 7: {
                dx = 1;
                dy = -1;
            }
        }
        WorldPoint currWP = npc.getWorldLocation();
        return new WorldPoint(currWP.getX() - dx, currWP.getY() - dy, currWP.getPlane());
    }

    private void memorizeNpc(NPC npc) {
        int npcIndex = npc.getIndex();
        this.memorizedNpcs.putIfAbsent(npcIndex, new MemorizedNpc(npc));
    }

    private void removeOldHighlightedRespawns() {
        this.deadNpcsToDisplay.values().removeIf(x -> x.getDiedOnTick() + x.getRespawnTime() <= this.client.getTickCount() + 1);
    }

    private void getBosses() {
        InputStream boss_list = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("nmzbosses.csv");
        assert (boss_list != null);
        NMZBossList nmzBossList = new NMZBossList(boss_list);
        this.nmzBosses.addAll(nmzBossList.getNmzBossList());
    }

    @VisibleForTesting
    void rebuildAllNpcs() {
        this.getBosses();
        for (NMZBoss boss : this.nmzBosses) {
            this.highlights.add(boss.getName() + "*");
        }
        this.highlightedNpcs.clear();
        if (this.client.getGameState() != GameState.LOGGED_IN && this.client.getGameState() != GameState.LOADING || !this.isInNightmareZone()) {
            return;
        }
        for (NPC npc : this.client.getNpcs()) {
            String npcName = npc.getName();
            if (npcName == null) continue;
            if (this.npcTags.contains(npc.getIndex())) {
                this.addHighlightedNpc(npc);
                continue;
            }
            if (this.highlightMatchesNPCName(npcName)) {
                if (!this.client.isInInstancedRegion()) {
                    this.memorizeNpc(npc);
                }
                this.addHighlightedNpc(npc);
                continue;
            }
            this.memorizedNpcs.remove(npc.getIndex());
        }
    }

    private boolean highlightMatchesNPCName(String npcName) {
        for (String highlight : this.highlights) {
            if (!WildcardMatcher.matches((String)highlight, (String)npcName)) continue;
            return true;
        }
        return false;
    }

    private void validateSpawnedNpcs() {
        if (this.skipNextSpawnCheck) {
            this.skipNextSpawnCheck = false;
        } else {
            MemorizedNpc mn;
            for (NPC npc : this.despawnedNpcsThisTick) {
                if (!this.teleportGraphicsObjectSpawnedThisTick.isEmpty() && this.teleportGraphicsObjectSpawnedThisTick.contains(npc.getWorldLocation()) || !OptimalPointsPlugin.isInViewRange(this.client.getLocalPlayer().getWorldLocation(), npc.getWorldLocation()) || (mn = this.memorizedNpcs.get(npc.getIndex())) == null) continue;
                mn.setDiedOnTick(this.client.getTickCount() + 1);
                if (mn.getPossibleRespawnLocations().isEmpty()) continue;
                log.debug("Starting {} tick countdown for {}", (Object)mn.getRespawnTime(), (Object)mn.getNpcName());
                this.deadNpcsToDisplay.put(mn.getNpcIndex(), mn);
            }
            for (NPC npc : this.spawnedNpcsThisTick) {
                if (!this.teleportGraphicsObjectSpawnedThisTick.isEmpty() && (this.teleportGraphicsObjectSpawnedThisTick.contains(npc.getWorldLocation()) || this.teleportGraphicsObjectSpawnedThisTick.contains(OptimalPointsPlugin.getWorldLocationBehind(npc))) || this.lastPlayerLocation == null || !OptimalPointsPlugin.isInViewRange(this.lastPlayerLocation, npc.getWorldLocation())) continue;
                mn = this.memorizedNpcs.get(npc.getIndex());
                if (mn.getDiedOnTick() != -1) {
                    int respawnTime = this.client.getTickCount() + 1 - mn.getDiedOnTick();
                    if (mn.getRespawnTime() == -1 || respawnTime < mn.getRespawnTime()) {
                        mn.setRespawnTime(respawnTime);
                    }
                    mn.setDiedOnTick(-1);
                }
                WorldPoint npcLocation = npc.getWorldLocation();
                WorldPoint possibleOtherNpcLocation = OptimalPointsPlugin.getWorldLocationBehind(npc);
                mn.getPossibleRespawnLocations().removeIf(x -> x.distanceTo(npcLocation) != 0 && x.distanceTo(possibleOtherNpcLocation) != 0);
                if (!mn.getPossibleRespawnLocations().isEmpty()) continue;
                mn.getPossibleRespawnLocations().add(npcLocation);
                mn.getPossibleRespawnLocations().add(possibleOtherNpcLocation);
            }
        }
        this.spawnedNpcsThisTick.clear();
        this.despawnedNpcsThisTick.clear();
        this.teleportGraphicsObjectSpawnedThisTick.clear();
    }

    void addHighlightedNpc(NPC npc) {
        for (NMZBoss boss : this.nmzBosses) {
            if (!WildcardMatcher.matches((String)(boss.getName() + "*"), (String)npc.getName())) continue;
            if (npc.getName().contains(HARD_IDENTIFIER)) {
                this.highlightedNpcs.add(new CurrentBossData(npc, boss.getHardValue(), boss.getDefenseHardValue()));
                continue;
            }
            this.highlightedNpcs.add(new CurrentBossData(npc, boss.getNormalValue(), boss.getDefenseValue()));
        }
    }

    public boolean isInNightmareZone() {
        if (this.client.getLocalPlayer() == null) {
            return false;
        }
        return this.client.getLocalPlayer().getWorldLocation().getPlane() > 0 && Arrays.equals(this.client.getMapRegions(), NMZ_MAP_REGION);
    }

    List<CurrentBossData> getHighlightedNpcs() {
        return this.highlightedNpcs;
    }

    Map<Integer, MemorizedNpc> getDeadNpcsToDisplay() {
        return this.deadNpcsToDisplay;
    }

    Instant getLastTickUpdate() {
        return this.lastTickUpdate;
    }
}

