/*
 * Decompiled with CFR 0.152.
 */
package com.ClanEventAttendance;

import com.ClanEventAttendance.ClanEventAttendanceConfig;
import com.ClanEventAttendance.ClanEventAttendancePanel;
import com.ClanEventAttendance.MemberAttendance;
import com.ClanEventAttendance.config.ClanChannelType;
import com.ClanEventAttendance.config.OutputFormat;
import com.google.inject.Provides;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.FriendsChatMember;
import net.runelite.api.Player;
import net.runelite.api.clan.ClanChannelMember;
import net.runelite.api.events.ClanChannelChanged;
import net.runelite.api.events.ClanMemberJoined;
import net.runelite.api.events.ClanMemberLeft;
import net.runelite.api.events.FriendsChatMemberJoined;
import net.runelite.api.events.FriendsChatMemberLeft;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.PlayerDespawned;
import net.runelite.api.events.PlayerSpawned;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Clan Event Attendance", description="Tracks clan attendance and time spent at events.", tags={"clan", "event", "attendance", "time"})
public class ClanEventAttendancePlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ClanEventAttendancePlugin.class);
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private Client client;
    @Inject
    private ClanEventAttendanceConfig config;
    private ClanEventAttendancePanel panel;
    private NavigationButton navButton;
    private int eventStartedAt;
    private int eventStoppedAt;
    public boolean eventRunning;
    private final Map<String, MemberAttendance> attendanceBuffer = new TreeMap<String, MemberAttendance>();
    private String presentColorText;
    private String absentColorText;
    private boolean CC_Valid;
    private boolean FC_Valid;
    private int ScanDelay;
    private final ArrayList<String> ClanMembers = new ArrayList();
    static final String CONFIG_GROUP = "ClanEventAttendance";

    @Provides
    ClanEventAttendanceConfig provideConfig(ConfigManager configManager) {
        return (ClanEventAttendanceConfig)configManager.getConfig(ClanEventAttendanceConfig.class);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        switch (event.getGameState()) {
            case HOPPING: 
            case LOGGING_IN: {
                this.ScanDelay = 1;
            }
        }
    }

    protected void startUp() {
        this.panel = (ClanEventAttendancePanel)((Object)this.injector.getInstance(ClanEventAttendancePanel.class));
        BufferedImage icon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"panel_icon.png");
        this.navButton = NavigationButton.builder().tooltip("Clan Event Attendance").icon(icon).priority(20).panel((PluginPanel)this.panel).build();
        this.clientToolbar.addNavigation(this.navButton);
        this.attendanceBuffer.clear();
        this.eventRunning = false;
        this.initConfig();
    }

    protected void shutDown() {
        this.clientToolbar.removeNavigation(this.navButton);
        this.attendanceBuffer.clear();
        this.eventRunning = false;
    }

    public void startEvent() {
        this.attendanceBuffer.clear();
        this.eventStartedAt = this.client.getTickCount();
        this.eventRunning = true;
        this.ScanDelay = 1;
        this.panel.updatePanel(this.config, this);
        this.panel.setText("");
    }

    public void stopEvent() {
        for (String key : this.attendanceBuffer.keySet()) {
            this.compileTicks(key);
        }
        this.eventStoppedAt = this.client.getTickCount();
        this.eventRunning = false;
        this.panel.setText(this.generateTextData(true));
        this.panel.updatePanel(this.config, this);
    }

    private boolean IsValid(Player player, boolean validateCC, boolean validateFC) {
        if (validateCC && this.CC_Valid && player.isClanMember()) {
            return true;
        }
        if (validateFC && this.FC_Valid && player.isFriendsChatMember()) {
            return true;
        }
        return validateCC && this.CC_Valid && this.ClanMembers.contains(this.nameToKey(player.getName()));
    }

    @Subscribe
    public void onPlayerSpawned(PlayerSpawned event) {
        if (!this.eventRunning) {
            return;
        }
        Player player = event.getPlayer();
        if (!this.IsValid(player, true, true)) {
            return;
        }
        String playerName = player.getName();
        this.addPlayer(player);
        this.unpausePlayer(playerName);
    }

    @Subscribe
    public void onPlayerDespawned(PlayerDespawned event) {
        if (!this.eventRunning) {
            return;
        }
        Player player = event.getPlayer();
        String playerName = player.getName();
        String playerKey = this.nameToKey(player.getName());
        if (!this.attendanceBuffer.containsKey(playerKey)) {
            return;
        }
        this.compileTicks(playerName);
        this.pausePlayer(playerName);
    }

    @Subscribe
    public void onClanChannelChanged(ClanChannelChanged event) {
        this.ClanMembers.clear();
        if (event.getClanChannel() == null) {
            return;
        }
        this.ScanDelay = 1;
    }

    @Subscribe
    public void onClanMemberJoined(ClanMemberJoined event) {
        if (!this.eventRunning) {
            return;
        }
        if (!this.CC_Valid) {
            return;
        }
        ClanChannelMember member = event.getClanMember();
        this.ClanMembers.add(this.nameToKey(member.getName()));
        if (member.getWorld() != this.client.getWorld()) {
            return;
        }
        String memberName = member.getName();
        for (Player player : this.client.getPlayers()) {
            if (player == null) continue;
            String playerName = player.getName();
            if (!this.nameToKey(memberName).equals(this.nameToKey(playerName))) continue;
            this.addPlayer(player);
            this.unpausePlayer(playerName);
            break;
        }
    }

    @Subscribe
    public void onClanMemberLeft(ClanMemberLeft event) {
        if (!this.eventRunning) {
            return;
        }
        if (!this.CC_Valid) {
            return;
        }
        ClanChannelMember member = event.getClanMember();
        this.ClanMembers.remove(this.nameToKey(member.getName()));
        if (member.getWorld() != this.client.getWorld()) {
            return;
        }
        String memberName = member.getName();
        String playerKey = this.nameToKey(memberName);
        if (!this.attendanceBuffer.containsKey(playerKey)) {
            return;
        }
        MemberAttendance ma = this.attendanceBuffer.get(playerKey);
        if (this.IsValid(ma.member, false, true)) {
            return;
        }
        this.compileTicks(memberName);
        this.pausePlayer(memberName);
    }

    @Subscribe
    public void onFriendsChatMemberJoined(FriendsChatMemberJoined event) {
        if (!this.eventRunning) {
            return;
        }
        if (!this.FC_Valid) {
            return;
        }
        FriendsChatMember member = event.getMember();
        if (member.getWorld() != this.client.getWorld()) {
            return;
        }
        String memberName = member.getName();
        for (Player player : this.client.getPlayers()) {
            if (player == null) continue;
            String playerName = player.getName();
            if (!this.nameToKey(memberName).equals(this.nameToKey(playerName))) continue;
            this.addPlayer(player);
            this.unpausePlayer(playerName);
            break;
        }
    }

    @Subscribe
    public void onFriendsChatMemberLeft(FriendsChatMemberLeft event) {
        if (!this.eventRunning) {
            return;
        }
        if (!this.FC_Valid) {
            return;
        }
        FriendsChatMember member = event.getMember();
        if (member.getWorld() != this.client.getWorld()) {
            return;
        }
        String memberName = member.getName();
        String playerKey = this.nameToKey(memberName);
        if (!this.attendanceBuffer.containsKey(playerKey)) {
            return;
        }
        MemberAttendance ma = this.attendanceBuffer.get(playerKey);
        if (this.IsValid(ma.member, true, false)) {
            return;
        }
        this.compileTicks(memberName);
        this.pausePlayer(memberName);
    }

    private void addPlayer(Player player) {
        String playerKey = this.nameToKey(player.getName());
        if (!this.attendanceBuffer.containsKey(playerKey)) {
            MemberAttendance memberAttendance = new MemberAttendance(player, this.client.getTickCount() - this.eventStartedAt, this.client.getTickCount(), 0, false);
            this.attendanceBuffer.put(playerKey, memberAttendance);
        }
    }

    private void pausePlayer(String playerName) {
        String playerKey = this.nameToKey(playerName);
        if (!this.attendanceBuffer.containsKey(playerKey)) {
            return;
        }
        MemberAttendance ma = this.attendanceBuffer.get(playerKey);
        ma.isPresent = false;
    }

    private void unpausePlayer(String playerName) {
        String playerKey = this.nameToKey(playerName);
        if (!this.attendanceBuffer.containsKey(playerKey)) {
            return;
        }
        MemberAttendance ma = this.attendanceBuffer.get(playerKey);
        if (ma.isPresent) {
            return;
        }
        ma.isPresent = true;
        ma.tickActivityStarted = this.client.getTickCount();
    }

    private void compileTicks(String playerName) {
        String playerKey = this.nameToKey(playerName);
        if (!this.attendanceBuffer.containsKey(playerKey)) {
            return;
        }
        MemberAttendance ma = this.attendanceBuffer.get(playerKey);
        if (!ma.isPresent) {
            return;
        }
        MemberAttendance memberAttendance = ma;
        memberAttendance.ticksTotal = memberAttendance.ticksTotal + (this.client.getTickCount() - ma.tickActivityStarted);
        ma.tickActivityStarted = this.client.getTickCount();
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        if (!this.eventRunning) {
            return;
        }
        if (this.ScanDelay == 0) {
            this.ClanMembers.clear();
            if (this.client.getClanChannel() != null) {
                this.client.getClanChannel().getMembers().forEach(member -> this.ClanMembers.add(this.nameToKey(member.getName())));
            }
            for (Player player : this.client.getPlayers()) {
                if (player == null || !this.IsValid(player, true, true)) continue;
                this.addPlayer(player);
                this.unpausePlayer(player.getName());
            }
        }
        if (this.ScanDelay >= 0) {
            --this.ScanDelay;
        }
        for (String key : this.attendanceBuffer.keySet()) {
            this.compileTicks(key);
        }
        this.panel.setText(this.generateTextData(false));
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals(CONFIG_GROUP)) {
            this.initConfig();
        }
    }

    private void initConfig() {
        this.CC_Valid = this.config.filterType() == ClanChannelType.CLAN_CHAT || this.config.filterType() == ClanChannelType.BOTH_CHATS;
        this.FC_Valid = this.config.filterType() == ClanChannelType.FRIENDS_CHAT || this.config.filterType() == ClanChannelType.BOTH_CHATS;
        this.presentColorText = "#" + Integer.toHexString(this.config.presentColor().getRGB()).substring(2);
        this.absentColorText = "#" + Integer.toHexString(this.config.absentColor().getRGB()).substring(2);
        if (!this.attendanceBuffer.isEmpty()) {
            this.panel.setText(this.generateTextData(!this.eventRunning));
        }
        this.panel.removeAll();
        this.panel.init(this.config, this);
    }

    private String generateTextData(boolean finalDisplay) {
        StringBuilder activeSB = new StringBuilder();
        StringBuilder inactiveSB = new StringBuilder();
        for (String key : this.attendanceBuffer.keySet()) {
            MemberAttendance ma = this.attendanceBuffer.get(key);
            if (this.ticksToSeconds(ma.ticksTotal) < this.config.presentThreshold()) {
                inactiveSB.append(this.memberAttendanceToString(ma));
                continue;
            }
            activeSB.append(this.memberAttendanceToString(ma));
        }
        StringBuilder attendanceString = new StringBuilder();
        attendanceString.append("<html><body><pre>");
        if (finalDisplay && !this.config.listPrefix().isEmpty()) {
            attendanceString.append(this.config.listPrefix().replaceAll("(\r\n|\n\r|\r|\n)", "<br/>"));
            attendanceString.append("<br/><br/>");
        }
        attendanceString.append("Event Duration: ");
        int durationTargetTick = this.eventRunning ? this.client.getTickCount() : this.eventStoppedAt;
        attendanceString.append(this.timeFormat(this.ticksToSeconds(durationTargetTick - this.eventStartedAt)));
        attendanceString.append("<br/><br/>");
        if (finalDisplay && this.config.discordMarkdown() && this.config.outputFormat() == OutputFormat.TEXT) {
            attendanceString.append("```<br/>");
        }
        if (activeSB.length() > 0) {
            attendanceString.append("Present Members<br/>");
            attendanceString.append("------------------------------<br/>");
            if (this.config.lateMembers()) {
                attendanceString.append(String.format("%-12s | %-6s | %-6s<br/>", "Name", "Time", "Late"));
            } else {
                attendanceString.append(String.format("%-12s | %-6s<br/>", "Name", "Time"));
            }
            attendanceString.append((CharSequence)activeSB);
        }
        if (inactiveSB.length() > 0) {
            if (activeSB.length() > 0) {
                attendanceString.append("<br/>");
            }
            attendanceString.append("Below Threshold (");
            attendanceString.append(this.timeFormat(this.config.presentThreshold()));
            attendanceString.append(")<br/>");
            attendanceString.append("------------------------------<br/>");
            if (this.config.lateMembers()) {
                attendanceString.append(String.format("%-12s | %-6s | %-6s<br/>", "Name", "Time", "Late"));
            } else {
                attendanceString.append(String.format("%-12s | %-6s<br/>", "Name", "Time"));
            }
            attendanceString.append((CharSequence)inactiveSB);
        }
        if (finalDisplay && this.config.discordMarkdown() && this.config.outputFormat() == OutputFormat.TEXT) {
            attendanceString.append("```");
        }
        if (finalDisplay && !this.config.listSuffix().isEmpty()) {
            attendanceString.append("<br/><br/>");
            attendanceString.append(this.config.listSuffix().replaceAll("(\r\n|\n\r|\r|\n)", "<br/>"));
        }
        attendanceString.append("</pre></body></html>");
        return attendanceString.toString();
    }

    private String memberAttendanceToString(MemberAttendance ma) {
        boolean isLate = this.ticksToSeconds(ma.ticksLate) > this.config.lateThreshold();
        String lineColor = "#FFFFFF";
        if (this.eventRunning) {
            String string = lineColor = ma.isPresent ? this.presentColorText : this.absentColorText;
        }
        String ret = this.config.lateMembers() ? String.format("%s%-12s | %-6s | %-6s%s<br/>", "<font color='" + lineColor + "'>", ma.member.getName(), this.timeFormat(this.ticksToSeconds(ma.ticksTotal)), isLate ? this.timeFormat(this.ticksToSeconds(ma.ticksLate)) : "-", "</font>") : String.format("%s%-12s | %-6s%s<br/>", "<font color='" + lineColor + "'>", ma.member.getName(), this.timeFormat(this.ticksToSeconds(ma.ticksTotal)), "</font>");
        return ret;
    }

    private String timeFormat(int totalSeconds) {
        long minute = TimeUnit.SECONDS.toMinutes(totalSeconds);
        long second = TimeUnit.SECONDS.toSeconds(totalSeconds) - TimeUnit.SECONDS.toMinutes(totalSeconds) * 60L;
        if (minute > 99L) {
            return String.format("%03d:%02d", minute, second);
        }
        return String.format("%02d:%02d", minute, second);
    }

    private int ticksToSeconds(int ticks) {
        return (int)((float)ticks * 0.6f);
    }

    private String nameToKey(String playerName) {
        return Text.toJagexName((String)playerName).toLowerCase();
    }
}

