/*
 * Decompiled with CFR 0.152.
 */
package com.ClanEventAttendance;

import com.ClanEventAttendance.ClanEventAttendanceConfig;
import com.ClanEventAttendance.ClanEventAttendancePlugin;
import com.ClanEventAttendance.config.OutputFormat;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.PluginPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ClanEventAttendancePanel
extends PluginPanel {
    private static final Logger log = LoggerFactory.getLogger(ClanEventAttendancePanel.class);
    private final JButton startButton = new JButton();
    private final JButton copyTextButton = new JButton();
    private final JLabel textLabel = new JLabel();
    private final JPanel topButtonsPanel = new JPanel();
    private final JPanel textPanel = new JPanel();
    private final JPanel bottomButtonsPanel = new JPanel();
    private static final String BTN_START_TEXT = "Start Event";
    private static final String BTN_STOP_TEXT = "Stop Event";
    private static final String BTN_COPY_TEXT_TEXT = "Copy to Clipboard";

    ClanEventAttendancePanel() {
    }

    void init(ClanEventAttendanceConfig config, ClanEventAttendancePlugin plugin) {
        this.getParent().setLayout(new BorderLayout());
        this.getParent().add((Component)((Object)this), "Center");
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.topButtonsPanel.setLayout(new BorderLayout(0, 10));
        this.topButtonsPanel.setBorder(new EmptyBorder(0, 0, 10, 0));
        this.startButton.setText(plugin.eventRunning ? BTN_STOP_TEXT : BTN_START_TEXT);
        this.startButton.setFocusable(false);
        this.topButtonsPanel.add((Component)this.startButton, "Center");
        this.textPanel.setLayout(new BorderLayout());
        this.textPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.textPanel.setBorder(new EmptyBorder(0, 5, 0, 5));
        this.textLabel.setOpaque(false);
        this.textLabel.setFont(new Font("Monospaced", 0, 12));
        this.textLabel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.textPanel.add((Component)this.textLabel, "North");
        this.bottomButtonsPanel.setLayout(new BorderLayout());
        this.bottomButtonsPanel.setBorder(new EmptyBorder(10, 0, 0, 0));
        this.copyTextButton.setText(BTN_COPY_TEXT_TEXT);
        this.copyTextButton.setFocusable(false);
        this.add(this.topButtonsPanel, "North");
        this.add(this.textPanel, "Center");
        if (config.topCopyButton()) {
            this.topButtonsPanel.add((Component)this.copyTextButton, "South");
        } else {
            this.bottomButtonsPanel.add((Component)this.copyTextButton, "Center");
            this.add(this.bottomButtonsPanel, "South");
        }
        if (this.startButton.getActionListeners().length > 0) {
            this.startButton.removeActionListener(this.startButton.getActionListeners()[0]);
        }
        this.startButton.addActionListener(e -> {
            if (plugin.eventRunning) {
                if (config.confirmationMessages()) {
                    int result = JOptionPane.showOptionDialog(this.topButtonsPanel, "Are you sure you want to TERMINATE the event?\nYou won't be able to restart it.", "Are you sure?", 0, 2, null, new String[]{"Yes", "No"}, "No");
                    if (result == 0) {
                        plugin.stopEvent();
                    }
                } else {
                    plugin.stopEvent();
                }
            } else if (config.confirmationMessages()) {
                int result = JOptionPane.showOptionDialog(this.topButtonsPanel, "Are you sure you want to START a new event?\nThis will delete current data.", "Are you sure?", 0, 2, null, new String[]{"Yes", "No"}, "No");
                if (result == 0) {
                    plugin.startEvent();
                }
            } else {
                plugin.startEvent();
            }
        });
        this.copyTextButton.addActionListener(e -> {
            String text = this.textLabel.getText();
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            if (config.outputFormat() == OutputFormat.PNG) {
                BufferedImage image = this.createImage(this.textLabel);
                TransferableImage trans = new TransferableImage(image);
                clipboard.setContents(trans, null);
            } else {
                text = text.replaceAll("(<br/>)", "\n");
                text = text.replaceAll("<[^>]*>", "");
                StringSelection stringSelection = new StringSelection(text);
                clipboard.setContents(stringSelection, null);
            }
        });
        this.updatePanel(config, plugin);
    }

    void setText(String data) {
        this.textLabel.setText(data);
    }

    void updatePanel(ClanEventAttendanceConfig config, ClanEventAttendancePlugin plugin) {
        this.startButton.setText(plugin.eventRunning ? BTN_STOP_TEXT : BTN_START_TEXT);
        this.copyTextButton.setEnabled(!config.blockCopyButton() || !plugin.eventRunning);
    }

    public BufferedImage createImage(JLabel label) {
        int w = label.getWidth();
        int h = label.getHeight();
        BufferedImage bi = new BufferedImage(w, h, 1);
        Graphics2D g = bi.createGraphics();
        label.paint(g);
        g.dispose();
        return bi;
    }

    private static class TransferableImage
    implements Transferable {
        Image i;

        public TransferableImage(Image i) {
            this.i = i;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (flavor.equals(DataFlavor.imageFlavor) && this.i != null) {
                return this.i;
            }
            throw new UnsupportedFlavorException(flavor);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] flavors = new DataFlavor[]{DataFlavor.imageFlavor};
            return flavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            DataFlavor[] flavors;
            for (DataFlavor dataFlavor : flavors = this.getTransferDataFlavors()) {
                if (!flavor.equals(dataFlavor)) continue;
                return true;
            }
            return false;
        }
    }
}

