/*
 * Decompiled with CFR 0.152.
 */
package com.ClanEventAttendance;

import com.ClanEventAttendance.config.ClanChannelType;
import com.ClanEventAttendance.config.OutputFormat;
import java.awt.Color;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;
import net.runelite.client.config.Units;

@ConfigGroup(value="ClanEventAttendance")
public interface ClanEventAttendanceConfig
extends Config {
    @ConfigSection(name="General", description="General configurations.", position=1)
    public static final String generalSection = "general";
    @ConfigSection(name="Data Export", description="How to export the data after the event is stopped.", position=2)
    public static final String dataExportSection = "dataExport";
    @ConfigSection(name="User Interface", description="User interface configurations.", position=3)
    public static final String userInterfaceSection = "userInterface";

    @ConfigItem(keyName="filterType", name="Event Chat", description="The chat(s) an event is for.", section="general", position=0)
    default public ClanChannelType filterType() {
        return ClanChannelType.CLAN_CHAT;
    }

    @ConfigItem(keyName="presentThreshold", name="Time Threshold", description="The required time for a member to be consider part of the event expressed in seconds.", section="general", position=1)
    @Units(value="s")
    default public int presentThreshold() {
        return 600;
    }

    @ConfigItem(keyName="lateMembers", name="Include Late Members", description="Enables keeping track of members who are late to an event.", section="general", position=2)
    default public boolean lateMembers() {
        return true;
    }

    @ConfigItem(keyName="lateThreshold", name="Late Threshold", description="The required time for a member to be consider late expressed in seconds.", section="general", position=3)
    @Units(value="s")
    default public int lateThreshold() {
        return 300;
    }

    @ConfigItem(keyName="outputFormat", name="Output Format", description="What gets output to the user's clipboard when the copy button is pressed.", section="dataExport", position=1)
    default public OutputFormat outputFormat() {
        return OutputFormat.TEXT;
    }

    @ConfigItem(keyName="discordMarkdown", name="Discord Code Block", description="Surrounds text attendance lists with a Discord multi-line code block.", section="dataExport", position=2)
    default public boolean discordMarkdown() {
        return true;
    }

    @ConfigItem(keyName="textPrefix", name="List Prefix", description="Text that gets added as a prefix to attendance lists.", section="dataExport", position=3)
    default public String listPrefix() {
        return "Event name: \nHosted by: ";
    }

    @ConfigItem(keyName="textSuffix", name="List Suffix", description="Text that gets added as a suffix to attendance lists.", section="dataExport", position=4)
    default public String listSuffix() {
        return "Thanks for coming!";
    }

    @ConfigItem(keyName="presentColor", name="Present Color", description="The color used for present members in attendance lists.", section="userInterface", position=0)
    default public Color presentColor() {
        return Color.green;
    }

    @ConfigItem(keyName="absentColor", name="Absent Color", description="The color used for absent members in attendance lists.", section="userInterface", position=1)
    default public Color absentColor() {
        return Color.red;
    }

    @ConfigItem(keyName="blockCopyButtons", name="Block Copy Button", description="Blocks the copy button while an event is in progress.", section="userInterface", position=2)
    default public boolean blockCopyButton() {
        return true;
    }

    @ConfigItem(keyName="topCopyButton", name="Top Copy Button", description="Places the copy button at the top instead of the bottom.", section="userInterface", position=1)
    default public boolean topCopyButton() {
        return true;
    }

    @ConfigItem(keyName="confirmationMessages", name="Confirmation Messages", description="Enables confirmation messages when stopping and starting events.", section="userInterface", position=2)
    default public boolean confirmationMessages() {
        return true;
    }
}

