/*
 * Decompiled with CFR 0.152.
 */
package com.spawnmarker;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.spawnmarker.ColorTileMarker;
import com.spawnmarker.SpawnMarkerOverlay;
import com.spawnmarker.TilePoint;
import java.awt.Color;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.NpcSpawned;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Spawn Marker", description="Marks the tile where a creature have spawned", tags={"spot", "marker", "npc", "spawn", "tracker"})
public class SpawnMarkerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(SpawnMarkerPlugin.class);
    private final List<ColorTileMarker> points = new ArrayList<ColorTileMarker>();
    private static LocalDateTime startedUpAt;
    private static final String CONFIG_GROUP = "spawnMarker";
    private static final String REGION_PREFIX = "region_";
    private static final Gson GSON;
    private static final int MAX_SAVE_DISTANCE = 12;
    private static final Color DEFAULT_COLOR;
    private static final Set<Integer> EVENT_NPCS;
    @Inject
    private Client client;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private SpawnMarkerOverlay overlay;
    @Inject
    private ConfigManager configManager;

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.overlay);
        startedUpAt = LocalDateTime.now();
    }

    protected void shutDown() throws Exception {
        this.clearPointsSaved();
        this.overlayManager.remove((Overlay)this.overlay);
    }

    private void clearPointsSaved() {
        this.points.clear();
        int[] regions = this.client.getMapRegions();
        if (regions != null) {
            for (int regionId : regions) {
                this.savePoints(regionId, null);
            }
        }
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned npcSpawned) {
        String npcName;
        if (LocalDateTime.now().isAfter(startedUpAt.plusSeconds(5L)) && StringUtils.isNotBlank((CharSequence)(npcName = npcSpawned.getActor().getName())) && !EVENT_NPCS.contains(npcSpawned.getNpc().getId()) && npcSpawned.getNpc().getCombatLevel() > 0) {
            WorldPoint playerLocation = this.client.getLocalPlayer().getWorldLocation();
            WorldPoint npcLocation = npcSpawned.getActor().getWorldLocation();
            if (npcLocation.distanceTo(playerLocation) > 12) {
                return;
            }
            this.markTile(npcSpawned.getActor().getLocalLocation(), npcName);
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        startedUpAt = LocalDateTime.now();
        if (gameStateChanged.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        this.loadPoints();
    }

    private void savePoints(int regionId, Collection<TilePoint> points) {
        if (points == null || points.isEmpty()) {
            this.configManager.unsetConfiguration(CONFIG_GROUP, REGION_PREFIX + regionId);
            return;
        }
        String json = GSON.toJson(points);
        this.configManager.setConfiguration(CONFIG_GROUP, REGION_PREFIX + regionId, json);
    }

    private Collection<TilePoint> getPoints(int regionId) {
        String json = this.configManager.getConfiguration(CONFIG_GROUP, REGION_PREFIX + regionId);
        if (Strings.isNullOrEmpty((String)json)) {
            return Collections.emptyList();
        }
        return (Collection)GSON.fromJson(json, new TypeToken<List<TilePoint>>(){}.getType());
    }

    private void loadPoints() {
        this.points.clear();
        int[] regions = this.client.getMapRegions();
        if (regions == null) {
            return;
        }
        for (int regionId : regions) {
            Collection<TilePoint> regionPoints = this.getPoints(regionId);
            Collection<ColorTileMarker> colorTileMarkers = this.translateToColorTileMarker(regionPoints);
            this.points.addAll(colorTileMarkers);
        }
    }

    private Collection<ColorTileMarker> translateToColorTileMarker(Collection<TilePoint> points) {
        if (points.isEmpty()) {
            return Collections.emptyList();
        }
        return points.stream().map(point -> new ColorTileMarker(WorldPoint.fromRegion((int)point.getRegionId(), (int)point.getRegionX(), (int)point.getRegionY(), (int)point.getZ()), point.getColor(), point.getLabel())).flatMap(colorTile -> {
            Collection localWorldPoints = WorldPoint.toLocalInstance((Client)this.client, (WorldPoint)colorTile.getWorldPoint());
            return localWorldPoints.stream().map(wp -> new ColorTileMarker((WorldPoint)wp, colorTile.getColor(), colorTile.getLabel()));
        }).collect(Collectors.toList());
    }

    private void markTile(LocalPoint localPoint, String label) {
        if (localPoint == null) {
            return;
        }
        WorldPoint worldPoint = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)localPoint);
        int regionId = worldPoint.getRegionID();
        TilePoint point = new TilePoint(regionId, worldPoint.getRegionX(), worldPoint.getRegionY(), this.client.getPlane(), DEFAULT_COLOR, label);
        log.debug("Updating point: {} - {}", (Object)point, (Object)worldPoint);
        ArrayList<TilePoint> groundMarkerPoints = new ArrayList<TilePoint>(this.getPoints(regionId));
        if (!groundMarkerPoints.contains(point)) {
            groundMarkerPoints.add(point);
        }
        this.savePoints(regionId, groundMarkerPoints);
        this.loadPoints();
    }

    List<ColorTileMarker> getPoints() {
        return this.points;
    }

    static {
        GSON = new Gson();
        DEFAULT_COLOR = new Color(255, 108, 0);
        EVENT_NPCS = ImmutableSet.of((Object)6747, (Object)5426, (Object)307, (Object)314, (Object)322, (Object)6749, (Object[])new Integer[]{390, 6754, 6744, 6748, 5429, 326, 327, 5438, 5441, 6746, 5437, 5440, 6750, 6751, 6752, 6753, 5436, 5439, 380, 6738, 6755, 375, 376, 5510, 6743});
    }
}

