/*
 * Decompiled with CFR 0.152.
 */
package com.spawnmarker;

import com.google.common.base.Strings;
import com.spawnmarker.ColorTileMarker;
import com.spawnmarker.SpawnMarkerPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.OverlayUtil;

public class SpawnMarkerOverlay
extends Overlay {
    private static final int MAX_DRAW_DISTANCE = 32;
    private final Client client;
    private final SpawnMarkerPlugin plugin;

    @Inject
    private SpawnMarkerOverlay(Client client, SpawnMarkerPlugin plugin) {
        this.plugin = plugin;
        this.client = client;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.setPriority(OverlayPriority.LOW);
    }

    public Dimension render(Graphics2D graphics) {
        List<ColorTileMarker> points = this.plugin.getPoints();
        for (ColorTileMarker point : points) {
            WorldPoint worldPoint = point.getWorldPoint();
            if (worldPoint.getPlane() != this.client.getPlane()) continue;
            Color tileColor = point.getColor();
            this.drawTile(graphics, worldPoint, tileColor, point.getLabel());
        }
        return null;
    }

    private void drawTile(Graphics2D graphics, WorldPoint point, Color color, @Nullable String label) {
        Point canvasTextLocation;
        WorldPoint playerLocation = this.client.getLocalPlayer().getWorldLocation();
        if (point.distanceTo(playerLocation) >= 32) {
            return;
        }
        LocalPoint lp = LocalPoint.fromWorld((Client)this.client, (WorldPoint)point);
        if (lp == null) {
            return;
        }
        Polygon poly = Perspective.getCanvasTilePoly((Client)this.client, (LocalPoint)lp);
        if (poly != null) {
            OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)poly, (Color)color);
        }
        if (!Strings.isNullOrEmpty((String)label) && (canvasTextLocation = Perspective.getCanvasTextLocation((Client)this.client, (Graphics2D)graphics, (LocalPoint)lp, (String)label, (int)0)) != null) {
            OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)canvasTextLocation, (String)label, (Color)color);
        }
    }
}

