/*
 * Decompiled with CFR 0.152.
 */
package no.elg.ii.inventory;

import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import javax.inject.Inject;
import lombok.Generated;
import net.runelite.api.Client;
import no.elg.ii.InstantInventoryConfig;
import no.elg.ii.inventory.slot.InventorySlot;
import no.elg.ii.inventory.slot.InventorySlotState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InventoryState {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InventoryState.class);
    public static final int DEFAULT_MAX_UNMODIFIED_TICKS = 1;
    private final InventorySlot[] slots = new InventorySlot[28];
    @Inject
    @VisibleForTesting
    InstantInventoryConfig config;
    @Inject
    @VisibleForTesting
    Client client;

    public void setItemId(int index, int itemId) {
        log.debug("Setting index {} to {}", (Object)index, (Object)itemId);
        this.slots[index] = new InventorySlotState(this.client.getTickCount(), itemId);
    }

    public void setSlot(int index, InventorySlot slot) {
        log.debug("Setting index {} to {}", (Object)index, (Object)slot);
        this.slots[index] = slot;
    }

    public InventorySlot getSlot(int index) {
        return this.slots[index];
    }

    public void resetAll() {
        Arrays.fill(this.slots, InventorySlot.RESET_SLOT);
    }

    public void resetState(int index) {
        this.slots[index] = InventorySlot.RESET_SLOT;
    }

    public void validateState(int index, int actualItemId) {
        InventorySlot slot = this.getSlot(index);
        if (slot == InventorySlot.UNMODIFIED_SLOT || slot == InventorySlot.RESET_SLOT) {
            return;
        }
        int itemId = slot.getItemId();
        int modifiedTick = slot.getChangedTick();
        if (slot.hasValidItemId() && itemId != actualItemId) {
            log.debug("Item at index {} changed from item id {} to {}, resetting the item", new Object[]{index, itemId, actualItemId});
            this.resetState(index);
            return;
        }
        int ticksSinceModified = this.client.getTickCount() - modifiedTick;
        if (slot.hasChangedTick() && ticksSinceModified >= this.config.maxUnmodifiedTicks()) {
            log.debug("Item at index {} has not changed in {} tick, resetting the item", (Object)index, (Object)ticksSinceModified);
            this.resetState(index);
        }
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InventoryState)) {
            return false;
        }
        InventoryState other = (InventoryState)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.deepEquals(this.slots, other.slots)) {
            return false;
        }
        InstantInventoryConfig this$config = this.config;
        InstantInventoryConfig other$config = other.config;
        if (this$config == null ? other$config != null : !this$config.equals(other$config)) {
            return false;
        }
        Client this$client = this.client;
        Client other$client = other.client;
        return !(this$client == null ? other$client != null : !this$client.equals(other$client));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InventoryState;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.slots);
        InstantInventoryConfig $config = this.config;
        result = result * 59 + ($config == null ? 43 : $config.hashCode());
        Client $client = this.client;
        result = result * 59 + ($client == null ? 43 : $client.hashCode());
        return result;
    }

    @Generated
    public InventoryState(InstantInventoryConfig config, Client client) {
        Arrays.fill(this.slots, InventorySlot.UNMODIFIED_SLOT);
        this.config = config;
        this.client = client;
    }

    @Generated
    public InventoryState() {
        Arrays.fill(this.slots, InventorySlot.UNMODIFIED_SLOT);
    }
}

