/*
 * Decompiled with CFR 0.152.
 */
package no.elg.ii.feature.hide;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Streams;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import lombok.Generated;
import net.runelite.api.events.BeforeRender;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.eventbus.Subscribe;
import no.elg.ii.InstantInventoryPlugin;
import no.elg.ii.feature.Feature;
import no.elg.ii.inventory.InventoryState;
import no.elg.ii.inventory.slot.InventorySlot;
import no.elg.ii.util.IndexedWidget;
import no.elg.ii.util.WidgetUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HideFeature
implements Feature {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HideFeature.class);
    private final Set<WidgetInfo> widgets = new HashSet<WidgetInfo>();
    @Inject
    public InstantInventoryPlugin plugin;
    @Inject
    public ClientThread clientThread;
    @Inject
    private InventoryState state;

    protected void hide(Widget widget) {
        widget.setHidden(true);
        this.getState().setItemId(widget.getIndex(), widget.getItemId());
    }

    private void show(Widget widget) {
        widget.setHidden(false);
        this.getState().setSlot(widget.getIndex(), InventorySlot.UNMODIFIED_SLOT);
    }

    @Subscribe
    public void onBeforeRender(BeforeRender beforeRender) {
        this.updateHiddenStatus();
    }

    @Override
    public void reset() {
        Feature.super.reset();
        this.clientThread.invoke(this::updateHiddenStatus);
    }

    @VisibleForTesting
    public void updateHiddenStatus() {
        for (IndexedWidget indexedWidget : this.inventoryItems()) {
            Widget widget = indexedWidget.getWidget();
            int index = indexedWidget.getIndex();
            InventorySlot slot = this.getState().getSlot(index);
            if (slot == InventorySlot.RESET_SLOT) {
                log.debug("Slot is reset item, will reset | {}", (Object)WidgetUtil.getWidgetInfo(widget));
                this.show(widget);
                continue;
            }
            if (slot == InventorySlot.UNMODIFIED_SLOT || widget.isHidden()) continue;
            log.debug("Slot was not hidden, hiding it now | {}", (Object)WidgetUtil.getWidgetInfo(widget));
            widget.setHidden(true);
        }
    }

    protected Set<IndexedWidget> inventoryItems() {
        if (this.widgets.isEmpty()) {
            log.error("No widget added to hide feature " + this.getClass().getName());
            return Collections.emptySet();
        }
        return this.widgets.stream().map(it -> this.plugin.inventoryItems((WidgetInfo)it)).flatMap(ws -> Streams.mapWithIndex(Arrays.stream(ws), (from, index) -> new IndexedWidget((int)index, (Widget)from))).collect(Collectors.toSet());
    }

    @Override
    @Nonnull
    public InventoryState getState() {
        return this.state;
    }

    public void showOnWidgets(WidgetInfo widget) {
        this.widgets.add(widget);
    }

    public void showOnWidgets(WidgetInfo ... widgets) {
        this.widgets.addAll(Arrays.asList(widgets));
    }

    @VisibleForTesting
    public Set<WidgetInfo> getWidgets() {
        return this.widgets;
    }
}

