/*
 * Decompiled with CFR 0.152.
 */
package no.elg.ii.feature.hide;

import java.util.Set;
import javax.annotation.Nonnull;
import javax.inject.Singleton;
import lombok.Generated;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.eventbus.Subscribe;
import no.elg.ii.feature.hide.HideFeature;
import no.elg.ii.util.IndexedWidget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DepositFeature
extends HideFeature {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DepositFeature.class);
    public static final String DEPOSIT_PREFIX_OPTION = "Deposit-";
    public static final String DEPOSIT_CONFIG_KEY = "instantDeposit";

    public DepositFeature() {
        this.showOnWidgets(WidgetInfo.BANK_INVENTORY_ITEMS_CONTAINER);
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        Widget widget = event.getWidget();
        if (widget != null) {
            String menuOption = event.getMenuOption();
            int eventItemId = event.getItemId();
            if (menuOption != null && menuOption.startsWith(DEPOSIT_PREFIX_OPTION)) {
                int toTake;
                String substring = menuOption.substring(DEPOSIT_PREFIX_OPTION.length());
                try {
                    toTake = Integer.parseInt(substring);
                }
                catch (NumberFormatException e) {
                    log.debug("Failed to parse how many to deposit: " + menuOption + " | tried to parse this as int: " + substring);
                    return;
                }
                if (toTake >= widget.getItemQuantity()) {
                    log.debug("Hiding " + toTake + " items");
                    Set<IndexedWidget> indexedWidgets = this.inventoryItems();
                    indexedWidgets.stream().filter(it -> it.getWidget().getItemId() == eventItemId).sorted().limit(toTake).forEach(indexedWidget -> this.hide(indexedWidget.getWidget()));
                } else {
                    int quantity = widget.getItemQuantity() - toTake;
                    log.debug("Updating item quantity from " + widget.getItemQuantity() + " be " + quantity);
                    widget.setItemQuantity(quantity);
                }
            }
        }
    }

    @Override
    @Nonnull
    public String getConfigKey() {
        return DEPOSIT_CONFIG_KEY;
    }
}

