/*
 * Decompiled with CFR 0.152.
 */
package no.elg.ii.feature.clean;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.widgets.WidgetItem;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.overlay.WidgetItemOverlay;
import net.runelite.client.util.AsyncBufferedImage;
import no.elg.ii.feature.clean.CleanHerbFeature;
import no.elg.ii.feature.clean.HerbInfo;
import no.elg.ii.inventory.slot.InventorySlot;
import no.elg.ii.util.InventoryUtil;

@Singleton
public class CleanHerbOverlay
extends WidgetItemOverlay {
    @Inject
    @VisibleForTesting
    ItemManager itemManager;
    @Inject
    @VisibleForTesting
    CleanHerbFeature clean;
    @VisibleForTesting
    Cache<Long, Image> fillCache;

    public CleanHerbOverlay() {
        this.showOnBank();
        this.showOnInventory();
        this.fillCache = CacheBuilder.newBuilder().concurrencyLevel(1).maximumSize(32L).build();
    }

    public void renderItemOverlay(Graphics2D graphics, int itemId, WidgetItem widgetItem) {
        int index = widgetItem.getWidget().getIndex();
        if (InventoryUtil.isInvalidInventoryIndex(index)) {
            return;
        }
        InventorySlot slot = this.clean.getState().getSlot(index);
        if (!slot.hasValidItemId()) {
            return;
        }
        Rectangle bounds = widgetItem.getCanvasBounds();
        HerbInfo cleanItemId = HerbInfo.HERBS.getOrDefault(itemId, null);
        if (cleanItemId == null) {
            return;
        }
        AsyncBufferedImage item = this.itemManager.getImage(cleanItemId.getCleanItemId(), widgetItem.getQuantity(), false);
        graphics.drawImage((Image)item, (int)bounds.getX(), (int)bounds.getY(), null);
    }

    public void invalidateCache() {
        this.fillCache.invalidateAll();
    }
}

