/*
 * Decompiled with CFR 0.152.
 */
package no.elg.ii.feature.clean;

import com.google.common.annotations.VisibleForTesting;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.Skill;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.widgets.Widget;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import no.elg.ii.feature.Feature;
import no.elg.ii.feature.clean.CleanHerbOverlay;
import no.elg.ii.feature.clean.HerbInfo;
import no.elg.ii.inventory.InventoryState;

@Singleton
public class CleanHerbFeature
implements Feature {
    public static final String CLEAN_OPTION = "Clean";
    public static final String CLEAN_CONFIG_KEY = "instantClean";
    @Inject
    @VisibleForTesting
    public CleanHerbOverlay overlay;
    @Inject
    @VisibleForTesting
    public OverlayManager overlayManager;
    @Inject
    @VisibleForTesting
    public Client client;
    @Inject
    private InventoryState state;

    @Override
    public void onEnable() {
        this.overlayManager.add((Overlay)this.overlay);
    }

    @Override
    public void onDisable() {
        this.overlayManager.remove((Overlay)this.overlay);
    }

    @Override
    public void reset() {
        Feature.super.reset();
        this.overlay.invalidateCache();
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        String menuOption;
        Widget widget = event.getWidget();
        if (widget != null && CLEAN_OPTION.equals(menuOption = event.getMenuOption())) {
            int itemId = event.getItemId();
            HerbInfo herbInfo = HerbInfo.HERBS.get(itemId);
            if (herbInfo == null) {
                return;
            }
            int herbloreLevel = this.client.getBoostedSkillLevel(Skill.HERBLORE);
            if (herbloreLevel >= herbInfo.getMinLevel()) {
                this.getState().setItemId(widget.getIndex(), itemId);
            }
        }
    }

    @Override
    @Nonnull
    public InventoryState getState() {
        return this.state;
    }

    @Override
    @Nonnull
    public String getConfigKey() {
        return CLEAN_CONFIG_KEY;
    }
}

