/*
 * Decompiled with CFR 0.152.
 */
package no.elg.ii;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Provides;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import lombok.Generated;
import net.runelite.api.Client;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import no.elg.ii.FeatureManager;
import no.elg.ii.InstantInventoryConfig;
import no.elg.ii.feature.Feature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Instant Inventory")
public class InstantInventoryPlugin
extends Plugin {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InstantInventoryPlugin.class);
    public static final Widget[] EMPTY_WIDGET = new Widget[0];
    @Inject
    @VisibleForTesting
    protected Client client;
    @Inject
    @VisibleForTesting
    protected EventBus eventBus;
    @Inject
    @VisibleForTesting
    protected InstantInventoryConfig config;
    @Inject
    @VisibleForTesting
    protected FeatureManager featureManager;

    protected void startUp() {
        this.featureManager.updateAllFeatureStatus();
    }

    protected void shutDown() {
        this.featureManager.disableAllFeatures();
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        Widget[] inventoryWidgets = this.inventoryItems(WidgetInfo.INVENTORY);
        Set<Feature> activeFeatures = this.featureManager.getActiveFeatures();
        for (int index = 0; index < inventoryWidgets.length; ++index) {
            int actualItemId = inventoryWidgets[index].getItemId();
            for (Feature feature : activeFeatures) {
                feature.getState().validateState(index, actualItemId);
            }
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        log.debug("Resetting features as the GameState changed to {}", (Object)event.getGameState());
        Set<Feature> activeFeatures = this.featureManager.getActiveFeatures();
        for (Feature feature : activeFeatures) {
            feature.reset();
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if ("instant-inventory".equals(configChanged.getGroup())) {
            this.featureManager.updateAllFeatureStatus();
        }
    }

    @Nonnull
    public Widget[] inventoryItems(WidgetInfo widgetInfo) {
        Widget widget = this.client.getWidget(widgetInfo);
        if (widget != null) {
            return widget.getDynamicChildren();
        }
        return EMPTY_WIDGET;
    }

    @Provides
    InstantInventoryConfig provideConfig(ConfigManager configManager) {
        return (InstantInventoryConfig)configManager.getConfig(InstantInventoryConfig.class);
    }

    @Generated
    public InstantInventoryPlugin(Client client, EventBus eventBus, InstantInventoryConfig config, FeatureManager featureManager) {
        this.client = client;
        this.eventBus = eventBus;
        this.config = config;
        this.featureManager = featureManager;
    }

    @Generated
    public InstantInventoryPlugin() {
    }
}

