/*
 * Decompiled with CFR 0.152.
 */
package no.elg.ii;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import lombok.Generated;
import net.runelite.client.eventbus.EventBus;
import no.elg.ii.Features;
import no.elg.ii.InstantInventoryConfig;
import no.elg.ii.feature.Feature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FeatureManager.class);
    @VisibleForTesting
    protected final Set<Feature> featureSet = ConcurrentHashMap.newKeySet();
    private final Set<Feature> featureSetView = Collections.unmodifiableSet(this.featureSet);
    @Inject
    @VisibleForTesting
    protected EventBus eventBus;
    @Inject
    @VisibleForTesting
    protected InstantInventoryConfig config;
    @Inject
    protected Features featureInstances;

    @VisibleForTesting
    protected void updateAllFeatureStatus() {
        this.updateFeatureStatus(this.featureInstances.getDropFeature(), this.config.instantDrop());
        this.updateFeatureStatus(this.featureInstances.getCleanHerbFeature(), this.config.instantClean());
        this.updateFeatureStatus(this.featureInstances.getDepositFeature(), this.config.instantDeposit());
    }

    public void disableAllFeatures() {
        HashSet<Feature> copy = new HashSet<Feature>(this.featureSet);
        for (Feature feature : copy) {
            this.disableFeature(feature);
        }
    }

    public Set<Feature> getActiveFeatures() {
        return this.featureSetView;
    }

    @VisibleForTesting
    void updateFeatureStatus(@Nonnull Feature feature, boolean isEnabledInConfig) {
        boolean wasEnabled = this.featureSet.contains(feature);
        if (!wasEnabled && isEnabledInConfig) {
            this.enableFeature(feature);
        } else if (wasEnabled && !isEnabledInConfig) {
            this.disableFeature(feature);
        }
    }

    @VisibleForTesting
    void enableFeature(@Nonnull Feature feature) {
        log.debug("Enabling " + feature.getConfigKey());
        this.eventBus.register((Object)feature);
        this.featureSet.add(feature);
        feature.onEnable();
        feature.reset();
    }

    @VisibleForTesting
    void disableFeature(@Nonnull Feature feature) {
        log.debug("Disabling " + feature.getConfigKey());
        this.eventBus.unregister((Object)feature);
        this.featureSet.remove(feature);
        feature.onDisable();
        feature.reset();
    }

    @Generated
    public Set<Feature> getFeatureSet() {
        return this.featureSet;
    }

    @Generated
    public Set<Feature> getFeatureSetView() {
        return this.featureSetView;
    }

    @Generated
    public EventBus getEventBus() {
        return this.eventBus;
    }

    @Generated
    public InstantInventoryConfig getConfig() {
        return this.config;
    }

    @Generated
    public Features getFeatureInstances() {
        return this.featureInstances;
    }

    @Generated
    public void setEventBus(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    @Generated
    public void setConfig(InstantInventoryConfig config) {
        this.config = config;
    }

    @Generated
    public void setFeatureInstances(Features featureInstances) {
        this.featureInstances = featureInstances;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FeatureManager)) {
            return false;
        }
        FeatureManager other = (FeatureManager)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Set<Feature> this$featureSet = this.getFeatureSet();
        Set<Feature> other$featureSet = other.getFeatureSet();
        if (this$featureSet == null ? other$featureSet != null : !((Object)this$featureSet).equals(other$featureSet)) {
            return false;
        }
        Set<Feature> this$featureSetView = this.getFeatureSetView();
        Set<Feature> other$featureSetView = other.getFeatureSetView();
        if (this$featureSetView == null ? other$featureSetView != null : !((Object)this$featureSetView).equals(other$featureSetView)) {
            return false;
        }
        EventBus this$eventBus = this.getEventBus();
        EventBus other$eventBus = other.getEventBus();
        if (this$eventBus == null ? other$eventBus != null : !this$eventBus.equals(other$eventBus)) {
            return false;
        }
        InstantInventoryConfig this$config = this.getConfig();
        InstantInventoryConfig other$config = other.getConfig();
        if (this$config == null ? other$config != null : !this$config.equals(other$config)) {
            return false;
        }
        Features this$featureInstances = this.getFeatureInstances();
        Features other$featureInstances = other.getFeatureInstances();
        return !(this$featureInstances == null ? other$featureInstances != null : !((Object)this$featureInstances).equals(other$featureInstances));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FeatureManager;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<Feature> $featureSet = this.getFeatureSet();
        result = result * 59 + ($featureSet == null ? 43 : ((Object)$featureSet).hashCode());
        Set<Feature> $featureSetView = this.getFeatureSetView();
        result = result * 59 + ($featureSetView == null ? 43 : ((Object)$featureSetView).hashCode());
        EventBus $eventBus = this.getEventBus();
        result = result * 59 + ($eventBus == null ? 43 : $eventBus.hashCode());
        InstantInventoryConfig $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : $config.hashCode());
        Features $featureInstances = this.getFeatureInstances();
        result = result * 59 + ($featureInstances == null ? 43 : ((Object)$featureInstances).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FeatureManager(featureSet=" + this.getFeatureSet() + ", featureSetView=" + this.getFeatureSetView() + ", eventBus=" + this.getEventBus() + ", config=" + this.getConfig() + ", featureInstances=" + this.getFeatureInstances() + ")";
    }

    @Generated
    public FeatureManager() {
    }

    @Generated
    public FeatureManager(EventBus eventBus, InstantInventoryConfig config, Features featureInstances) {
        this.eventBus = eventBus;
        this.config = config;
        this.featureInstances = featureInstances;
    }
}

