/*
 * Decompiled with CFR 0.152.
 */
package com.camerapoints.ui;

import com.camerapoints.CameraPointsPlugin;
import com.camerapoints.ui.CameraPointPanel;
import com.camerapoints.utility.CameraPoint;
import com.camerapoints.utility.Helper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.components.PluginErrorPanel;
import net.runelite.client.util.ImageUtil;

public class CameraPointsPluginPanel
extends PluginPanel {
    private static final ImageIcon ADD_ICON;
    private static final ImageIcon ADD_HOVER_ICON;
    private static final ImageIcon ADD_PRESSED_ICON;
    private final JLabel title = new JLabel();
    private final PluginErrorPanel noPointsPanel = new PluginErrorPanel();
    private final JPanel pointsView = new JPanel(new GridBagLayout());
    private final CameraPointsPlugin plugin;

    public CameraPointsPluginPanel(CameraPointsPlugin plugin) {
        this.plugin = plugin;
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.setBorder(new EmptyBorder(1, 0, 10, 0));
        this.title.setText("Camera Points");
        this.title.setForeground(Color.WHITE);
        final JLabel addPoint = new JLabel(ADD_ICON);
        northPanel.add((Component)this.title, "West");
        northPanel.add((Component)addPoint, "East");
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.setBackground(Helper.BACKGROUND_COLOR);
        this.pointsView.setBackground(Helper.BACKGROUND_COLOR);
        this.noPointsPanel.setContent("Camera Points", "Save and load camera points.");
        addPoint.setToolTipText("Add new camera point");
        addPoint.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (Helper.checkClick(mouseEvent)) {
                    return;
                }
                addPoint.setIcon(ADD_PRESSED_ICON);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (Helper.checkClick(mouseEvent)) {
                    return;
                }
                CameraPointsPluginPanel.this.create();
                addPoint.setIcon(ADD_HOVER_ICON);
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                addPoint.setIcon(ADD_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                addPoint.setIcon(ADD_ICON);
            }
        });
        centerPanel.add((Component)this.pointsView, "Center");
        this.add(northPanel, "North");
        this.add(centerPanel, "Center");
        this.rebuild();
    }

    public void rebuild() {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.gridy = 0;
        this.pointsView.removeAll();
        if (this.plugin.getCameraPoints().isEmpty()) {
            this.title.setVisible(false);
            this.pointsView.add((Component)this.noPointsPanel, constraints);
        } else {
            this.title.setVisible(true);
            for (CameraPoint point : this.plugin.getCameraPoints()) {
                this.pointsView.add((Component)new CameraPointPanel(this.plugin, point), constraints);
                ++constraints.gridy;
                this.pointsView.add(Box.createRigidArea(new Dimension(0, 10)), constraints);
                ++constraints.gridy;
            }
        }
        this.repaint();
        this.revalidate();
    }

    private void create() {
        this.plugin.addCameraPoint();
        this.rebuild();
    }

    static {
        BufferedImage addIcon = ImageUtil.loadImageResource(CameraPointsPlugin.class, (String)"add_icon.png");
        ADD_ICON = new ImageIcon(addIcon);
        ADD_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)addIcon, (int)-100));
        ADD_PRESSED_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)addIcon, (int)-50));
    }
}

