/*
 * Decompiled with CFR 0.152.
 */
package com.camerapoints.ui;

import com.camerapoints.CameraPointsPlugin;
import com.camerapoints.utility.CameraPoint;
import com.camerapoints.utility.Direction;
import com.camerapoints.utility.Helper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import net.runelite.client.config.Keybind;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.components.FlatTextField;
import net.runelite.client.util.ImageUtil;

class CameraPointPanel
extends JPanel {
    private static final int ZOOM_LIMIT_MIN = -272;
    private static final int ZOOM_LIMIT_MAX = 1400;
    private static final ImageIcon FROM_GAME_ICON = new ImageIcon(ImageUtil.loadImageResource(CameraPointsPlugin.class, (String)"from_game_icon.png"));
    private static final ImageIcon FROM_GAME_HOVER_ICON;
    private static final ImageIcon FROM_GAME_PRESSED_ICON;
    private static final ImageIcon LOAD_POINT_ICON;
    private static final ImageIcon LOAD_POINT_HOVER_ICON;
    private static final ImageIcon LOAD_POINT_PRESSED_ICON;
    private static final ImageIcon DELETE_ICON;
    private static final ImageIcon DELETE_HOVER_ICON;
    private static final ImageIcon DELETE_PRESSED_ICON;
    private final CameraPointsPlugin plugin;
    private final CameraPoint point;
    private final FlatTextField nameInput = new FlatTextField();
    private final JLabel saveLabel = new JLabel("Save");
    private final JLabel cancelLabel = new JLabel("Cancel");
    private final JLabel renameLabel = new JLabel("Rename");

    CameraPointPanel(final CameraPointsPlugin plugin, final CameraPoint point) {
        this.plugin = plugin;
        this.point = point;
        this.setLayout(new BorderLayout());
        this.setBackground(Helper.CONTENT_COLOR);
        JPanel nameWrapper = new JPanel(new BorderLayout());
        nameWrapper.setBackground(Helper.CONTENT_COLOR);
        nameWrapper.setBorder(new CompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Helper.BACKGROUND_COLOR), BorderFactory.createLineBorder(Helper.CONTENT_COLOR)));
        JPanel nameActions = new JPanel(new BorderLayout(4, 0));
        nameActions.setBorder(new EmptyBorder(0, 4, 0, 8));
        nameActions.setBackground(Helper.CONTENT_COLOR);
        this.saveLabel.setVisible(false);
        this.saveLabel.setFont(FontManager.getRunescapeSmallFont());
        this.saveLabel.setForeground(ColorScheme.PROGRESS_COMPLETE_COLOR);
        this.saveLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (Helper.checkClick(mouseEvent)) {
                    return;
                }
                CameraPointPanel.this.saveLabel.setForeground(ColorScheme.PROGRESS_COMPLETE_COLOR.brighter());
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (Helper.checkClick(mouseEvent)) {
                    return;
                }
                CameraPointPanel.this.save();
                CameraPointPanel.this.saveLabel.setForeground(ColorScheme.PROGRESS_COMPLETE_COLOR.darker());
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                CameraPointPanel.this.saveLabel.setForeground(ColorScheme.PROGRESS_COMPLETE_COLOR.darker());
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                CameraPointPanel.this.saveLabel.setForeground(ColorScheme.PROGRESS_COMPLETE_COLOR);
            }
        });
        this.cancelLabel.setVisible(false);
        this.cancelLabel.setFont(FontManager.getRunescapeSmallFont());
        this.cancelLabel.setForeground(ColorScheme.PROGRESS_ERROR_COLOR);
        this.cancelLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (Helper.checkClick(mouseEvent)) {
                    return;
                }
                CameraPointPanel.this.cancelLabel.setForeground(ColorScheme.PROGRESS_ERROR_COLOR.brighter());
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (Helper.checkClick(mouseEvent)) {
                    return;
                }
                CameraPointPanel.this.cancel();
                CameraPointPanel.this.cancelLabel.setForeground(ColorScheme.PROGRESS_ERROR_COLOR.darker());
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                CameraPointPanel.this.cancelLabel.setForeground(ColorScheme.PROGRESS_ERROR_COLOR.darker());
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                CameraPointPanel.this.cancelLabel.setForeground(ColorScheme.PROGRESS_ERROR_COLOR);
            }
        });
        this.renameLabel.setFont(FontManager.getRunescapeSmallFont());
        this.renameLabel.setForeground(ColorScheme.LIGHT_GRAY_COLOR.darker());
        this.renameLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (Helper.checkClick(mouseEvent)) {
                    return;
                }
                CameraPointPanel.this.renameLabel.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (Helper.checkClick(mouseEvent)) {
                    return;
                }
                CameraPointPanel.this.nameInput.setEditable(true);
                CameraPointPanel.this.updateNameActions(true);
                CameraPointPanel.this.renameLabel.setForeground(ColorScheme.LIGHT_GRAY_COLOR.darker().darker());
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                CameraPointPanel.this.renameLabel.setForeground(ColorScheme.LIGHT_GRAY_COLOR.darker().darker());
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                CameraPointPanel.this.renameLabel.setForeground(ColorScheme.LIGHT_GRAY_COLOR.darker());
            }
        });
        nameActions.add((Component)this.saveLabel, "East");
        nameActions.add((Component)this.cancelLabel, "West");
        nameActions.add((Component)this.renameLabel, "Center");
        this.nameInput.setText(point.getName());
        this.nameInput.setBorder(null);
        this.nameInput.setEditable(false);
        this.nameInput.setBackground(Helper.CONTENT_COLOR);
        this.nameInput.setPreferredSize(new Dimension(0, 24));
        this.nameInput.getTextField().setForeground(Color.WHITE);
        this.nameInput.getTextField().setBorder(new EmptyBorder(0, 8, 0, 0));
        this.nameInput.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    CameraPointPanel.this.save();
                } else if (e.getKeyCode() == 27) {
                    CameraPointPanel.this.cancel();
                }
            }
        });
        this.nameInput.getTextField().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (Helper.checkClick(mouseEvent) || mouseEvent.getClickCount() < 2 || !CameraPointPanel.this.renameLabel.isVisible()) {
                    return;
                }
                CameraPointPanel.this.nameInput.setEditable(true);
                CameraPointPanel.this.updateNameActions(true);
            }
        });
        nameWrapper.add((Component)this.nameInput, "Center");
        nameWrapper.add((Component)nameActions, "East");
        JPanel bottomContainer = new JPanel(new BorderLayout());
        bottomContainer.setBorder(new EmptyBorder(8, 8, 8, 8));
        bottomContainer.setBackground(Helper.CONTENT_COLOR);
        JPanel controlPanel = new JPanel(new GridBagLayout());
        controlPanel.setBorder(new EmptyBorder(0, 0, 8, 0));
        controlPanel.setBackground(Helper.CONTENT_COLOR);
        GridBagConstraints directionConstraints = new GridBagConstraints();
        directionConstraints.fill = 2;
        directionConstraints.weightx = 0.6;
        GridBagConstraints zoomConstraints = new GridBagConstraints();
        zoomConstraints.fill = 2;
        zoomConstraints.weightx = 0.4;
        JComboBox<Direction> directionBox = new JComboBox<Direction>(Direction.values());
        directionBox.setToolTipText("Compass direction");
        directionBox.setSelectedIndex(point.getDirection().getValue());
        directionBox.setPreferredSize(new Dimension(0, 20));
        directionBox.addActionListener(e -> {
            point.setDirection((Direction)((Object)((Object)directionBox.getSelectedItem())));
            plugin.updateConfig();
        });
        final JSpinner zoomSpinner = new JSpinner(new SpinnerNumberModel(-272, -272, 1400, 1));
        zoomSpinner.setToolTipText("Zoom value");
        zoomSpinner.setValue(point.getZoom());
        zoomSpinner.setEnabled(point.isApplyZoom());
        zoomSpinner.addChangeListener(e -> {
            point.setZoom((Integer)zoomSpinner.getValue());
            plugin.updateConfig();
        });
        zoomSpinner.setPreferredSize(new Dimension(0, 20));
        controlPanel.add(directionBox, directionConstraints);
        controlPanel.add(Box.createRigidArea(new Dimension(8, 0)));
        controlPanel.add((Component)zoomSpinner, zoomConstraints);
        JPanel centerPanel = new JPanel(new BorderLayout(4, 0));
        centerPanel.setBackground(Helper.CONTENT_COLOR);
        centerPanel.setPreferredSize(new Dimension(0, 20));
        JPanel actionPanel = new JPanel(new GridBagLayout());
        actionPanel.setBackground(Helper.CONTENT_COLOR);
        GridBagConstraints applyZoomConstraints = new GridBagConstraints();
        applyZoomConstraints.fill = 2;
        applyZoomConstraints.weightx = 0.25;
        GridBagConstraints loadConstraints = new GridBagConstraints();
        loadConstraints.fill = 2;
        loadConstraints.weightx = 0.25;
        GridBagConstraints saveConstraints = new GridBagConstraints();
        saveConstraints.fill = 2;
        saveConstraints.weightx = 0.25;
        GridBagConstraints deleteConstraints = new GridBagConstraints();
        deleteConstraints.fill = 2;
        deleteConstraints.weightx = 0.25;
        final JButton hotkeyButton = new JButton();
        hotkeyButton.setToolTipText("Load point hotkey");
        hotkeyButton.setText(point.getKeybind().toString());
        hotkeyButton.setFont(FontManager.getDefaultFont().deriveFont(12.0f));
        hotkeyButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                hotkeyButton.setText(Keybind.NOT_SET.toString());
                point.setKeybind(Keybind.NOT_SET);
                plugin.updateConfig();
            }
        });
        hotkeyButton.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                Keybind hotkey = new Keybind(e);
                hotkeyButton.setText(hotkey.toString());
                point.setKeybind(hotkey);
                plugin.updateConfig();
            }
        });
        JCheckBox applyZoomCheck = new JCheckBox("", true);
        applyZoomCheck.setToolTipText("Apply zoom when loading");
        applyZoomCheck.setSelected(point.isApplyZoom());
        applyZoomCheck.addChangeListener(e -> {
            zoomSpinner.setEnabled(applyZoomCheck.isSelected());
            point.setApplyZoom(applyZoomCheck.isSelected());
            plugin.updateConfig();
        });
        final JLabel loadLabel = new JLabel();
        loadLabel.setIcon(LOAD_POINT_ICON);
        loadLabel.setToolTipText("Load this point");
        loadLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (Helper.checkClick(mouseEvent)) {
                    return;
                }
                loadLabel.setIcon(LOAD_POINT_PRESSED_ICON);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (Helper.checkClick(mouseEvent)) {
                    return;
                }
                plugin.setCamera(point);
                loadLabel.setIcon(LOAD_POINT_HOVER_ICON);
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                loadLabel.setIcon(LOAD_POINT_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                loadLabel.setIcon(LOAD_POINT_ICON);
            }
        });
        final JLabel fromGameLabel = new JLabel();
        fromGameLabel.setIcon(FROM_GAME_ICON);
        fromGameLabel.setToolTipText("Get current zoom value from game");
        fromGameLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (Helper.checkClick(mouseEvent)) {
                    return;
                }
                fromGameLabel.setIcon(FROM_GAME_PRESSED_ICON);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (Helper.checkClick(mouseEvent)) {
                    return;
                }
                int result = JOptionPane.showConfirmDialog(CameraPointPanel.this, "Are you sure you want override the current zoom value?", " Get current zoom value from game", 2);
                if (result == 0) {
                    plugin.updateValues(point);
                    zoomSpinner.setValue(point.getZoom());
                }
                fromGameLabel.setIcon(FROM_GAME_HOVER_ICON);
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                fromGameLabel.setIcon(FROM_GAME_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                fromGameLabel.setIcon(FROM_GAME_ICON);
            }
        });
        final JLabel deleteLabel = new JLabel();
        deleteLabel.setIcon(DELETE_ICON);
        deleteLabel.setToolTipText("Delete camera point");
        deleteLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (Helper.checkClick(mouseEvent)) {
                    return;
                }
                deleteLabel.setIcon(DELETE_PRESSED_ICON);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (Helper.checkClick(mouseEvent)) {
                    return;
                }
                int result = JOptionPane.showConfirmDialog(CameraPointPanel.this, "Are you sure you want to permanently delete this camera point?", " Delete camera point", 2);
                if (result == 0) {
                    plugin.removeCameraPoint(point);
                }
                deleteLabel.setIcon(DELETE_HOVER_ICON);
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                deleteLabel.setIcon(DELETE_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                deleteLabel.setIcon(DELETE_ICON);
            }
        });
        actionPanel.add((Component)applyZoomCheck, applyZoomConstraints);
        actionPanel.add((Component)loadLabel, loadConstraints);
        actionPanel.add((Component)fromGameLabel, saveConstraints);
        actionPanel.add((Component)deleteLabel, deleteConstraints);
        centerPanel.add((Component)hotkeyButton, "Center");
        centerPanel.add((Component)actionPanel, "East");
        bottomContainer.add((Component)controlPanel, "North");
        bottomContainer.add((Component)centerPanel, "Center");
        this.add((Component)nameWrapper, "North");
        this.add((Component)bottomContainer, "Center");
    }

    private void save() {
        this.nameInput.setEditable(false);
        this.point.setName(this.nameInput.getText());
        this.plugin.updateConfig();
        this.updateNameActions(false);
        this.requestFocusInWindow();
    }

    private void cancel() {
        this.nameInput.setEditable(false);
        this.nameInput.setText(this.point.getName());
        this.updateNameActions(false);
        this.requestFocusInWindow();
    }

    private void updateNameActions(boolean saveAndCancel) {
        this.saveLabel.setVisible(saveAndCancel);
        this.cancelLabel.setVisible(saveAndCancel);
        this.renameLabel.setVisible(!saveAndCancel);
        if (saveAndCancel) {
            this.nameInput.getTextField().requestFocusInWindow();
            this.nameInput.getTextField().selectAll();
        }
    }

    static {
        BufferedImage fromGameImg = ImageUtil.loadImageResource(CameraPointsPlugin.class, (String)"from_game_icon_blue.png");
        FROM_GAME_HOVER_ICON = new ImageIcon(fromGameImg);
        FROM_GAME_PRESSED_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)fromGameImg, (int)-50));
        LOAD_POINT_ICON = new ImageIcon(ImageUtil.loadImageResource(CameraPointsPlugin.class, (String)"load_point_icon.png"));
        BufferedImage loadPointImg = ImageUtil.loadImageResource(CameraPointsPlugin.class, (String)"load_point_icon_green.png");
        LOAD_POINT_HOVER_ICON = new ImageIcon(loadPointImg);
        LOAD_POINT_PRESSED_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)loadPointImg, (int)-50));
        DELETE_ICON = new ImageIcon(ImageUtil.loadImageResource(CameraPointsPlugin.class, (String)"delete_icon.png"));
        BufferedImage deleteImg = ImageUtil.loadImageResource(CameraPointsPlugin.class, (String)"delete_icon_red.png");
        DELETE_HOVER_ICON = new ImageIcon(deleteImg);
        DELETE_PRESSED_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)deleteImg, (int)-50));
    }
}

