/*
 * Decompiled with CFR 0.152.
 */
package com.camerapoints;

import com.camerapoints.CameraPointsConfig;
import com.camerapoints.ui.CameraPointsPluginPanel;
import com.camerapoints.utility.CameraPoint;
import com.camerapoints.utility.Direction;
import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Provides;
import java.awt.event.KeyEvent;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.config.Keybind;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;

@PluginDescriptor(name="Camera Points", description="Allows you to save and load your camera zoom and a compass direction", tags={"save", "load", "camera", "zoom", "compass", "direction", "hotkey"})
public class CameraPointsPlugin
extends Plugin
implements KeyListener {
    private static final int TOPLEVEL_COMPASS_OP_SCRIPT_ID = 1050;
    private static final String CONFIG_KEY = "points";
    @Inject
    private Gson gson;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private KeyManager keyManager;
    @Inject
    private ConfigManager configManager;
    @Inject
    public CameraPointsConfig config;
    private CameraPointsPluginPanel pluginPanel;
    private NavigationButton navigationButton;
    private final List<CameraPoint> cameraPoints = new ArrayList<CameraPoint>();
    private boolean typing;

    @Provides
    CameraPointsConfig getConfig(ConfigManager configManager) {
        return (CameraPointsConfig)configManager.getConfig(CameraPointsConfig.class);
    }

    protected void startUp() {
        this.setTyping(false);
        this.loadConfig(this.configManager.getConfiguration("camerapoints", CONFIG_KEY));
        this.keyManager.registerKeyListener((KeyListener)this);
        this.pluginPanel = new CameraPointsPluginPanel(this);
        this.navigationButton = NavigationButton.builder().tooltip("Camera Points").icon(ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"panel_icon.png")).priority(5).panel((PluginPanel)this.pluginPanel).build();
        this.clientToolbar.addNavigation(this.navigationButton);
    }

    protected void shutDown() {
        this.keyManager.unregisterKeyListener((KeyListener)this);
        this.cameraPoints.clear();
        this.clientToolbar.removeNavigation(this.navigationButton);
        this.pluginPanel = null;
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (this.cameraPoints.isEmpty() && event.getGroup().equals("camerapoints") && event.getKey().equals(CONFIG_KEY)) {
            this.loadConfig(this.configManager.getConfiguration("camerapoints", CONFIG_KEY));
        }
    }

    public void addCameraPoint() {
        this.cameraPoints.add(new CameraPoint(Instant.now().toEpochMilli(), "Camera Point " + (this.cameraPoints.size() + 1), Direction.NONE, true, this.getZoom(), Keybind.NOT_SET));
        this.updateConfig();
    }

    private int getZoom() {
        return this.client.getVarcIntValue(73);
    }

    public void removeCameraPoint(CameraPoint point) {
        this.cameraPoints.remove(point);
        this.pluginPanel.rebuild();
        this.updateConfig();
    }

    public void updateValues(CameraPoint point) {
        point.setZoom(this.getZoom());
        this.updateConfig();
    }

    public void updateConfig() {
        if (this.cameraPoints.isEmpty()) {
            this.configManager.unsetConfiguration("camerapoints", CONFIG_KEY);
            return;
        }
        this.configManager.setConfiguration("camerapoints", CONFIG_KEY, this.gson.toJson(this.cameraPoints));
    }

    private void loadConfig(String json) {
        if (Strings.isNullOrEmpty((String)json)) {
            return;
        }
        this.cameraPoints.addAll((Collection)this.gson.fromJson(json, new TypeToken<ArrayList<CameraPoint>>(){}.getType()));
    }

    public void setCamera(CameraPoint point) {
        this.clientThread.invoke(() -> {
            if (point.isApplyZoom()) {
                this.client.runScript(new Object[]{42, point.getZoom(), point.getZoom()});
            }
            if (point.getDirection() != Direction.NONE) {
                this.client.runScript(new Object[]{1050, point.getDirection().getValue()});
            }
        });
    }

    private boolean chatboxFocused() {
        Widget chatboxParent = this.client.getWidget(WidgetInfo.CHATBOX_PARENT);
        if (chatboxParent == null || chatboxParent.getOnKeyListener() == null) {
            return false;
        }
        Widget worldMapSearch = this.client.getWidget(WidgetInfo.WORLD_MAP_SEARCH);
        return worldMapSearch == null || this.client.getVarcIntValue(190) != 1;
    }

    private boolean isDialogOpen() {
        return this.isHidden(WidgetInfo.CHATBOX_MESSAGES) || this.isHidden(WidgetInfo.CHATBOX_TRANSPARENT_LINES) || !this.isHidden(WidgetInfo.BANK_PIN_CONTAINER);
    }

    private boolean isHidden(WidgetInfo widgetInfo) {
        Widget w = this.client.getWidget(widgetInfo);
        return w == null || w.isSelfHidden();
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        if (!this.isTyping() && !this.isDialogOpen() || !this.config.disableWhileTyping()) {
            for (CameraPoint point : this.cameraPoints) {
                if (!point.getKeybind().matches(e)) continue;
                this.setCamera(point);
                return;
            }
        }
        if (!this.chatboxFocused()) {
            return;
        }
        if (this.isTyping()) {
            switch (e.getKeyCode()) {
                case 10: 
                case 27: {
                    this.setTyping(false);
                    break;
                }
                case 8: {
                    if (!Strings.isNullOrEmpty((String)this.client.getVarcStrValue(335))) break;
                    this.setTyping(false);
                }
            }
        } else {
            switch (e.getKeyCode()) {
                case 10: 
                case 47: 
                case 513: {
                    this.setTyping(true);
                }
            }
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public List<CameraPoint> getCameraPoints() {
        return this.cameraPoints;
    }

    boolean isTyping() {
        return this.typing;
    }

    void setTyping(boolean typing) {
        this.typing = typing;
    }
}

