/*
 * Decompiled with CFR 0.152.
 */
package universalDiscord;

import com.google.inject.Provides;
import java.util.Collection;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.NPC;
import net.runelite.api.events.ActorDeath;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.StatChanged;
import net.runelite.api.events.UsernameChanged;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.NotificationFired;
import net.runelite.client.events.NpcLootReceived;
import net.runelite.client.events.PlayerLootReceived;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.loottracker.LootReceived;
import net.runelite.client.ui.DrawManager;
import net.runelite.client.util.Text;
import net.runelite.http.api.loottracker.LootRecordType;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import universalDiscord.ClueNotifier;
import universalDiscord.CollectionNotifier;
import universalDiscord.DeathNotifier;
import universalDiscord.DiscordMessageHandler;
import universalDiscord.LevelNotifier;
import universalDiscord.LootNotifier;
import universalDiscord.PetNotifier;
import universalDiscord.QuestNotifier;
import universalDiscord.SlayerNotifier;
import universalDiscord.UniversalDiscordConfig;
import universalDiscord.Utils;

@PluginDescriptor(name="Universal Discord")
public class UniversalDiscordPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(UniversalDiscordPlugin.class);
    @Inject
    private Client client;
    @Inject
    public OkHttpClient httpClient;
    @Inject
    public DrawManager drawManager;
    @Inject
    public UniversalDiscordConfig config;
    @Inject
    public ItemManager itemManager;
    public final DiscordMessageHandler messageHandler = new DiscordMessageHandler(this);
    private final CollectionNotifier collectionNotifier = new CollectionNotifier(this);
    private final PetNotifier petNotifier = new PetNotifier(this);
    private final LevelNotifier levelNotifier = new LevelNotifier(this);
    private final LootNotifier lootNotifier = new LootNotifier(this);
    private final DeathNotifier deathNotifier = new DeathNotifier(this);
    private final SlayerNotifier slayerNotifier = new SlayerNotifier(this);
    private final QuestNotifier questNotifier = new QuestNotifier(this);
    private final ClueNotifier clueNotifier = new ClueNotifier(this);
    private static final Pattern CLUE_SCROLL_REGEX = Pattern.compile("You have completed (?<scrollCount>\\d+) (?<scrollType>\\w+) Treasure Trails\\.");
    private static final Pattern SLAYER_TASK_REGEX = Pattern.compile("You have completed your task! You killed (?<task>[\\d,]+ [\\w,]+)\\..*");
    private static final Pattern SLAYER_COMPLETE_REGEX = Pattern.compile("You've completed (?:at least )?(?<taskCount>[\\d,]+) (?:Wilderness )?tasks?(?: and received \\d+ points, giving you a total of (?<points>[\\d,]+)|\\.You'll be eligible to earn reward points if you complete tasks from a more advanced Slayer Master\\.| and reached the maximum amount of Slayer points \\((?<points2>[\\d,]+)\\))?");
    private static final Pattern COLLECTION_LOG_REGEX = Pattern.compile("New item added to your collection log: (?<itemName>[\\w,\\s-.]+)");
    private static final Pattern PET_REGEX = Pattern.compile("You have a funny feeling like you.*");
    private String slayerTask = "";
    private String slayerTasksCompleted = "";
    private String slayerPoints = "";
    private boolean questCompleted = false;
    private boolean clueCompleted = false;
    private String clueCount = "";
    private String clueType = "";

    protected void startUp() throws Exception {
        Utils.client = this.client;
        log.info("Started up Universal Discord");
    }

    protected void shutDown() throws Exception {
        log.info("Shutting down Universal Discord");
    }

    @Provides
    UniversalDiscordConfig provideConfig(ConfigManager configManager) {
        return (UniversalDiscordConfig)configManager.getConfig(UniversalDiscordConfig.class);
    }

    @Subscribe
    public void onNotificationFired(NotificationFired notif) {
    }

    @Subscribe
    public void onUsernameChanged(UsernameChanged usernameChanged) {
        this.levelNotifier.reset();
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState().equals((Object)GameState.LOGIN_SCREEN)) {
            this.levelNotifier.reset();
        }
    }

    @Subscribe
    public void onStatChanged(StatChanged statChange) {
        this.levelNotifier.handleLevelUp(statChange.getSkill().getName(), statChange.getLevel());
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        this.levelNotifier.onTick();
    }

    @Subscribe
    public void onChatMessage(ChatMessage message) {
        ChatMessageType msgType = message.getType();
        String chatMessage = Text.removeTags((String)message.getMessage());
        if (msgType.equals((Object)ChatMessageType.GAMEMESSAGE)) {
            Matcher clueMatcher;
            Matcher collectionMatcher = COLLECTION_LOG_REGEX.matcher(chatMessage);
            if (this.config.notifyCollectionLog() && collectionMatcher.find()) {
                this.collectionNotifier.handleNotify(collectionMatcher.group("itemName"));
                return;
            }
            if (this.config.notifyPet() && PET_REGEX.matcher(chatMessage).matches()) {
                this.petNotifier.handleNotify();
                return;
            }
            if (this.config.notifySlayer() && (chatMessage.contains("Slayer master") || chatMessage.contains("Slayer Master") || chatMessage.contains("completed your task!"))) {
                Matcher taskMatcher = SLAYER_TASK_REGEX.matcher(chatMessage);
                Matcher pointsMatcher = SLAYER_COMPLETE_REGEX.matcher(chatMessage);
                if (taskMatcher.find()) {
                    this.slayerNotifier.slayerTask = this.slayerTask = taskMatcher.group("task");
                    this.slayerNotifier.handleNotify();
                }
                if (pointsMatcher.find()) {
                    this.slayerPoints = pointsMatcher.group("points");
                    this.slayerTasksCompleted = pointsMatcher.group("taskCount");
                    if (this.slayerPoints == null) {
                        this.slayerPoints = pointsMatcher.group("points2");
                    }
                    if (this.slayerPoints == null) {
                        this.slayerPoints = "0";
                    }
                    this.slayerNotifier.slayerPoints = this.slayerPoints;
                    this.slayerNotifier.slayerCompleted = this.slayerTasksCompleted;
                    this.slayerNotifier.handleNotify();
                }
            }
            if (this.config.notifyClue() && (clueMatcher = CLUE_SCROLL_REGEX.matcher(chatMessage)).find()) {
                String numberCompleted = clueMatcher.group("scrollCount");
                String scrollType = clueMatcher.group("scrollType");
                if (this.clueCompleted) {
                    this.clueNotifier.handleNotify(numberCompleted, scrollType);
                    this.clueCompleted = false;
                } else {
                    this.clueType = scrollType;
                    this.clueCount = numberCompleted;
                    this.clueCompleted = true;
                }
            }
        }
    }

    @Subscribe
    public void onActorDeath(ActorDeath actor) {
        if (this.config.notifyDeath() && Objects.equals(actor.getActor().getName(), Utils.getPlayerName())) {
            this.deathNotifier.handleNotify();
        }
    }

    @Subscribe
    public void onNpcLootReceived(NpcLootReceived npcLootReceived) {
        if (!this.config.notifyLoot()) {
            return;
        }
        NPC npc = npcLootReceived.getNpc();
        Collection items = npcLootReceived.getItems();
        this.lootNotifier.handleNotify(items, npc.getName());
    }

    @Subscribe
    public void onPlayerLootReceived(PlayerLootReceived playerLootReceived) {
        Collection items = playerLootReceived.getItems();
        this.lootNotifier.handleNotify(items, playerLootReceived.getPlayer().getName());
    }

    @Subscribe
    public void onLootReceived(LootReceived lootReceived) {
        if (lootReceived.getType() != LootRecordType.EVENT && lootReceived.getType() != LootRecordType.PICKPOCKET) {
            return;
        }
        this.lootNotifier.handleNotify(lootReceived.getItems(), lootReceived.getName());
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded event) {
        Widget clue;
        Widget quest;
        int groupId = event.getGroupId();
        if (groupId == 153 && this.config.notifyQuest() && (quest = this.client.getWidget(WidgetInfo.QUEST_COMPLETED_NAME_TEXT)) != null) {
            String questWidget = quest.getText();
            this.questNotifier.handleNotify(questWidget);
        }
        if (groupId == 73 && (clue = this.client.getWidget(WidgetInfo.CLUE_SCROLL_REWARD_ITEM_CONTAINER)) != null) {
            this.clueNotifier.clueItems.clear();
            Widget[] children = clue.getChildren();
            if (children == null) {
                return;
            }
            for (Widget child : children) {
                if (child == null) continue;
                int quantity = child.getItemQuantity();
                int itemId = child.getItemId();
                if (itemId <= -1 || quantity <= 0) continue;
                this.clueNotifier.clueItems.put(itemId, quantity);
            }
            if (this.clueCompleted) {
                this.clueNotifier.handleNotify(this.clueCount, this.clueType);
                this.clueCompleted = false;
            } else {
                this.clueCompleted = true;
            }
        }
    }
}

