/*
 * Decompiled with CFR 0.152.
 */
package universalDiscord;

import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;

@ConfigGroup(value="universalDiscord")
public interface UniversalDiscordConfig
extends Config {
    @ConfigSection(name="Collection Log", description="Settings for notifying about collection log", position=1)
    public static final String collectionSection = "Collection Log";
    @ConfigSection(name="Pet", description="Settings for notifying when obtaining a pet", position=4)
    public static final String petSection = "Pet";
    @ConfigSection(name="Levels", description="Settings for notifying when levelling a skill", position=7)
    public static final String levelSection = "Levels";
    @ConfigSection(name="Loot", description="Settings for notifying when loot is dropped", position=11)
    public static final String lootSection = "Loot";
    @ConfigSection(name="Death", description="Settings for notifying when you die", position=16)
    public static final String deathSection = "Death";
    @ConfigSection(name="Slayer", description="Settings for notifying when you complete a slayer task", position=19)
    public static final String slayerSection = "Slayer";
    @ConfigSection(name="Quests", description="Settings for notifying when you complete a quest", position=22)
    public static final String questSection = "Quests";
    @ConfigSection(name="Clue Scrolls", description="Settings for notifying when you complete a clue scroll", position=25)
    public static final String clueSection = "Clue Scrolls";

    @ConfigItem(keyName="discordWebhook", name="Discord Webhook", description="The Webhook URL for the discord channel", position=0)
    default public String discordWebhook() {
        return "";
    }

    @ConfigItem(keyName="collectionLogEnabled", name="Enable collection log", description="Enable notifications for collection log", position=1, section="Collection Log")
    default public boolean notifyCollectionLog() {
        return false;
    }

    @ConfigItem(keyName="collectionNotifMessage", name="Notification Message", description="The message to be sent through the webhook. Use %USERNAME% to insert your username and %ITEM% for the item", position=2, section="Collection Log")
    default public String collectionNotifyMessage() {
        return "%USERNAME% has added %ITEM% to their collection";
    }

    @ConfigItem(keyName="collectionSendImage", name="Send Image", description="Send image with the notification", position=3, section="Collection Log")
    default public boolean collectionSendImage() {
        return true;
    }

    @ConfigItem(keyName="petEnabled", name="Enable pets", description="Enable notifications for obtaining pets", position=4, section="Pet")
    default public boolean notifyPet() {
        return false;
    }

    @ConfigItem(keyName="petNotifMessage", name="Notification Message", description="The message to be sent through the webhook. Use %USERNAME% to insert your username", position=5, section="Pet")
    default public String petNotifyMessage() {
        return "%USERNAME% has a funny feeling they are being followed";
    }

    @ConfigItem(keyName="petSendImage", name="Send Image", description="Send image with the notification", position=6, section="Pet")
    default public boolean petSendImage() {
        return true;
    }

    @ConfigItem(keyName="levelEnabled", name="Enable level", description="Enable notifications for gaining levels", position=7, section="Levels")
    default public boolean notifyLevel() {
        return false;
    }

    @ConfigItem(keyName="levelInterval", name="Notify Interval", description="Interval between when a notification should be sent", position=8, section="Levels")
    default public int levelInterval() {
        return 1;
    }

    @ConfigItem(keyName="levelNotifMessage", name="Notification Message", description="The message to be sent through the webhook. Use %USERNAME% to insert your username and %SKILL% to insert the levelled skill(s)", position=9, section="Levels")
    default public String levelNotifyMessage() {
        return "%USERNAME% has levelled %SKILL%";
    }

    @ConfigItem(keyName="levelSendImage", name="Send Image", description="Send image with the notification", position=10, section="Levels")
    default public boolean levelSendImage() {
        return true;
    }

    @ConfigItem(keyName="lootEnabled", name="Enable loot", description="Enable notifications for gaining loot", position=11, section="Loot")
    default public boolean notifyLoot() {
        return false;
    }

    @ConfigItem(keyName="lootIcons", name="Show loot icons", description="Show icons for the loot obtained", position=12, section="Loot")
    default public boolean lootIcons() {
        return false;
    }

    @ConfigItem(keyName="minLootValue", name="Min Loot value", description="Minimum value of the loot to notify", position=13, section="Loot")
    default public int minLootValue() {
        return 0;
    }

    @ConfigItem(keyName="lootNotifMessage", name="Notification Message", description="The message to be sent through the webhook. Use %USERNAME% to insert your username, %LOOT% to insert the loot and %SOURCE% to show the source of the loot", position=14, section="Loot")
    default public String lootNotifyMessage() {
        return "%USERNAME% has looted: \n\n%LOOT%\nFrom: %SOURCE%";
    }

    @ConfigItem(keyName="lootSendImage", name="Send Image", description="Send image with the notification", position=15, section="Loot")
    default public boolean lootSendImage() {
        return true;
    }

    @ConfigItem(keyName="deathEnabled", name="Enable Death", description="Enable notifications for when you die", position=16, section="Death")
    default public boolean notifyDeath() {
        return false;
    }

    @ConfigItem(keyName="deathSendImage", name="Send Image", description="Send image with the notification", position=17, section="Death")
    default public boolean deathSendImage() {
        return false;
    }

    @ConfigItem(keyName="deathNotifMessage", name="Notification Message", description="The message to be sent through the webhook. Use %USERNAME% to insert your username", position=18, section="Death")
    default public String deathNotifyMessage() {
        return "%USERNAME% has died...";
    }

    @ConfigItem(keyName="slayerEnabled", name="Enable Slayer", description="Enable notifications for when you complete a slayer task", position=19, section="Slayer")
    default public boolean notifySlayer() {
        return false;
    }

    @ConfigItem(keyName="slayerSendImage", name="Send Image", description="Send image with the notification", position=20, section="Slayer")
    default public boolean slayerSendImage() {
        return false;
    }

    @ConfigItem(keyName="slayerNotifMessage", name="Notification Message", description="The message to be sent through the webhook. Use %USERNAME% to insert your username, %TASK% to insert your task, %POINTS% to show how many points you obtained and %TASKCOUNT% to show how many tasks you have completed.", position=21, section="Slayer")
    default public String slayerNotifyMessage() {
        return "%USERNAME% has completed a slayer task: %TASK%, getting %POINTS% points and making that %TASKCOUNT% tasks completed";
    }

    @ConfigItem(keyName="questEnabled", name="Enable Quest", description="Enable notifications for when you complete a quest", position=22, section="Quests")
    default public boolean notifyQuest() {
        return false;
    }

    @ConfigItem(keyName="questSendImage", name="Send Image", description="Send image with the notification", position=23, section="Quests")
    default public boolean questSendImage() {
        return false;
    }

    @ConfigItem(keyName="questNotifMessage", name="Notification Message", description="The message to be sent through the webhook. Use %USERNAME% to insert your username and %QUEST% to insert the quest that you completed", position=24, section="Quests")
    default public String questNotifyMessage() {
        return "%USERNAME% has completed a quest: %QUEST%";
    }

    @ConfigItem(keyName="clueEnabled", name="Enable Clue Scrolls", description="Enable notifications for when you complete a clue scroll", position=25, section="Clue Scrolls")
    default public boolean notifyClue() {
        return false;
    }

    @ConfigItem(keyName="clueSendImage", name="Send Image", description="Send image with the notification", position=26, section="Clue Scrolls")
    default public boolean clueSendImage() {
        return false;
    }

    @ConfigItem(keyName="clueShowItems", name="Show Item Icons", description="Show item icons gained from the clue", position=27, section="Clue Scrolls")
    default public boolean clueShowItems() {
        return false;
    }

    @ConfigItem(keyName="clueMinValue", name="Min Value", description="The minimum value of the items to be shown", position=28, section="Clue Scrolls")
    default public int clueMinValue() {
        return 0;
    }

    @ConfigItem(keyName="clueNotifMessage", name="Notification Message", description="The message to be sent through the webhook. Use %USERNAME% to insert your username, %CLUE% to insert the clue type, %LOOT% to show the loot obtained and %COUNT% to insert how many of those clue types you have completed", position=29, section="Clue Scrolls")
    default public String clueNotifyMessage() {
        return "%USERNAME% has completed a %CLUE% clue, they have completed %COUNT%.\nThey obtained:\n\n%LOOT%";
    }
}

