/*
 * Decompiled with CFR 0.152.
 */
package universalDiscord;

import com.google.common.collect.ImmutableList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import universalDiscord.BaseNotifier;
import universalDiscord.UniversalDiscordPlugin;
import universalDiscord.Utils;

public class QuestNotifier
extends BaseNotifier {
    private static final Pattern QUEST_PATTERN_1 = Pattern.compile(".+?ve\\.*? (?<verb>been|rebuilt|.+?ed)? ?(?:the )?'?(?<quest>.+?)'?(?: [Qq]uest)?[!.]?$");
    private static final Pattern QUEST_PATTERN_2 = Pattern.compile("'?(?<quest>.+?)'?(?: [Qq]uest)? (?<verb>[a-z]\\w+?ed)?(?: f.*?)?[!.]?$");
    private static final ImmutableList<String> RFD_TAGS = ImmutableList.of((Object)"Another Cook", (Object)"freed", (Object)"defeated", (Object)"saved");
    private static final ImmutableList<String> WORD_QUEST_IN_NAME_TAGS = ImmutableList.of((Object)"Another Cook", (Object)"Doric", (Object)"Heroes", (Object)"Legends", (Object)"Observatory", (Object)"Olaf", (Object)"Waterfall");

    public QuestNotifier(UniversalDiscordPlugin plugin) {
        super(plugin);
    }

    public void handleNotify(String questText) {
        String notifyMessage = this.plugin.config.questNotifyMessage().replaceAll("%USERNAME%", Utils.getPlayerName()).replaceAll("%QUEST%", this.parseQuestWidget(questText));
        this.plugin.messageHandler.createMessage(notifyMessage, this.plugin.config.questSendImage(), null);
    }

    private String parseQuestWidget(String text) {
        String verb;
        Matcher questMatchFinal;
        Matcher questMatch1 = QUEST_PATTERN_1.matcher(text);
        Matcher questMatch2 = QUEST_PATTERN_2.matcher(text);
        Matcher matcher = questMatchFinal = questMatch1.matches() ? questMatch1 : questMatch2;
        if (!questMatchFinal.matches()) {
            return "Unable to find quest name!";
        }
        Object quest = questMatchFinal.group("quest");
        String string = verb = questMatchFinal.group("verb") != null ? questMatchFinal.group("verb") : "";
        if (verb.contains("kind of")) {
            quest = (String)quest + " partial completion";
        } else if (verb.contains("completely")) {
            quest = (String)quest + " II";
        }
        if (RFD_TAGS.stream().anyMatch(((String)quest + verb)::contains)) {
            quest = "Recipe for Disaster - " + (String)quest;
        }
        if (WORD_QUEST_IN_NAME_TAGS.stream().anyMatch(((String)quest)::contains)) {
            quest = (String)quest + " Quest";
        }
        return quest;
    }
}

