/*
 * Decompiled with CFR 0.152.
 */
package universalDiscord;

import java.util.Collection;
import javax.inject.Inject;
import net.runelite.api.ItemComposition;
import net.runelite.client.game.ItemStack;
import net.runelite.client.util.QuantityFormatter;
import universalDiscord.BaseNotifier;
import universalDiscord.DiscordMessageBody;
import universalDiscord.UniversalDiscordPlugin;
import universalDiscord.Utils;

public class LootNotifier
extends BaseNotifier {
    private boolean sendMessage = false;

    @Inject
    public LootNotifier(UniversalDiscordPlugin plugin) {
        super(plugin);
    }

    public void handleNotify(Collection<ItemStack> items, String dropper) {
        DiscordMessageBody messageBody = new DiscordMessageBody();
        StringBuilder lootMessage = new StringBuilder();
        int minValue = this.plugin.config.minLootValue();
        long totalStackValue = 0L;
        for (ItemStack item : Utils.reduceItemStack(items)) {
            int itemId = item.getId();
            int quantity = item.getQuantity();
            int price = this.plugin.itemManager.getItemPrice(itemId);
            long totalPrice = (long)price * (long)quantity;
            if (totalPrice >= (long)minValue) {
                if (totalStackValue != 0L) {
                    lootMessage.append("\n");
                }
                this.sendMessage = true;
                ItemComposition itemComposition = this.plugin.itemManager.getItemComposition(itemId);
                lootMessage.append(String.format("%s x %s (%s)", quantity, itemComposition.getName(), QuantityFormatter.quantityToStackSize((long)totalPrice)));
                if (this.plugin.config.lootIcons()) {
                    messageBody.getEmbeds().add(new DiscordMessageBody.Embed(new DiscordMessageBody.UrlEmbed(Utils.getItemImageUrl(itemId))));
                }
            }
            totalStackValue += totalPrice;
        }
        if (this.sendMessage) {
            this.sendMessage = false;
            String lootString = lootMessage.toString();
            String notifyMessage = this.plugin.config.lootNotifyMessage().replaceAll("%USERNAME%", Utils.getPlayerName()).replaceAll("%LOOT%", lootString).replaceAll("%SOURCE%", dropper);
            this.plugin.messageHandler.createMessage(notifyMessage, this.plugin.config.lootSendImage(), messageBody);
        }
    }
}

