/*
 * Decompiled with CFR 0.152.
 */
package universalDiscord;

import java.util.ArrayList;
import java.util.Hashtable;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import universalDiscord.BaseNotifier;
import universalDiscord.UniversalDiscordPlugin;
import universalDiscord.Utils;

public class LevelNotifier
extends BaseNotifier {
    private static final Logger log = LoggerFactory.getLogger(LevelNotifier.class);
    private ArrayList<String> levelledSkills = new ArrayList();
    private Hashtable<String, Integer> currentLevels = new Hashtable();
    private boolean sendMessage = false;
    private int ticksWaited = 0;

    @Inject
    public LevelNotifier(UniversalDiscordPlugin plugin) {
        super(plugin);
    }

    public void reset() {
        this.currentLevels.clear();
        this.levelledSkills.clear();
    }

    private boolean checkLevelInterval(int level) {
        return this.plugin.config.levelInterval() <= 1 || level == 99 || level % this.plugin.config.levelInterval() == 0;
    }

    public void onTick() {
        if (!this.sendMessage) {
            return;
        }
        ++this.ticksWaited;
        if (this.ticksWaited > 2) {
            this.ticksWaited = 0;
            this.attemptNotify();
        }
    }

    public void attemptNotify() {
        this.sendMessage = false;
        StringBuilder skillMessage = new StringBuilder();
        int index = 0;
        for (String skill : this.levelledSkills) {
            if (index == this.levelledSkills.size()) {
                skillMessage.append(" and ");
            } else if (index > 0) {
                skillMessage.append(", ");
            }
            skillMessage.append(String.format("%s to %s", skill, this.currentLevels.get(skill)));
            ++index;
        }
        String skillString = skillMessage.toString();
        this.levelledSkills.clear();
        String fullNotification = this.plugin.config.levelNotifyMessage().replaceAll("%USERNAME%", Utils.getPlayerName()).replaceAll("%SKILL%", skillString);
        this.plugin.messageHandler.createMessage(fullNotification, this.plugin.config.levelSendImage(), null);
    }

    public void handleLevelUp(String skill, int level) {
        if (this.checkLevelInterval(level) && this.currentLevels.get(skill) != null) {
            if (level == this.currentLevels.get(skill)) {
                return;
            }
            this.levelledSkills.add(skill);
            this.sendMessage = true;
        }
        this.currentLevels.put(skill, level);
    }
}

