/*
 * Decompiled with CFR 0.152.
 */
package universalDiscord;

import com.google.common.base.Strings;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import javax.inject.Inject;
import net.runelite.http.api.RuneLiteAPI;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import universalDiscord.DiscordMessageBody;
import universalDiscord.UniversalDiscordPlugin;
import universalDiscord.Utils;

public class DiscordMessageHandler {
    private static final Logger log = LoggerFactory.getLogger(DiscordMessageHandler.class);
    private UniversalDiscordPlugin plugin;

    @Inject
    public DiscordMessageHandler(UniversalDiscordPlugin plugin) {
        this.plugin = plugin;
    }

    public void createMessage(String message, boolean sendImage, DiscordMessageBody mBody) {
        String[] strList;
        DiscordMessageBody messageBody = new DiscordMessageBody();
        if (mBody != null) {
            messageBody = mBody;
        }
        messageBody.setContent(message);
        String webhookUrl = this.plugin.config.discordWebhook();
        if (Strings.isNullOrEmpty((String)webhookUrl)) {
            return;
        }
        ArrayList<HttpUrl> urlList = new ArrayList<HttpUrl>();
        for (String urlString : strList = webhookUrl.split("\n")) {
            if (Objects.equals(urlString, "")) continue;
            urlList.add(HttpUrl.parse((String)urlString));
        }
        MultipartBody.Builder reqBodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("payload_json", RuneLiteAPI.GSON.toJson((Object)messageBody));
        if (sendImage) {
            this.plugin.drawManager.requestNextFrameListener(image -> {
                byte[] imageBytes;
                BufferedImage bufferedImage = (BufferedImage)image;
                try {
                    imageBytes = Utils.convertImageToByteArray(bufferedImage);
                }
                catch (IOException e) {
                    log.warn("There was an error creating bytes from captured image", (Throwable)e);
                    this.sendToMultiple(urlList, reqBodyBuilder);
                    return;
                }
                reqBodyBuilder.addFormDataPart("file", "collectionImage.png", RequestBody.create((MediaType)MediaType.parse((String)"image/png"), (byte[])imageBytes));
                this.sendToMultiple(urlList, reqBodyBuilder);
            });
            return;
        }
        this.sendToMultiple(urlList, reqBodyBuilder);
    }

    private void sendToMultiple(ArrayList<HttpUrl> urls, MultipartBody.Builder requestBody) {
        for (HttpUrl url : urls) {
            this.sendMessage(url, requestBody);
        }
    }

    private void sendMessage(HttpUrl url, MultipartBody.Builder requestBody) {
        MultipartBody body = requestBody.build();
        Request request = new Request.Builder().url(url).post((RequestBody)body).build();
        this.plugin.httpClient.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                log.warn("There was an error sending the webhook message", (Throwable)e);
            }

            public void onResponse(Call call, Response response) throws IOException {
                response.close();
            }
        });
    }
}

