/*
 * Decompiled with CFR 0.152.
 */
package universalDiscord;

import java.util.HashMap;
import net.runelite.api.ItemComposition;
import net.runelite.client.util.QuantityFormatter;
import universalDiscord.BaseNotifier;
import universalDiscord.DiscordMessageBody;
import universalDiscord.UniversalDiscordPlugin;
import universalDiscord.Utils;

public class ClueNotifier
extends BaseNotifier {
    public HashMap<Integer, Integer> clueItems = new HashMap();
    private DiscordMessageBody messageBody;

    public ClueNotifier(UniversalDiscordPlugin plugin) {
        super(plugin);
    }

    public void handleNotify(String numberCompleted, String clueType) {
        this.messageBody = new DiscordMessageBody();
        StringBuilder lootMessage = new StringBuilder();
        long totalPrice = 0L;
        for (Integer itemId : this.clueItems.keySet()) {
            if (lootMessage.length() > 0) {
                lootMessage.append("\n");
            }
            int quantity = this.clueItems.get(itemId);
            int price = this.plugin.itemManager.getItemPrice(itemId.intValue());
            totalPrice += (long)price * (long)quantity;
            lootMessage.append(this.getItem(itemId, this.clueItems.get(itemId)));
        }
        if (totalPrice < (long)this.plugin.config.clueMinValue()) {
            return;
        }
        String notifyMessage = this.plugin.config.clueNotifyMessage().replaceAll("%USERNAME%", Utils.getPlayerName()).replaceAll("%CLUE%", clueType).replaceAll("%COUNT%", numberCompleted).replaceAll("%LOOT%", lootMessage.toString());
        this.plugin.messageHandler.createMessage(notifyMessage, this.plugin.config.clueSendImage(), null);
    }

    public String getItem(int itemId, int quantity) {
        int price = this.plugin.itemManager.getItemPrice(itemId);
        long totalPrice = (long)price * (long)quantity;
        ItemComposition itemComposition = this.plugin.itemManager.getItemComposition(itemId);
        if (this.plugin.config.clueShowItems()) {
            this.messageBody.getEmbeds().add(new DiscordMessageBody.Embed(new DiscordMessageBody.UrlEmbed(Utils.getItemImageUrl(itemId))));
        }
        return String.format("%s x %s (%s)", quantity, itemComposition.getName(), QuantityFormatter.quantityToStackSize((long)totalPrice));
    }
}

