/*
 * Decompiled with CFR 0.152.
 */
package com.bird.runalert;

import com.bird.runalert.BirdRunAlertConfig;
import com.google.inject.Provides;
import java.io.BufferedInputStream;
import java.io.IOException;
import javax.inject.Inject;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.runelite.api.Client;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.client.Notifier;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Bird Run Alert")
public class BirdRunAlertPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(BirdRunAlertPlugin.class);
    @Inject
    private Client client;
    @Inject
    private BirdRunAlertConfig config;
    @Inject
    private Notifier notifier;
    private Clip clip = null;

    protected void startUp() throws Exception {
        log.info("Bird Run Alert started!");
    }

    protected void shutDown() throws Exception {
        log.info("Bird Run Alert stopped!");
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
    }

    @Subscribe
    public void onChatMessage(ChatMessage message) {
        if (message.getMessage().toLowerCase().contains("bird houses are ready to be dismantled") && message.getType().toString().equals("CONSOLE")) {
            BufferedInputStream fileStream = new BufferedInputStream(BirdRunAlertPlugin.class.getClassLoader().getResourceAsStream("bird_run_alert.wav"));
            try (AudioInputStream sound = AudioSystem.getAudioInputStream(fileStream);){
                this.clip = AudioSystem.getClip();
                FloatControl control = (FloatControl)this.clip.getControl(FloatControl.Type.VOLUME);
                float newVolume = (float)this.config.volume() / control.getMaximum() * control.getMinimum() + control.getMinimum();
                control.setValue(newVolume);
                this.clip.open(sound);
                this.clip.setFramePosition(this.clip.getFrameLength());
                this.clip.loop(1);
            }
            catch (IOException | LineUnavailableException | UnsupportedAudioFileException e) {
                log.warn("Unable to load bird run alert sound", (Throwable)e);
            }
        }
    }

    @Provides
    BirdRunAlertConfig provideConfig(ConfigManager configManager) {
        return (BirdRunAlertConfig)configManager.getConfig(BirdRunAlertConfig.class);
    }
}

