/*
 * Decompiled with CFR 0.152.
 */
package com.stardust;

import com.google.inject.Provides;
import com.stardust.StardustConfig;
import com.stardust.StardustOverlay;
import com.stardust.StardustPerHourUpdate;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Stardust Per Hour Calculator")
public class StardustPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(StardustPlugin.class);
    @Inject
    private Client client;
    @Inject
    private EventBus eventBus;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private StardustOverlay overlay;
    @Inject
    private StardustConfig config;
    private boolean isCounting;
    private int initialStardustCount;
    private long startTimeMillis;
    public double stardustPerHour = 0.0;
    private final int STARDUST_ID = 25527;

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        if (event.getItemContainer() == this.client.getItemContainer(InventoryID.INVENTORY) && event.getItemContainer().contains(25527)) {
            int count = event.getItemContainer().count(25527);
            if (!this.isCounting) {
                this.isCounting = true;
                this.initialStardustCount = count;
                this.startTimeMillis = System.currentTimeMillis();
            } else {
                this.stardustPerHour = this.stardustPerHour(this.startTimeMillis, System.currentTimeMillis(), this.initialStardustCount, count);
                this.eventBus.post((Object)new StardustPerHourUpdate(this.stardustPerHour));
            }
        }
    }

    public double stardustPerHour(long startTimeMillis, long currentTimeMillis, int startCount, int newCount) {
        long elapsedTimeMillis = currentTimeMillis - startTimeMillis;
        double elapsedTimeHours = (double)elapsedTimeMillis / 3600000.0;
        int stardustReceived = newCount - startCount;
        return (double)stardustReceived / elapsedTimeHours;
    }

    protected void startUp() throws Exception {
        this.eventBus.register((Object)this);
        this.eventBus.register((Object)this.overlay);
        this.overlayManager.add((Overlay)this.overlay);
    }

    protected void shutDown() throws Exception {
        this.eventBus.unregister((Object)this);
        this.eventBus.unregister((Object)this.overlay);
        this.overlayManager.remove((Overlay)this.overlay);
    }

    @Provides
    StardustConfig provideConfig(ConfigManager configManager) {
        return (StardustConfig)configManager.getConfig(StardustConfig.class);
    }
}

