/*
 * Decompiled with CFR 0.152.
 */
package com.stardust;

import com.stardust.StardustPerHourUpdate;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.text.DecimalFormat;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.PanelComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;

public class StardustOverlay
extends Overlay {
    private final Client client;
    private final int STARDUST_ID = 25527;
    private double stardustPerHour;
    private final PanelComponent panelComponent = new PanelComponent();
    DecimalFormat decimalFormat = new DecimalFormat("#");

    @Inject
    private StardustOverlay(Client client) {
        this.setPosition(OverlayPosition.ABOVE_CHATBOX_RIGHT);
        this.client = client;
    }

    @Subscribe
    public void onStardustPerHourUpdate(StardustPerHourUpdate event) {
        this.stardustPerHour = event.getStardustPerHour();
    }

    public Dimension render(Graphics2D graphics) {
        this.panelComponent.getChildren().clear();
        String overlayTitle = "Stardust/HR:";
        this.panelComponent.getChildren().add(TitleComponent.builder().text(overlayTitle).color(Color.GREEN).build());
        this.panelComponent.setPreferredSize(new Dimension(graphics.getFontMetrics().stringWidth(overlayTitle) + 30, 0));
        if (this.client.getGameState() == GameState.LOGGED_IN && this.client.getItemContainer(InventoryID.INVENTORY).contains(25527)) {
            int displayRate = (int)Double.parseDouble(this.decimalFormat.format(this.stardustPerHour));
            this.panelComponent.getChildren().add(LineComponent.builder().left("Dust/Hr:").right(String.valueOf(displayRate)).build());
        }
        return this.panelComponent.render(graphics);
    }
}

