/*
 * Decompiled with CFR 0.152.
 */
package com.mouseovertextdisabler;

import com.google.inject.Provides;
import com.mouseovertextdisabler.MouseoverTextDisablerConfig;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.WidgetClosed;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Mouseover Text Disabler", description="Disables the mouseover text")
public class MouseoverTextDisablerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(MouseoverTextDisablerPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private MouseoverTextDisablerConfig config;
    private boolean mouseoverTextDisabled = false;
    private boolean loginClickToPlayLoaded = false;

    protected void startUp() throws Exception {
        this.clientThread.invokeLater(() -> {
            if (this.client.getGameState() == GameState.LOGGED_IN && !this.mouseoverTextDisabled) {
                this.mouseoverTextDisabled = true;
                this.client.runScript(new Object[]{49, "::mouseovertext"});
            }
        });
    }

    protected void shutDown() throws Exception {
        this.clientThread.invokeLater(() -> {
            if (this.client.getGameState() == GameState.LOGGED_IN && this.mouseoverTextDisabled) {
                this.mouseoverTextDisabled = false;
                this.client.runScript(new Object[]{49, "::mouseovertext"});
            }
        });
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGIN_SCREEN || gameStateChanged.getGameState() == GameState.HOPPING) {
            this.mouseoverTextDisabled = false;
        }
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        if (this.client.getGameState() == GameState.LOGGED_IN && !this.loginClickToPlayLoaded && !this.mouseoverTextDisabled) {
            this.mouseoverTextDisabled = true;
            this.client.runScript(new Object[]{49, "::mouseovertext"});
        }
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded widgetLoaded) {
        if (widgetLoaded.getGroupId() == 378) {
            this.loginClickToPlayLoaded = true;
        }
    }

    @Subscribe
    public void onWidgetClosed(WidgetClosed widgetClosed) {
        if (widgetClosed.getGroupId() == 378) {
            this.loginClickToPlayLoaded = false;
        }
    }

    @Provides
    MouseoverTextDisablerConfig provideConfig(ConfigManager configManager) {
        return (MouseoverTextDisablerConfig)configManager.getConfig(MouseoverTextDisablerConfig.class);
    }
}

