/*
 * Decompiled with CFR 0.152.
 */
package com.watsoncluetracker;

import com.google.inject.Inject;
import com.watsoncluetracker.ClueTier;
import com.watsoncluetracker.WatsonConfig;
import com.watsoncluetracker.WatsonPlugin;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import net.runelite.api.widgets.WidgetItem;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.ItemVariationMapping;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.overlay.WidgetItemOverlay;
import net.runelite.client.ui.overlay.components.TextComponent;

public class WatsonWidgetItemOverlay
extends WidgetItemOverlay {
    @Inject
    private ItemManager itemManager;
    private final WatsonPlugin plugin;
    private final WatsonConfig config;

    @Inject
    WatsonWidgetItemOverlay(WatsonPlugin watsonPlugin, WatsonConfig config) {
        this.plugin = watsonPlugin;
        this.config = config;
        this.showOnInventory();
        this.showOnBank();
    }

    public void renderItemOverlay(Graphics2D graphics, int itemId, WidgetItem widgetItem) {
        WatsonConfig.ShowItemOverlay showItemOverlay = this.config.whenToShowItemOverlay();
        if (showItemOverlay == WatsonConfig.ShowItemOverlay.NEVER) {
            return;
        }
        int baseItemId = ItemVariationMapping.map((int)itemId);
        if (baseItemId != 713) {
            return;
        }
        String itemName = this.itemManager.getItemComposition(itemId).getMembersName();
        ClueTier clueTier = ClueTier.getClueTier(itemName);
        if (clueTier == null) {
            return;
        }
        boolean watsonHasClue = this.plugin.watsonHasClue(clueTier);
        if (watsonHasClue && showItemOverlay == WatsonConfig.ShowItemOverlay.WATSON_NEEDS_CLUE || !watsonHasClue && showItemOverlay == WatsonConfig.ShowItemOverlay.WATSON_HAS_CLUE) {
            return;
        }
        Rectangle bounds = widgetItem.getCanvasBounds();
        if (showItemOverlay == WatsonConfig.ShowItemOverlay.ALL_TIERS) {
            int x = bounds.x + 3;
            for (ClueTier tier : ClueTier.values()) {
                graphics.setColor(tier.getColor(true));
                if (this.plugin.watsonHasClue(tier)) {
                    graphics.fillRect(x, bounds.y + 24, 5, 5);
                } else {
                    graphics.drawRect(x, bounds.y + 24, 4, 4);
                }
                x += 7;
            }
        } else {
            graphics.setFont(FontManager.getRunescapeSmallFont());
            TextComponent textComponent = new TextComponent();
            textComponent.setPosition(new Point(bounds.x, bounds.y + (int)bounds.getHeight()));
            textComponent.setText("w");
            textComponent.setColor(watsonHasClue ? this.config.watsonHasClueColor() : this.config.watsonNeedsClueColor());
            textComponent.render(graphics);
        }
    }
}

