/*
 * Decompiled with CFR 0.152.
 */
package com.watsoncluetracker;

import com.google.inject.Provides;
import com.watsoncluetracker.ClueTier;
import com.watsoncluetracker.WatsonConfig;
import com.watsoncluetracker.WatsonOverlay;
import com.watsoncluetracker.WatsonWidgetItemOverlay;
import java.awt.Color;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.events.CommandExecuted;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ProfileChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.ColorUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Watson Clue Tracker", description="Tracks which clues Watson has", tags={"clue", "watson", "master"})
public class WatsonPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(WatsonPlugin.class);
    public static final String CONFIG_KEY = "watsonClueTracker";
    @Inject
    private Client client;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private WatsonOverlay overlay;
    @Inject
    private WatsonWidgetItemOverlay itemOverlay;
    @Inject
    private ClientThread clientThread;
    @Inject
    private VarbitChanged varbitChanged;
    @Inject
    private WatsonConfig config;
    @Inject
    ConfigManager configManager;
    public static final int CLUE_SCROLL_ITEM_BASE_ID = 713;
    private static final int WATSON_HAS_EASY_VARBIT = 5186;
    private static final int WATSON_HAS_MEDIUM_VARBIT = 5187;
    private static final int WATSON_HAS_HARD_VARBIT = 5188;
    private static final int WATSON_HAS_ELITE_VARBIT = 5189;

    @Provides
    WatsonConfig provideConfig(ConfigManager configManager) {
        return (WatsonConfig)configManager.getConfig(WatsonConfig.class);
    }

    public void startUp() {
        this.migrateItemOverlayConfig();
        this.overlayManager.add((Overlay)this.overlay);
        this.overlayManager.add((Overlay)this.itemOverlay);
    }

    private void migrateItemOverlayConfig() {
        String wasPreviouslyInstalled = this.configManager.getConfiguration(CONFIG_KEY, "showClueScrollItemOverlay");
        if (wasPreviouslyInstalled != null) {
            WatsonConfig.ShowItemOverlay newValue = wasPreviouslyInstalled.equals(Boolean.TRUE.toString()) ? WatsonConfig.ShowItemOverlay.WATSON_HAS_CLUE : WatsonConfig.ShowItemOverlay.NEVER;
            this.configManager.setConfiguration(CONFIG_KEY, "whenToShowItemOverlay", (Object)newValue);
            this.configManager.unsetConfiguration(CONFIG_KEY, "showClueScrollItemOverlay");
        }
        this.configManager.setConfiguration(CONFIG_KEY, "serialVersion", (Object)1);
    }

    public void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
        this.overlayManager.remove((Overlay)this.itemOverlay);
    }

    @Subscribe
    public void onProfileChanged(ProfileChanged e) {
        this.migrateItemOverlayConfig();
    }

    @Subscribe
    public void onCommandExecuted(CommandExecuted commandExecuted) {
        if (this.config.watsonChatCommand() && "watson".equalsIgnoreCase(commandExecuted.getCommand())) {
            this.chatMessage(this.generateWatsonNeedsText(" "));
        }
    }

    private void chatMessage(String message) {
        this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", message, "");
    }

    public boolean watsonHasClue(ClueTier tier) {
        if (tier == ClueTier.EASY) {
            return this.client.getVarbitValue(5186) == 1;
        }
        if (tier == ClueTier.MEDIUM) {
            return this.client.getVarbitValue(5187) == 1;
        }
        if (tier == ClueTier.HARD) {
            return this.client.getVarbitValue(5188) == 1;
        }
        if (tier == ClueTier.ELITE) {
            return this.client.getVarbitValue(5189) == 1;
        }
        return false;
    }

    public String generateWatsonNeedsText(String separator) {
        boolean hasElite;
        boolean hasEasy = this.client.getVarbitValue(5186) == 1;
        boolean hasMedium = this.client.getVarbitValue(5187) == 1;
        boolean hasHard = this.client.getVarbitValue(5188) == 1;
        boolean bl = hasElite = this.client.getVarbitValue(5189) == 1;
        if (hasEasy && hasMedium && hasHard && hasElite) {
            return "Watson is ready to give you a master clue.";
        }
        boolean transparent = this.client.isResized() && this.client.getVarbitValue(4608) == 1;
        String message = "Watson needs:" + separator;
        if (!hasEasy) {
            message = message + ColorUtil.wrapWithColorTag((String)"easy", (Color)ClueTier.EASY.getColor(transparent)) + separator;
        }
        if (!hasMedium) {
            message = message + ColorUtil.wrapWithColorTag((String)"medium", (Color)ClueTier.MEDIUM.getColor(transparent)) + separator;
        }
        if (!hasHard) {
            message = message + ColorUtil.wrapWithColorTag((String)"hard", (Color)ClueTier.HARD.getColor(transparent)) + separator;
        }
        if (!hasElite) {
            message = message + ColorUtil.wrapWithColorTag((String)"elite", (Color)ClueTier.ELITE.getColor(transparent)) + separator;
        }
        return message;
    }
}

