/*
 * Decompiled with CFR 0.152.
 */
package com.watsoncluetracker;

import com.watsoncluetracker.ClueTier;
import com.watsoncluetracker.WatsonConfig;
import com.watsoncluetracker.WatsonPlugin;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MenuEntry;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.ItemVariationMapping;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.tooltip.Tooltip;
import net.runelite.client.ui.overlay.tooltip.TooltipManager;

public class WatsonOverlay
extends Overlay {
    @Inject
    private Client client;
    @Inject
    private ItemManager itemManager;
    @Inject
    private TooltipManager tooltipManager;
    @Inject
    private WatsonConfig config;
    @Inject
    private WatsonPlugin plugin;

    public Dimension render(Graphics2D graphics) {
        if (!this.config.showClueScrollTooltip()) {
            return null;
        }
        MenuEntry[] menu = this.client.getMenuEntries();
        int menuSize = menu.length;
        if (menuSize <= 0) {
            return null;
        }
        MenuEntry entry = menu[menuSize - 1];
        Widget widget = entry.getWidget();
        if (widget == null) {
            return null;
        }
        int widgetGroupId = WidgetInfo.TO_GROUP((int)widget.getId());
        int itemId = -1;
        if (widget.getId() == WidgetInfo.INVENTORY.getId() || widgetGroupId == WidgetInfo.EQUIPMENT_INVENTORY_ITEMS_CONTAINER.getGroupId() || widget.getId() == WidgetInfo.BANK_ITEM_CONTAINER.getId() || widgetGroupId == WidgetInfo.BANK_INVENTORY_ITEMS_CONTAINER.getGroupId()) {
            itemId = widget.getItemId();
        }
        if (itemId == -1) {
            return null;
        }
        int baseItemId = ItemVariationMapping.map((int)itemId);
        if (baseItemId != 713) {
            return null;
        }
        String itemName = this.itemManager.getItemComposition(itemId).getMembersName();
        ClueTier clueTier = ClueTier.getClueTier(itemName);
        if (clueTier == null && itemId != 19835) {
            return null;
        }
        this.tooltipManager.add(new Tooltip(this.plugin.generateWatsonNeedsText("</br>")));
        return null;
    }
}

