/*
 * Decompiled with CFR 0.152.
 */
package com.watsoncluetracker;

import java.awt.Color;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;

@ConfigGroup(value="watsonClueTracker")
public interface WatsonConfig
extends Config {
    public static final String WHEN_TO_SHOW_ITEM_OVERLAY_KEY = "whenToShowItemOverlay";

    @ConfigItem(keyName="showClueScrollTooltip", name="Clue tooltip", description="Show tooltip on clues listing which clues Watson has.", position=1)
    default public boolean showClueScrollTooltip() {
        return true;
    }

    @ConfigItem(keyName="whenToShowItemOverlay", name="Item Overlay", description="When to show the 'w' icon on clues in the inventory. If watson needs the clue, it will show in gray, if he has the clue it will show in light blue. \"All tiers\" shows the status of all clue tiers on each clue.", position=2)
    default public ShowItemOverlay whenToShowItemOverlay() {
        return ShowItemOverlay.BOTH;
    }

    @ConfigItem(keyName="watsonNeedsClueColor", name="Watson needs clue", description="The color for the item overlay to show that watson needs the clue.", position=3)
    default public Color watsonNeedsClueColor() {
        return Color.LIGHT_GRAY.darker();
    }

    @ConfigItem(keyName="watsonHasClueColor", name="Watson has clue", description="The color for the item overlay to show that watson already has the clue.", position=4)
    default public Color watsonHasClueColor() {
        return new Color(5875947);
    }

    @ConfigItem(keyName="watsonChatCommand", name="::watson", description="Enables ::watson command to check which clues Watson is holding on to.", position=5)
    default public boolean watsonChatCommand() {
        return true;
    }

    public static enum ShowItemOverlay {
        WATSON_HAS_CLUE,
        WATSON_NEEDS_CLUE,
        BOTH,
        NEVER,
        ALL_TIERS;

    }
}

