/*
 * Decompiled with CFR 0.152.
 */
package com.watsoncluetracker;

import java.awt.Color;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum ClueTier {
    EASY("Clue scroll (easy)", new Color(3319862), new Color(3319862).darker()),
    MEDIUM("Clue scroll (medium)", new Color(4181135), new Color(4181135).darker()),
    HARD("Clue scroll (hard)", new Color(10895802), new Color(10895802)),
    ELITE("Clue scroll (elite)", new Color(12892231), new Color(12892231).darker());

    private final String clueName;
    private final Color colorTransparent;
    private final Color colorOpaque;
    private static final Map<String, ClueTier> map;

    public static ClueTier getClueTier(String name) {
        return map.get(name);
    }

    public Color getColor(boolean transparentChatbox) {
        return transparentChatbox ? this.colorTransparent : this.colorOpaque;
    }

    private ClueTier(String clueName, Color colorTransparent, Color colorOpaque) {
        this.clueName = clueName;
        this.colorTransparent = colorTransparent;
        this.colorOpaque = colorOpaque;
    }

    public String getClueName() {
        return this.clueName;
    }

    public Color getColorTransparent() {
        return this.colorTransparent;
    }

    public Color getColorOpaque() {
        return this.colorOpaque;
    }

    static {
        map = Arrays.stream(ClueTier.values()).collect(Collectors.toMap(e -> e.clueName, e -> e));
    }
}

